//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cTextureFont.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cTextureFont_hpp
#define cTextureFont_hpp
//==============================================================================
// Includes
#include "Types.hpp"
#include <string>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! TextureFont
class cTextureFont
{
	// Constructor & Destructor
	public:
		//! Constructor
		cTextureFont (void);
		//! Constructor
		cTextureFont (string filename, int width, int height);
		//! Destructor
		~cTextureFont (void);
	
	// Public methods
	public:
		//! Initialize font
		void Initialize (string filename, int width, int height);
		//! Print string
		void PrintString (string text);
		//! Print formatted string
		void Print (const char *pFormat, ...);
	
		//! Print string with wave effect
		void PrintStringW (string text, float a = 0.0f, float deltaA = 0.5f);
		
	// Private methods
	private:
		void MakeDisplayLists (int texWidth, int texHeight);
	
	// Member variables
	private:
		Uint32 mTexture;
		Uint32 mListBase;
		int mWidth;
		int mHeight;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cTextureFont_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
