//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//==============================================================================

//==============================================================================
//File: cDisplayManager.hpp
//Project: Shooting Star
//Author: Tuomas Peippo <tuomas.peippo@2ndpoint.fi>
//Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
//Revision history
//=============================================================================
#ifndef cDisplayManager_hpp
#define cDisplayManager_hpp

//============================================================================
// Includes
#include "Types.hpp"
#include "Debug.hpp"
#include <SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <stdexcept>
#include <string>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar	{
//============================================================================

class cDisplayManager
{
	// Constructor & Destructor
	public:
		//! Constructor
		cDisplayManager (void);
		//! Desturctor
		~cDisplayManager (void);

	// Public methods
	public:
		static cDisplayManager &GetInstance (void);
		void SetVideoMode( int width, int height, int bpp, Uint32 flags );
		void SetViewport(  GLint x, GLint y, GLsizei width, GLsizei height );
		void SetOrtho( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top );
		Uint16 GetScreenWidth (void) { return mpScreen->w; };
		Uint16 GetScreenHeight (void) { return mpScreen->h; };
		Uint16 GetViewportWidth (void);
		Uint16 GetViewportHeight (void);
		Uint16 GetOrthoWidth (void);
		Uint16 GetOrthoHeight (void);
		void BeginFrame (bool clear = true);
		void EndFrame (void);

	// Member variables
	private:
		SDL_Surface *mpScreen;	//!< The video framebuffer
};

//==============================================================================
}	// End of the ShootingStar namespace
#endif // cDisplayManager_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
