//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cActionMapper.cpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cActionMapper.hpp"
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cActionMapper::cActionMapper (void)
{
	// Empty
};

//! Destructor
cActionMapper::~cActionMapper (void)
{
	// Empty
};

//! Register keyboard action
void 
cActionMapper::RegisterKeyboardAction (SDLKey key, Uint8 state, const cAction &action)
{
	switch ( state )
	{
		case SDL_PRESSED:
			mKeyDownActions[key] = action;
			break;
		case SDL_RELEASED:
			mKeyUpActions[key] = action;
			break;
		default:
			dbgError () << "RegisterKeyboardAction: Invalid state\n";
			dbg::sentinel (DBG_HERE);
			break;
	}
}

void 
cActionMapper::RegisterMouseAction (Uint8 button, Uint8 state, const cAction &action)
{
	switch ( state )
	{
		case SDL_PRESSED:
			mButtonDownActions[button] = action;
			break;
		case SDL_RELEASED:
			mButtonUpActions[button] = action;
			break;
		default:
			dbgError () << "RegisterMouseAction: Invalid state\n";
			dbg::sentinel (DBG_HERE);
			break;
	}
}
	
//! Map keyboard event to action
const cAction &
cActionMapper::MapKeyboardEvent (const SDL_KeyboardEvent *pEvent)
{
	switch ( pEvent->state )
	{
		case SDL_PRESSED:
			return mKeyDownActions[pEvent->keysym.sym];
		case SDL_RELEASED:
			return mKeyUpActions[pEvent->keysym.sym];
		default:
			dbg::sentinel (DBG_HERE);
			break;
	}
	
	static cAction emptyAction;
	return emptyAction;
}

const cAction &
cActionMapper::MapMouseEvent (const SDL_MouseButtonEvent *pEvent)
{
	switch ( pEvent->state )
	{
		case SDL_PRESSED:
			return mButtonDownActions[pEvent->button];
		case SDL_RELEASED:
			return mButtonUpActions[pEvent->button];
		default:
			dbg::sentinel (DBG_HERE);
			break;
	}
	
	static cAction emptyAction;
	return emptyAction;
}

//==============================================================================
// EOF
//==============================================================================
