// Package randr is the X client API for the RANDR extension.
package randr

// This file is automatically generated from randr.xml. Edit at your peril!

import (
	"github.com/jezek/xgb"

	"github.com/jezek/xgb/render"
	"github.com/jezek/xgb/xproto"
)

// Init must be called before using the RANDR extension.
func Init(c *xgb.Conn) error {
	reply, err := xproto.QueryExtension(c, 5, "RANDR").Reply()
	switch {
	case err != nil:
		return err
	case !reply.Present:
		return xgb.Errorf("No extension named RANDR could be found on on the server.")
	}

	c.ExtLock.Lock()
	c.Extensions["RANDR"] = reply.MajorOpcode
	c.ExtLock.Unlock()
	for evNum, fun := range xgb.NewExtEventFuncs["RANDR"] {
		xgb.NewEventFuncs[int(reply.FirstEvent)+evNum] = fun
	}
	for errNum, fun := range xgb.NewExtErrorFuncs["RANDR"] {
		xgb.NewErrorFuncs[int(reply.FirstError)+errNum] = fun
	}
	return nil
}

func init() {
	xgb.NewExtEventFuncs["RANDR"] = make(map[int]xgb.NewEventFun)
	xgb.NewExtErrorFuncs["RANDR"] = make(map[int]xgb.NewErrorFun)
}

// BadBadCrtc is the error number for a BadBadCrtc.
const BadBadCrtc = 1

type BadCrtcError struct {
	Sequence uint16
	NiceName string
}

// BadCrtcErrorNew constructs a BadCrtcError value that implements xgb.Error from a byte slice.
func BadCrtcErrorNew(buf []byte) xgb.Error {
	v := BadCrtcError{}
	v.NiceName = "BadCrtc"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadCrtc error.
// This is mostly used internally.
func (err BadCrtcError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadCrtc error. If no bad value exists, 0 is returned.
func (err BadCrtcError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadCrtc error.

func (err BadCrtcError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadCrtc {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RANDR"][1] = BadCrtcErrorNew
}

// BadBadMode is the error number for a BadBadMode.
const BadBadMode = 2

type BadModeError struct {
	Sequence uint16
	NiceName string
}

// BadModeErrorNew constructs a BadModeError value that implements xgb.Error from a byte slice.
func BadModeErrorNew(buf []byte) xgb.Error {
	v := BadModeError{}
	v.NiceName = "BadMode"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadMode error.
// This is mostly used internally.
func (err BadModeError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadMode error. If no bad value exists, 0 is returned.
func (err BadModeError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadMode error.

func (err BadModeError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadMode {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RANDR"][2] = BadModeErrorNew
}

// BadBadOutput is the error number for a BadBadOutput.
const BadBadOutput = 0

type BadOutputError struct {
	Sequence uint16
	NiceName string
}

// BadOutputErrorNew constructs a BadOutputError value that implements xgb.Error from a byte slice.
func BadOutputErrorNew(buf []byte) xgb.Error {
	v := BadOutputError{}
	v.NiceName = "BadOutput"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadOutput error.
// This is mostly used internally.
func (err BadOutputError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadOutput error. If no bad value exists, 0 is returned.
func (err BadOutputError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadOutput error.

func (err BadOutputError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadOutput {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RANDR"][0] = BadOutputErrorNew
}

// BadBadProvider is the error number for a BadBadProvider.
const BadBadProvider = 3

type BadProviderError struct {
	Sequence uint16
	NiceName string
}

// BadProviderErrorNew constructs a BadProviderError value that implements xgb.Error from a byte slice.
func BadProviderErrorNew(buf []byte) xgb.Error {
	v := BadProviderError{}
	v.NiceName = "BadProvider"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadProvider error.
// This is mostly used internally.
func (err BadProviderError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadProvider error. If no bad value exists, 0 is returned.
func (err BadProviderError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadProvider error.

func (err BadProviderError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadProvider {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RANDR"][3] = BadProviderErrorNew
}

const (
	ConnectionConnected    = 0
	ConnectionDisconnected = 1
	ConnectionUnknown      = 2
)

type Crtc uint32

func NewCrtcId(c *xgb.Conn) (Crtc, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Crtc(id), nil
}

type CrtcChange struct {
	Timestamp xproto.Timestamp
	Window    xproto.Window
	Crtc      Crtc
	Mode      Mode
	Rotation  uint16
	// padding: 2 bytes
	X      int16
	Y      int16
	Width  uint16
	Height uint16
}

// CrtcChangeRead reads a byte slice into a CrtcChange value.
func CrtcChangeRead(buf []byte, v *CrtcChange) int {
	b := 0

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Crtc = Crtc(xgb.Get32(buf[b:]))
	b += 4

	v.Mode = Mode(xgb.Get32(buf[b:]))
	b += 4

	v.Rotation = xgb.Get16(buf[b:])
	b += 2

	b += 2 // padding

	v.X = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Y = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	return b
}

// CrtcChangeReadList reads a byte slice into a list of CrtcChange values.
func CrtcChangeReadList(buf []byte, dest []CrtcChange) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = CrtcChange{}
		b += CrtcChangeRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a CrtcChange value to a byte slice.
func (v CrtcChange) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Crtc))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Mode))
	b += 4

	xgb.Put16(buf[b:], v.Rotation)
	b += 2

	b += 2 // padding

	xgb.Put16(buf[b:], uint16(v.X))
	b += 2

	xgb.Put16(buf[b:], uint16(v.Y))
	b += 2

	xgb.Put16(buf[b:], v.Width)
	b += 2

	xgb.Put16(buf[b:], v.Height)
	b += 2

	return buf[:b]
}

// CrtcChangeListBytes writes a list of CrtcChange values to a byte slice.
func CrtcChangeListBytes(buf []byte, list []CrtcChange) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Lease uint32

func NewLeaseId(c *xgb.Conn) (Lease, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Lease(id), nil
}

type LeaseNotify struct {
	Timestamp xproto.Timestamp
	Window    xproto.Window
	Lease     Lease
	Created   byte
	// padding: 15 bytes
}

// LeaseNotifyRead reads a byte slice into a LeaseNotify value.
func LeaseNotifyRead(buf []byte, v *LeaseNotify) int {
	b := 0

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Lease = Lease(xgb.Get32(buf[b:]))
	b += 4

	v.Created = buf[b]
	b += 1

	b += 15 // padding

	return b
}

// LeaseNotifyReadList reads a byte slice into a list of LeaseNotify values.
func LeaseNotifyReadList(buf []byte, dest []LeaseNotify) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = LeaseNotify{}
		b += LeaseNotifyRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a LeaseNotify value to a byte slice.
func (v LeaseNotify) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Lease))
	b += 4

	buf[b] = v.Created
	b += 1

	b += 15 // padding

	return buf[:b]
}

// LeaseNotifyListBytes writes a list of LeaseNotify values to a byte slice.
func LeaseNotifyListBytes(buf []byte, list []LeaseNotify) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Mode uint32

func NewModeId(c *xgb.Conn) (Mode, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Mode(id), nil
}

const (
	ModeFlagHsyncPositive  = 1
	ModeFlagHsyncNegative  = 2
	ModeFlagVsyncPositive  = 4
	ModeFlagVsyncNegative  = 8
	ModeFlagInterlace      = 16
	ModeFlagDoubleScan     = 32
	ModeFlagCsync          = 64
	ModeFlagCsyncPositive  = 128
	ModeFlagCsyncNegative  = 256
	ModeFlagHskewPresent   = 512
	ModeFlagBcast          = 1024
	ModeFlagPixelMultiplex = 2048
	ModeFlagDoubleClock    = 4096
	ModeFlagHalveClock     = 8192
)

type ModeInfo struct {
	Id         uint32
	Width      uint16
	Height     uint16
	DotClock   uint32
	HsyncStart uint16
	HsyncEnd   uint16
	Htotal     uint16
	Hskew      uint16
	VsyncStart uint16
	VsyncEnd   uint16
	Vtotal     uint16
	NameLen    uint16
	ModeFlags  uint32
}

// ModeInfoRead reads a byte slice into a ModeInfo value.
func ModeInfoRead(buf []byte, v *ModeInfo) int {
	b := 0

	v.Id = xgb.Get32(buf[b:])
	b += 4

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.DotClock = xgb.Get32(buf[b:])
	b += 4

	v.HsyncStart = xgb.Get16(buf[b:])
	b += 2

	v.HsyncEnd = xgb.Get16(buf[b:])
	b += 2

	v.Htotal = xgb.Get16(buf[b:])
	b += 2

	v.Hskew = xgb.Get16(buf[b:])
	b += 2

	v.VsyncStart = xgb.Get16(buf[b:])
	b += 2

	v.VsyncEnd = xgb.Get16(buf[b:])
	b += 2

	v.Vtotal = xgb.Get16(buf[b:])
	b += 2

	v.NameLen = xgb.Get16(buf[b:])
	b += 2

	v.ModeFlags = xgb.Get32(buf[b:])
	b += 4

	return b
}

// ModeInfoReadList reads a byte slice into a list of ModeInfo values.
func ModeInfoReadList(buf []byte, dest []ModeInfo) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = ModeInfo{}
		b += ModeInfoRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a ModeInfo value to a byte slice.
func (v ModeInfo) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	xgb.Put32(buf[b:], v.Id)
	b += 4

	xgb.Put16(buf[b:], v.Width)
	b += 2

	xgb.Put16(buf[b:], v.Height)
	b += 2

	xgb.Put32(buf[b:], v.DotClock)
	b += 4

	xgb.Put16(buf[b:], v.HsyncStart)
	b += 2

	xgb.Put16(buf[b:], v.HsyncEnd)
	b += 2

	xgb.Put16(buf[b:], v.Htotal)
	b += 2

	xgb.Put16(buf[b:], v.Hskew)
	b += 2

	xgb.Put16(buf[b:], v.VsyncStart)
	b += 2

	xgb.Put16(buf[b:], v.VsyncEnd)
	b += 2

	xgb.Put16(buf[b:], v.Vtotal)
	b += 2

	xgb.Put16(buf[b:], v.NameLen)
	b += 2

	xgb.Put32(buf[b:], v.ModeFlags)
	b += 4

	return buf[:b]
}

// ModeInfoListBytes writes a list of ModeInfo values to a byte slice.
func ModeInfoListBytes(buf []byte, list []ModeInfo) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type MonitorInfo struct {
	Name                xproto.Atom
	Primary             bool
	Automatic           bool
	NOutput             uint16
	X                   int16
	Y                   int16
	Width               uint16
	Height              uint16
	WidthInMillimeters  uint32
	HeightInMillimeters uint32
	Outputs             []Output // size: xgb.Pad((int(NOutput) * 4))
}

// MonitorInfoRead reads a byte slice into a MonitorInfo value.
func MonitorInfoRead(buf []byte, v *MonitorInfo) int {
	b := 0

	v.Name = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	if buf[b] == 1 {
		v.Primary = true
	} else {
		v.Primary = false
	}
	b += 1

	if buf[b] == 1 {
		v.Automatic = true
	} else {
		v.Automatic = false
	}
	b += 1

	v.NOutput = xgb.Get16(buf[b:])
	b += 2

	v.X = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Y = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.WidthInMillimeters = xgb.Get32(buf[b:])
	b += 4

	v.HeightInMillimeters = xgb.Get32(buf[b:])
	b += 4

	v.Outputs = make([]Output, v.NOutput)
	for i := 0; i < int(v.NOutput); i++ {
		v.Outputs[i] = Output(xgb.Get32(buf[b:]))
		b += 4
	}

	return b
}

// MonitorInfoReadList reads a byte slice into a list of MonitorInfo values.
func MonitorInfoReadList(buf []byte, dest []MonitorInfo) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = MonitorInfo{}
		b += MonitorInfoRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a MonitorInfo value to a byte slice.
func (v MonitorInfo) Bytes() []byte {
	buf := make([]byte, (24 + xgb.Pad((int(v.NOutput) * 4))))
	b := 0

	xgb.Put32(buf[b:], uint32(v.Name))
	b += 4

	if v.Primary {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if v.Automatic {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	xgb.Put16(buf[b:], v.NOutput)
	b += 2

	xgb.Put16(buf[b:], uint16(v.X))
	b += 2

	xgb.Put16(buf[b:], uint16(v.Y))
	b += 2

	xgb.Put16(buf[b:], v.Width)
	b += 2

	xgb.Put16(buf[b:], v.Height)
	b += 2

	xgb.Put32(buf[b:], v.WidthInMillimeters)
	b += 4

	xgb.Put32(buf[b:], v.HeightInMillimeters)
	b += 4

	for i := 0; i < int(v.NOutput); i++ {
		xgb.Put32(buf[b:], uint32(v.Outputs[i]))
		b += 4
	}

	return buf[:b]
}

// MonitorInfoListBytes writes a list of MonitorInfo values to a byte slice.
func MonitorInfoListBytes(buf []byte, list []MonitorInfo) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// MonitorInfoListSize computes the size (bytes) of a list of MonitorInfo values.
func MonitorInfoListSize(list []MonitorInfo) int {
	size := 0
	for _, item := range list {
		size += (24 + xgb.Pad((int(item.NOutput) * 4)))
	}
	return size
}

const (
	NotifyCrtcChange       = 0
	NotifyOutputChange     = 1
	NotifyOutputProperty   = 2
	NotifyProviderChange   = 3
	NotifyProviderProperty = 4
	NotifyResourceChange   = 5
	NotifyLease            = 6
)

// Notify is the event number for a NotifyEvent.
const Notify = 1

type NotifyEvent struct {
	Sequence uint16
	SubCode  byte
	U        NotifyDataUnion
}

// NotifyEventNew constructs a NotifyEvent value that implements xgb.Event from a byte slice.
func NotifyEventNew(buf []byte) xgb.Event {
	v := NotifyEvent{}
	b := 1 // don't read event number

	v.SubCode = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.U = NotifyDataUnion{}
	b += NotifyDataUnionRead(buf[b:], &v.U)

	return v
}

// Bytes writes a NotifyEvent value to a byte slice.
func (v NotifyEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 1
	b += 1

	buf[b] = v.SubCode
	b += 1

	b += 2 // skip sequence number

	{
		unionBytes := v.U.Bytes()
		copy(buf[b:], unionBytes)
		b += len(unionBytes)
	}

	return buf
}

// SequenceId returns the sequence id attached to the Notify event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v NotifyEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of NotifyEvent.
func (v NotifyEvent) String() string {
	fieldVals := make([]string, 0, 2)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("SubCode: %d", v.SubCode))
	return "Notify {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["RANDR"][1] = NotifyEventNew
}

// NotifyDataUnion is a represention of the NotifyDataUnion union type.
// Note that to *create* a Union, you should *never* create
// this struct directly (unless you know what you're doing).
// Instead use one of the following constructors for 'NotifyDataUnion':
//
//	NotifyDataUnionCcNew(Cc CrtcChange) NotifyDataUnion
//	NotifyDataUnionOcNew(Oc OutputChange) NotifyDataUnion
//	NotifyDataUnionOpNew(Op OutputProperty) NotifyDataUnion
//	NotifyDataUnionPcNew(Pc ProviderChange) NotifyDataUnion
//	NotifyDataUnionPpNew(Pp ProviderProperty) NotifyDataUnion
//	NotifyDataUnionRcNew(Rc ResourceChange) NotifyDataUnion
//	NotifyDataUnionLcNew(Lc LeaseNotify) NotifyDataUnion
type NotifyDataUnion struct {
	Cc CrtcChange
	Oc OutputChange
	Op OutputProperty
	Pc ProviderChange
	Pp ProviderProperty
	Rc ResourceChange
	Lc LeaseNotify
}

// NotifyDataUnionCcNew constructs a new NotifyDataUnion union type with the Cc field.
func NotifyDataUnionCcNew(Cc CrtcChange) NotifyDataUnion {
	var b int
	buf := make([]byte, 28)

	{
		structBytes := Cc.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	// Create the Union type
	v := NotifyDataUnion{}

	// Now copy buf into all fields

	b = 0 // always read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // always read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // always read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // always read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // always read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // always read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // always read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return v
}

// NotifyDataUnionOcNew constructs a new NotifyDataUnion union type with the Oc field.
func NotifyDataUnionOcNew(Oc OutputChange) NotifyDataUnion {
	var b int
	buf := make([]byte, 28)

	{
		structBytes := Oc.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	// Create the Union type
	v := NotifyDataUnion{}

	// Now copy buf into all fields

	b = 0 // always read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // always read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // always read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // always read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // always read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // always read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // always read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return v
}

// NotifyDataUnionOpNew constructs a new NotifyDataUnion union type with the Op field.
func NotifyDataUnionOpNew(Op OutputProperty) NotifyDataUnion {
	var b int
	buf := make([]byte, 28)

	{
		structBytes := Op.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	// Create the Union type
	v := NotifyDataUnion{}

	// Now copy buf into all fields

	b = 0 // always read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // always read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // always read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // always read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // always read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // always read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // always read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return v
}

// NotifyDataUnionPcNew constructs a new NotifyDataUnion union type with the Pc field.
func NotifyDataUnionPcNew(Pc ProviderChange) NotifyDataUnion {
	var b int
	buf := make([]byte, 28)

	{
		structBytes := Pc.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	// Create the Union type
	v := NotifyDataUnion{}

	// Now copy buf into all fields

	b = 0 // always read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // always read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // always read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // always read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // always read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // always read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // always read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return v
}

// NotifyDataUnionPpNew constructs a new NotifyDataUnion union type with the Pp field.
func NotifyDataUnionPpNew(Pp ProviderProperty) NotifyDataUnion {
	var b int
	buf := make([]byte, 28)

	{
		structBytes := Pp.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	// Create the Union type
	v := NotifyDataUnion{}

	// Now copy buf into all fields

	b = 0 // always read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // always read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // always read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // always read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // always read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // always read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // always read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return v
}

// NotifyDataUnionRcNew constructs a new NotifyDataUnion union type with the Rc field.
func NotifyDataUnionRcNew(Rc ResourceChange) NotifyDataUnion {
	var b int
	buf := make([]byte, 28)

	{
		structBytes := Rc.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	// Create the Union type
	v := NotifyDataUnion{}

	// Now copy buf into all fields

	b = 0 // always read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // always read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // always read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // always read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // always read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // always read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // always read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return v
}

// NotifyDataUnionLcNew constructs a new NotifyDataUnion union type with the Lc field.
func NotifyDataUnionLcNew(Lc LeaseNotify) NotifyDataUnion {
	var b int
	buf := make([]byte, 28)

	{
		structBytes := Lc.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	// Create the Union type
	v := NotifyDataUnion{}

	// Now copy buf into all fields

	b = 0 // always read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // always read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // always read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // always read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // always read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // always read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // always read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return v
}

// NotifyDataUnionRead reads a byte slice into a NotifyDataUnion value.
func NotifyDataUnionRead(buf []byte, v *NotifyDataUnion) int {
	var b int

	b = 0 // re-read the same bytes
	v.Cc = CrtcChange{}
	b += CrtcChangeRead(buf[b:], &v.Cc)

	b = 0 // re-read the same bytes
	v.Oc = OutputChange{}
	b += OutputChangeRead(buf[b:], &v.Oc)

	b = 0 // re-read the same bytes
	v.Op = OutputProperty{}
	b += OutputPropertyRead(buf[b:], &v.Op)

	b = 0 // re-read the same bytes
	v.Pc = ProviderChange{}
	b += ProviderChangeRead(buf[b:], &v.Pc)

	b = 0 // re-read the same bytes
	v.Pp = ProviderProperty{}
	b += ProviderPropertyRead(buf[b:], &v.Pp)

	b = 0 // re-read the same bytes
	v.Rc = ResourceChange{}
	b += ResourceChangeRead(buf[b:], &v.Rc)

	b = 0 // re-read the same bytes
	v.Lc = LeaseNotify{}
	b += LeaseNotifyRead(buf[b:], &v.Lc)

	return 28
}

// NotifyDataUnionReadList reads a byte slice into a list of NotifyDataUnion values.
func NotifyDataUnionReadList(buf []byte, dest []NotifyDataUnion) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = NotifyDataUnion{}
		b += NotifyDataUnionRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a NotifyDataUnion value to a byte slice.
// Each field in a union must contain the same data.
// So simply pick the first field and write that to the wire.
func (v NotifyDataUnion) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	{
		structBytes := v.Cc.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return buf
}

// NotifyDataUnionListBytes writes a list of NotifyDataUnion values to a byte slice.
func NotifyDataUnionListBytes(buf []byte, list []NotifyDataUnion) int {
	b := 0
	var unionBytes []byte
	for _, item := range list {
		unionBytes = item.Bytes()
		copy(buf[b:], unionBytes)
		b += xgb.Pad(len(unionBytes))
	}
	return b
}

const (
	NotifyMaskScreenChange     = 1
	NotifyMaskCrtcChange       = 2
	NotifyMaskOutputChange     = 4
	NotifyMaskOutputProperty   = 8
	NotifyMaskProviderChange   = 16
	NotifyMaskProviderProperty = 32
	NotifyMaskResourceChange   = 64
	NotifyMaskLease            = 128
)

type Output uint32

func NewOutputId(c *xgb.Conn) (Output, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Output(id), nil
}

type OutputChange struct {
	Timestamp       xproto.Timestamp
	ConfigTimestamp xproto.Timestamp
	Window          xproto.Window
	Output          Output
	Crtc            Crtc
	Mode            Mode
	Rotation        uint16
	Connection      byte
	SubpixelOrder   byte
}

// OutputChangeRead reads a byte slice into a OutputChange value.
func OutputChangeRead(buf []byte, v *OutputChange) int {
	b := 0

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.ConfigTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Output = Output(xgb.Get32(buf[b:]))
	b += 4

	v.Crtc = Crtc(xgb.Get32(buf[b:]))
	b += 4

	v.Mode = Mode(xgb.Get32(buf[b:]))
	b += 4

	v.Rotation = xgb.Get16(buf[b:])
	b += 2

	v.Connection = buf[b]
	b += 1

	v.SubpixelOrder = buf[b]
	b += 1

	return b
}

// OutputChangeReadList reads a byte slice into a list of OutputChange values.
func OutputChangeReadList(buf []byte, dest []OutputChange) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = OutputChange{}
		b += OutputChangeRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a OutputChange value to a byte slice.
func (v OutputChange) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.ConfigTimestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Output))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Crtc))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Mode))
	b += 4

	xgb.Put16(buf[b:], v.Rotation)
	b += 2

	buf[b] = v.Connection
	b += 1

	buf[b] = v.SubpixelOrder
	b += 1

	return buf[:b]
}

// OutputChangeListBytes writes a list of OutputChange values to a byte slice.
func OutputChangeListBytes(buf []byte, list []OutputChange) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type OutputProperty struct {
	Window    xproto.Window
	Output    Output
	Atom      xproto.Atom
	Timestamp xproto.Timestamp
	Status    byte
	// padding: 11 bytes
}

// OutputPropertyRead reads a byte slice into a OutputProperty value.
func OutputPropertyRead(buf []byte, v *OutputProperty) int {
	b := 0

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Output = Output(xgb.Get32(buf[b:]))
	b += 4

	v.Atom = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Status = buf[b]
	b += 1

	b += 11 // padding

	return b
}

// OutputPropertyReadList reads a byte slice into a list of OutputProperty values.
func OutputPropertyReadList(buf []byte, dest []OutputProperty) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = OutputProperty{}
		b += OutputPropertyRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a OutputProperty value to a byte slice.
func (v OutputProperty) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Output))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Atom))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	buf[b] = v.Status
	b += 1

	b += 11 // padding

	return buf[:b]
}

// OutputPropertyListBytes writes a list of OutputProperty values to a byte slice.
func OutputPropertyListBytes(buf []byte, list []OutputProperty) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Provider uint32

func NewProviderId(c *xgb.Conn) (Provider, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Provider(id), nil
}

const (
	ProviderCapabilitySourceOutput  = 1
	ProviderCapabilitySinkOutput    = 2
	ProviderCapabilitySourceOffload = 4
	ProviderCapabilitySinkOffload   = 8
)

type ProviderChange struct {
	Timestamp xproto.Timestamp
	Window    xproto.Window
	Provider  Provider
	// padding: 16 bytes
}

// ProviderChangeRead reads a byte slice into a ProviderChange value.
func ProviderChangeRead(buf []byte, v *ProviderChange) int {
	b := 0

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Provider = Provider(xgb.Get32(buf[b:]))
	b += 4

	b += 16 // padding

	return b
}

// ProviderChangeReadList reads a byte slice into a list of ProviderChange values.
func ProviderChangeReadList(buf []byte, dest []ProviderChange) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = ProviderChange{}
		b += ProviderChangeRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a ProviderChange value to a byte slice.
func (v ProviderChange) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Provider))
	b += 4

	b += 16 // padding

	return buf[:b]
}

// ProviderChangeListBytes writes a list of ProviderChange values to a byte slice.
func ProviderChangeListBytes(buf []byte, list []ProviderChange) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type ProviderProperty struct {
	Window    xproto.Window
	Provider  Provider
	Atom      xproto.Atom
	Timestamp xproto.Timestamp
	State     byte
	// padding: 11 bytes
}

// ProviderPropertyRead reads a byte slice into a ProviderProperty value.
func ProviderPropertyRead(buf []byte, v *ProviderProperty) int {
	b := 0

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Provider = Provider(xgb.Get32(buf[b:]))
	b += 4

	v.Atom = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.State = buf[b]
	b += 1

	b += 11 // padding

	return b
}

// ProviderPropertyReadList reads a byte slice into a list of ProviderProperty values.
func ProviderPropertyReadList(buf []byte, dest []ProviderProperty) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = ProviderProperty{}
		b += ProviderPropertyRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a ProviderProperty value to a byte slice.
func (v ProviderProperty) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Atom))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	buf[b] = v.State
	b += 1

	b += 11 // padding

	return buf[:b]
}

// ProviderPropertyListBytes writes a list of ProviderProperty values to a byte slice.
func ProviderPropertyListBytes(buf []byte, list []ProviderProperty) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type RefreshRates struct {
	NRates uint16
	Rates  []uint16 // size: xgb.Pad((int(NRates) * 2))
}

// RefreshRatesRead reads a byte slice into a RefreshRates value.
func RefreshRatesRead(buf []byte, v *RefreshRates) int {
	b := 0

	v.NRates = xgb.Get16(buf[b:])
	b += 2

	v.Rates = make([]uint16, v.NRates)
	for i := 0; i < int(v.NRates); i++ {
		v.Rates[i] = xgb.Get16(buf[b:])
		b += 2
	}

	return b
}

// RefreshRatesReadList reads a byte slice into a list of RefreshRates values.
func RefreshRatesReadList(buf []byte, dest []RefreshRates) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = RefreshRates{}
		b += RefreshRatesRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a RefreshRates value to a byte slice.
func (v RefreshRates) Bytes() []byte {
	buf := make([]byte, (2 + xgb.Pad((int(v.NRates) * 2))))
	b := 0

	xgb.Put16(buf[b:], v.NRates)
	b += 2

	for i := 0; i < int(v.NRates); i++ {
		xgb.Put16(buf[b:], v.Rates[i])
		b += 2
	}

	return buf[:b]
}

// RefreshRatesListBytes writes a list of RefreshRates values to a byte slice.
func RefreshRatesListBytes(buf []byte, list []RefreshRates) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// RefreshRatesListSize computes the size (bytes) of a list of RefreshRates values.
func RefreshRatesListSize(list []RefreshRates) int {
	size := 0
	for _, item := range list {
		size += (2 + xgb.Pad((int(item.NRates) * 2)))
	}
	return size
}

type ResourceChange struct {
	Timestamp xproto.Timestamp
	Window    xproto.Window
	// padding: 20 bytes
}

// ResourceChangeRead reads a byte slice into a ResourceChange value.
func ResourceChangeRead(buf []byte, v *ResourceChange) int {
	b := 0

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	b += 20 // padding

	return b
}

// ResourceChangeReadList reads a byte slice into a list of ResourceChange values.
func ResourceChangeReadList(buf []byte, dest []ResourceChange) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = ResourceChange{}
		b += ResourceChangeRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a ResourceChange value to a byte slice.
func (v ResourceChange) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	b += 20 // padding

	return buf[:b]
}

// ResourceChangeListBytes writes a list of ResourceChange values to a byte slice.
func ResourceChangeListBytes(buf []byte, list []ResourceChange) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

const (
	RotationRotate0   = 1
	RotationRotate90  = 2
	RotationRotate180 = 4
	RotationRotate270 = 8
	RotationReflectX  = 16
	RotationReflectY  = 32
)

// ScreenChangeNotify is the event number for a ScreenChangeNotifyEvent.
const ScreenChangeNotify = 0

type ScreenChangeNotifyEvent struct {
	Sequence        uint16
	Rotation        byte
	Timestamp       xproto.Timestamp
	ConfigTimestamp xproto.Timestamp
	Root            xproto.Window
	RequestWindow   xproto.Window
	SizeID          uint16
	SubpixelOrder   uint16
	Width           uint16
	Height          uint16
	Mwidth          uint16
	Mheight         uint16
}

// ScreenChangeNotifyEventNew constructs a ScreenChangeNotifyEvent value that implements xgb.Event from a byte slice.
func ScreenChangeNotifyEventNew(buf []byte) xgb.Event {
	v := ScreenChangeNotifyEvent{}
	b := 1 // don't read event number

	v.Rotation = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.ConfigTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Root = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.RequestWindow = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.SizeID = xgb.Get16(buf[b:])
	b += 2

	v.SubpixelOrder = xgb.Get16(buf[b:])
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.Mwidth = xgb.Get16(buf[b:])
	b += 2

	v.Mheight = xgb.Get16(buf[b:])
	b += 2

	return v
}

// Bytes writes a ScreenChangeNotifyEvent value to a byte slice.
func (v ScreenChangeNotifyEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 0
	b += 1

	buf[b] = v.Rotation
	b += 1

	b += 2 // skip sequence number

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.ConfigTimestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Root))
	b += 4

	xgb.Put32(buf[b:], uint32(v.RequestWindow))
	b += 4

	xgb.Put16(buf[b:], v.SizeID)
	b += 2

	xgb.Put16(buf[b:], v.SubpixelOrder)
	b += 2

	xgb.Put16(buf[b:], v.Width)
	b += 2

	xgb.Put16(buf[b:], v.Height)
	b += 2

	xgb.Put16(buf[b:], v.Mwidth)
	b += 2

	xgb.Put16(buf[b:], v.Mheight)
	b += 2

	return buf
}

// SequenceId returns the sequence id attached to the ScreenChangeNotify event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v ScreenChangeNotifyEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of ScreenChangeNotifyEvent.
func (v ScreenChangeNotifyEvent) String() string {
	fieldVals := make([]string, 0, 11)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("Rotation: %d", v.Rotation))
	fieldVals = append(fieldVals, xgb.Sprintf("Timestamp: %d", v.Timestamp))
	fieldVals = append(fieldVals, xgb.Sprintf("ConfigTimestamp: %d", v.ConfigTimestamp))
	fieldVals = append(fieldVals, xgb.Sprintf("Root: %d", v.Root))
	fieldVals = append(fieldVals, xgb.Sprintf("RequestWindow: %d", v.RequestWindow))
	fieldVals = append(fieldVals, xgb.Sprintf("SizeID: %d", v.SizeID))
	fieldVals = append(fieldVals, xgb.Sprintf("SubpixelOrder: %d", v.SubpixelOrder))
	fieldVals = append(fieldVals, xgb.Sprintf("Width: %d", v.Width))
	fieldVals = append(fieldVals, xgb.Sprintf("Height: %d", v.Height))
	fieldVals = append(fieldVals, xgb.Sprintf("Mwidth: %d", v.Mwidth))
	fieldVals = append(fieldVals, xgb.Sprintf("Mheight: %d", v.Mheight))
	return "ScreenChangeNotify {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["RANDR"][0] = ScreenChangeNotifyEventNew
}

type ScreenSize struct {
	Width   uint16
	Height  uint16
	Mwidth  uint16
	Mheight uint16
}

// ScreenSizeRead reads a byte slice into a ScreenSize value.
func ScreenSizeRead(buf []byte, v *ScreenSize) int {
	b := 0

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.Mwidth = xgb.Get16(buf[b:])
	b += 2

	v.Mheight = xgb.Get16(buf[b:])
	b += 2

	return b
}

// ScreenSizeReadList reads a byte slice into a list of ScreenSize values.
func ScreenSizeReadList(buf []byte, dest []ScreenSize) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = ScreenSize{}
		b += ScreenSizeRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a ScreenSize value to a byte slice.
func (v ScreenSize) Bytes() []byte {
	buf := make([]byte, 8)
	b := 0

	xgb.Put16(buf[b:], v.Width)
	b += 2

	xgb.Put16(buf[b:], v.Height)
	b += 2

	xgb.Put16(buf[b:], v.Mwidth)
	b += 2

	xgb.Put16(buf[b:], v.Mheight)
	b += 2

	return buf[:b]
}

// ScreenSizeListBytes writes a list of ScreenSize values to a byte slice.
func ScreenSizeListBytes(buf []byte, list []ScreenSize) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

const (
	SetConfigSuccess           = 0
	SetConfigInvalidConfigTime = 1
	SetConfigInvalidTime       = 2
	SetConfigFailed            = 3
)

const (
	TransformUnit       = 1
	TransformScaleUp    = 2
	TransformScaleDown  = 4
	TransformProjective = 8
)

// Skipping definition for base type 'Bool'

// Skipping definition for base type 'Byte'

// Skipping definition for base type 'Card8'

// Skipping definition for base type 'Char'

// Skipping definition for base type 'Void'

// Skipping definition for base type 'Double'

// Skipping definition for base type 'Float'

// Skipping definition for base type 'Int16'

// Skipping definition for base type 'Int32'

// Skipping definition for base type 'Int8'

// Skipping definition for base type 'Card16'

// Skipping definition for base type 'Card32'

// AddOutputModeCookie is a cookie used only for AddOutputMode requests.
type AddOutputModeCookie struct {
	*xgb.Cookie
}

// AddOutputMode sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func AddOutputMode(c *xgb.Conn, Output Output, Mode Mode) AddOutputModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'AddOutputMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(addOutputModeRequest(c, Output, Mode), cookie)
	return AddOutputModeCookie{cookie}
}

// AddOutputModeChecked sends a checked request.
// If an error occurs, it can be retrieved using AddOutputModeCookie.Check()
func AddOutputModeChecked(c *xgb.Conn, Output Output, Mode Mode) AddOutputModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'AddOutputMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(addOutputModeRequest(c, Output, Mode), cookie)
	return AddOutputModeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook AddOutputModeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for AddOutputMode
// addOutputModeRequest writes a AddOutputMode request to a byte slice.
func addOutputModeRequest(c *xgb.Conn, Output Output, Mode Mode) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 18 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(Mode))
	b += 4

	return buf
}

// ChangeOutputPropertyCookie is a cookie used only for ChangeOutputProperty requests.
type ChangeOutputPropertyCookie struct {
	*xgb.Cookie
}

// ChangeOutputProperty sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ChangeOutputProperty(c *xgb.Conn, Output Output, Property xproto.Atom, Type xproto.Atom, Format byte, Mode byte, NumUnits uint32, Data []byte) ChangeOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ChangeOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(changeOutputPropertyRequest(c, Output, Property, Type, Format, Mode, NumUnits, Data), cookie)
	return ChangeOutputPropertyCookie{cookie}
}

// ChangeOutputPropertyChecked sends a checked request.
// If an error occurs, it can be retrieved using ChangeOutputPropertyCookie.Check()
func ChangeOutputPropertyChecked(c *xgb.Conn, Output Output, Property xproto.Atom, Type xproto.Atom, Format byte, Mode byte, NumUnits uint32, Data []byte) ChangeOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ChangeOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(changeOutputPropertyRequest(c, Output, Property, Type, Format, Mode, NumUnits, Data), cookie)
	return ChangeOutputPropertyCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ChangeOutputPropertyCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ChangeOutputProperty
// changeOutputPropertyRequest writes a ChangeOutputProperty request to a byte slice.
func changeOutputPropertyRequest(c *xgb.Conn, Output Output, Property xproto.Atom, Type xproto.Atom, Format byte, Mode byte, NumUnits uint32, Data []byte) []byte {
	size := xgb.Pad((24 + xgb.Pad((((int(NumUnits) * int(Format)) / 8) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 13 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	xgb.Put32(buf[b:], uint32(Type))
	b += 4

	buf[b] = Format
	b += 1

	buf[b] = Mode
	b += 1

	b += 2 // padding

	xgb.Put32(buf[b:], NumUnits)
	b += 4

	copy(buf[b:], Data[:((int(NumUnits)*int(Format))/8)])
	b += int(((int(NumUnits) * int(Format)) / 8))

	return buf
}

// ChangeProviderPropertyCookie is a cookie used only for ChangeProviderProperty requests.
type ChangeProviderPropertyCookie struct {
	*xgb.Cookie
}

// ChangeProviderProperty sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ChangeProviderProperty(c *xgb.Conn, Provider Provider, Property xproto.Atom, Type xproto.Atom, Format byte, Mode byte, NumItems uint32, Data []byte) ChangeProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ChangeProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(changeProviderPropertyRequest(c, Provider, Property, Type, Format, Mode, NumItems, Data), cookie)
	return ChangeProviderPropertyCookie{cookie}
}

// ChangeProviderPropertyChecked sends a checked request.
// If an error occurs, it can be retrieved using ChangeProviderPropertyCookie.Check()
func ChangeProviderPropertyChecked(c *xgb.Conn, Provider Provider, Property xproto.Atom, Type xproto.Atom, Format byte, Mode byte, NumItems uint32, Data []byte) ChangeProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ChangeProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(changeProviderPropertyRequest(c, Provider, Property, Type, Format, Mode, NumItems, Data), cookie)
	return ChangeProviderPropertyCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ChangeProviderPropertyCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ChangeProviderProperty
// changeProviderPropertyRequest writes a ChangeProviderProperty request to a byte slice.
func changeProviderPropertyRequest(c *xgb.Conn, Provider Provider, Property xproto.Atom, Type xproto.Atom, Format byte, Mode byte, NumItems uint32, Data []byte) []byte {
	size := xgb.Pad((24 + xgb.Pad(((int(NumItems) * (int(Format) / 8)) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 39 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	xgb.Put32(buf[b:], uint32(Type))
	b += 4

	buf[b] = Format
	b += 1

	buf[b] = Mode
	b += 1

	b += 2 // padding

	xgb.Put32(buf[b:], NumItems)
	b += 4

	copy(buf[b:], Data[:(int(NumItems)*(int(Format)/8))])
	b += int((int(NumItems) * (int(Format) / 8)))

	return buf
}

// ConfigureOutputPropertyCookie is a cookie used only for ConfigureOutputProperty requests.
type ConfigureOutputPropertyCookie struct {
	*xgb.Cookie
}

// ConfigureOutputProperty sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ConfigureOutputProperty(c *xgb.Conn, Output Output, Property xproto.Atom, Pending bool, Range bool, Values []int32) ConfigureOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ConfigureOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(configureOutputPropertyRequest(c, Output, Property, Pending, Range, Values), cookie)
	return ConfigureOutputPropertyCookie{cookie}
}

// ConfigureOutputPropertyChecked sends a checked request.
// If an error occurs, it can be retrieved using ConfigureOutputPropertyCookie.Check()
func ConfigureOutputPropertyChecked(c *xgb.Conn, Output Output, Property xproto.Atom, Pending bool, Range bool, Values []int32) ConfigureOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ConfigureOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(configureOutputPropertyRequest(c, Output, Property, Pending, Range, Values), cookie)
	return ConfigureOutputPropertyCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ConfigureOutputPropertyCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ConfigureOutputProperty
// configureOutputPropertyRequest writes a ConfigureOutputProperty request to a byte slice.
func configureOutputPropertyRequest(c *xgb.Conn, Output Output, Property xproto.Atom, Pending bool, Range bool, Values []int32) []byte {
	size := xgb.Pad((16 + xgb.Pad((len(Values) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 12 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	if Pending {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if Range {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 2 // padding

	for i := 0; i < int(len(Values)); i++ {
		xgb.Put32(buf[b:], uint32(Values[i]))
		b += 4
	}

	return buf
}

// ConfigureProviderPropertyCookie is a cookie used only for ConfigureProviderProperty requests.
type ConfigureProviderPropertyCookie struct {
	*xgb.Cookie
}

// ConfigureProviderProperty sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ConfigureProviderProperty(c *xgb.Conn, Provider Provider, Property xproto.Atom, Pending bool, Range bool, Values []int32) ConfigureProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ConfigureProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(configureProviderPropertyRequest(c, Provider, Property, Pending, Range, Values), cookie)
	return ConfigureProviderPropertyCookie{cookie}
}

// ConfigureProviderPropertyChecked sends a checked request.
// If an error occurs, it can be retrieved using ConfigureProviderPropertyCookie.Check()
func ConfigureProviderPropertyChecked(c *xgb.Conn, Provider Provider, Property xproto.Atom, Pending bool, Range bool, Values []int32) ConfigureProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ConfigureProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(configureProviderPropertyRequest(c, Provider, Property, Pending, Range, Values), cookie)
	return ConfigureProviderPropertyCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ConfigureProviderPropertyCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ConfigureProviderProperty
// configureProviderPropertyRequest writes a ConfigureProviderProperty request to a byte slice.
func configureProviderPropertyRequest(c *xgb.Conn, Provider Provider, Property xproto.Atom, Pending bool, Range bool, Values []int32) []byte {
	size := xgb.Pad((16 + xgb.Pad((len(Values) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 38 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	if Pending {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if Range {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 2 // padding

	for i := 0; i < int(len(Values)); i++ {
		xgb.Put32(buf[b:], uint32(Values[i]))
		b += 4
	}

	return buf
}

// CreateLeaseCookie is a cookie used only for CreateLease requests.
type CreateLeaseCookie struct {
	*xgb.Cookie
}

// CreateLease sends a checked request.
// If an error occurs, it will be returned with the reply by calling CreateLeaseCookie.Reply()
func CreateLease(c *xgb.Conn, Window xproto.Window, Lid Lease, NumCrtcs uint16, NumOutputs uint16, Crtcs []Crtc, Outputs []Output) CreateLeaseCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'CreateLease' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(createLeaseRequest(c, Window, Lid, NumCrtcs, NumOutputs, Crtcs, Outputs), cookie)
	return CreateLeaseCookie{cookie}
}

// CreateLeaseUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateLeaseUnchecked(c *xgb.Conn, Window xproto.Window, Lid Lease, NumCrtcs uint16, NumOutputs uint16, Crtcs []Crtc, Outputs []Output) CreateLeaseCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'CreateLease' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(createLeaseRequest(c, Window, Lid, NumCrtcs, NumOutputs, Crtcs, Outputs), cookie)
	return CreateLeaseCookie{cookie}
}

// CreateLeaseReply represents the data returned from a CreateLease request.
type CreateLeaseReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	Nfd      byte
	// padding: 24 bytes
}

// Reply blocks and returns the reply data for a CreateLease request.
func (cook CreateLeaseCookie) Reply() (*CreateLeaseReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return createLeaseReply(buf), nil
}

// createLeaseReply reads a byte slice into a CreateLeaseReply value.
func createLeaseReply(buf []byte) *CreateLeaseReply {
	v := new(CreateLeaseReply)
	b := 1 // skip reply determinant

	v.Nfd = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 24 // padding

	return v
}

// Write request to wire for CreateLease
// createLeaseRequest writes a CreateLease request to a byte slice.
func createLeaseRequest(c *xgb.Conn, Window xproto.Window, Lid Lease, NumCrtcs uint16, NumOutputs uint16, Crtcs []Crtc, Outputs []Output) []byte {
	size := xgb.Pad(((16 + xgb.Pad((int(NumCrtcs) * 4))) + xgb.Pad((int(NumOutputs) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 45 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(Lid))
	b += 4

	xgb.Put16(buf[b:], NumCrtcs)
	b += 2

	xgb.Put16(buf[b:], NumOutputs)
	b += 2

	for i := 0; i < int(NumCrtcs); i++ {
		xgb.Put32(buf[b:], uint32(Crtcs[i]))
		b += 4
	}

	for i := 0; i < int(NumOutputs); i++ {
		xgb.Put32(buf[b:], uint32(Outputs[i]))
		b += 4
	}

	return buf
}

// CreateModeCookie is a cookie used only for CreateMode requests.
type CreateModeCookie struct {
	*xgb.Cookie
}

// CreateMode sends a checked request.
// If an error occurs, it will be returned with the reply by calling CreateModeCookie.Reply()
func CreateMode(c *xgb.Conn, Window xproto.Window, ModeInfo ModeInfo, Name string) CreateModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'CreateMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(createModeRequest(c, Window, ModeInfo, Name), cookie)
	return CreateModeCookie{cookie}
}

// CreateModeUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateModeUnchecked(c *xgb.Conn, Window xproto.Window, ModeInfo ModeInfo, Name string) CreateModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'CreateMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(createModeRequest(c, Window, ModeInfo, Name), cookie)
	return CreateModeCookie{cookie}
}

// CreateModeReply represents the data returned from a CreateMode request.
type CreateModeReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Mode Mode
	// padding: 20 bytes
}

// Reply blocks and returns the reply data for a CreateMode request.
func (cook CreateModeCookie) Reply() (*CreateModeReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return createModeReply(buf), nil
}

// createModeReply reads a byte slice into a CreateModeReply value.
func createModeReply(buf []byte) *CreateModeReply {
	v := new(CreateModeReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Mode = Mode(xgb.Get32(buf[b:]))
	b += 4

	b += 20 // padding

	return v
}

// Write request to wire for CreateMode
// createModeRequest writes a CreateMode request to a byte slice.
func createModeRequest(c *xgb.Conn, Window xproto.Window, ModeInfo ModeInfo, Name string) []byte {
	size := xgb.Pad((40 + xgb.Pad((len(Name) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 16 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	{
		structBytes := ModeInfo.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	copy(buf[b:], Name[:len(Name)])
	b += int(len(Name))

	return buf
}

// DeleteMonitorCookie is a cookie used only for DeleteMonitor requests.
type DeleteMonitorCookie struct {
	*xgb.Cookie
}

// DeleteMonitor sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteMonitor(c *xgb.Conn, Window xproto.Window, Name xproto.Atom) DeleteMonitorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteMonitor' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteMonitorRequest(c, Window, Name), cookie)
	return DeleteMonitorCookie{cookie}
}

// DeleteMonitorChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteMonitorCookie.Check()
func DeleteMonitorChecked(c *xgb.Conn, Window xproto.Window, Name xproto.Atom) DeleteMonitorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteMonitor' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteMonitorRequest(c, Window, Name), cookie)
	return DeleteMonitorCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteMonitorCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteMonitor
// deleteMonitorRequest writes a DeleteMonitor request to a byte slice.
func deleteMonitorRequest(c *xgb.Conn, Window xproto.Window, Name xproto.Atom) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 44 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(Name))
	b += 4

	return buf
}

// DeleteOutputModeCookie is a cookie used only for DeleteOutputMode requests.
type DeleteOutputModeCookie struct {
	*xgb.Cookie
}

// DeleteOutputMode sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteOutputMode(c *xgb.Conn, Output Output, Mode Mode) DeleteOutputModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteOutputMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteOutputModeRequest(c, Output, Mode), cookie)
	return DeleteOutputModeCookie{cookie}
}

// DeleteOutputModeChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteOutputModeCookie.Check()
func DeleteOutputModeChecked(c *xgb.Conn, Output Output, Mode Mode) DeleteOutputModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteOutputMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteOutputModeRequest(c, Output, Mode), cookie)
	return DeleteOutputModeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteOutputModeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteOutputMode
// deleteOutputModeRequest writes a DeleteOutputMode request to a byte slice.
func deleteOutputModeRequest(c *xgb.Conn, Output Output, Mode Mode) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 19 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(Mode))
	b += 4

	return buf
}

// DeleteOutputPropertyCookie is a cookie used only for DeleteOutputProperty requests.
type DeleteOutputPropertyCookie struct {
	*xgb.Cookie
}

// DeleteOutputProperty sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteOutputProperty(c *xgb.Conn, Output Output, Property xproto.Atom) DeleteOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteOutputPropertyRequest(c, Output, Property), cookie)
	return DeleteOutputPropertyCookie{cookie}
}

// DeleteOutputPropertyChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteOutputPropertyCookie.Check()
func DeleteOutputPropertyChecked(c *xgb.Conn, Output Output, Property xproto.Atom) DeleteOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteOutputPropertyRequest(c, Output, Property), cookie)
	return DeleteOutputPropertyCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteOutputPropertyCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteOutputProperty
// deleteOutputPropertyRequest writes a DeleteOutputProperty request to a byte slice.
func deleteOutputPropertyRequest(c *xgb.Conn, Output Output, Property xproto.Atom) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 14 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	return buf
}

// DeleteProviderPropertyCookie is a cookie used only for DeleteProviderProperty requests.
type DeleteProviderPropertyCookie struct {
	*xgb.Cookie
}

// DeleteProviderProperty sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteProviderProperty(c *xgb.Conn, Provider Provider, Property xproto.Atom) DeleteProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteProviderPropertyRequest(c, Provider, Property), cookie)
	return DeleteProviderPropertyCookie{cookie}
}

// DeleteProviderPropertyChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteProviderPropertyCookie.Check()
func DeleteProviderPropertyChecked(c *xgb.Conn, Provider Provider, Property xproto.Atom) DeleteProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DeleteProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteProviderPropertyRequest(c, Provider, Property), cookie)
	return DeleteProviderPropertyCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteProviderPropertyCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteProviderProperty
// deleteProviderPropertyRequest writes a DeleteProviderProperty request to a byte slice.
func deleteProviderPropertyRequest(c *xgb.Conn, Provider Provider, Property xproto.Atom) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 40 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	return buf
}

// DestroyModeCookie is a cookie used only for DestroyMode requests.
type DestroyModeCookie struct {
	*xgb.Cookie
}

// DestroyMode sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DestroyMode(c *xgb.Conn, Mode Mode) DestroyModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DestroyMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(destroyModeRequest(c, Mode), cookie)
	return DestroyModeCookie{cookie}
}

// DestroyModeChecked sends a checked request.
// If an error occurs, it can be retrieved using DestroyModeCookie.Check()
func DestroyModeChecked(c *xgb.Conn, Mode Mode) DestroyModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'DestroyMode' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(destroyModeRequest(c, Mode), cookie)
	return DestroyModeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DestroyModeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DestroyMode
// destroyModeRequest writes a DestroyMode request to a byte slice.
func destroyModeRequest(c *xgb.Conn, Mode Mode) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 17 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Mode))
	b += 4

	return buf
}

// FreeLeaseCookie is a cookie used only for FreeLease requests.
type FreeLeaseCookie struct {
	*xgb.Cookie
}

// FreeLease sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FreeLease(c *xgb.Conn, Lid Lease, Terminate byte) FreeLeaseCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'FreeLease' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(freeLeaseRequest(c, Lid, Terminate), cookie)
	return FreeLeaseCookie{cookie}
}

// FreeLeaseChecked sends a checked request.
// If an error occurs, it can be retrieved using FreeLeaseCookie.Check()
func FreeLeaseChecked(c *xgb.Conn, Lid Lease, Terminate byte) FreeLeaseCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'FreeLease' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(freeLeaseRequest(c, Lid, Terminate), cookie)
	return FreeLeaseCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook FreeLeaseCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for FreeLease
// freeLeaseRequest writes a FreeLease request to a byte slice.
func freeLeaseRequest(c *xgb.Conn, Lid Lease, Terminate byte) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 46 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Lid))
	b += 4

	buf[b] = Terminate
	b += 1

	return buf
}

// GetCrtcGammaCookie is a cookie used only for GetCrtcGamma requests.
type GetCrtcGammaCookie struct {
	*xgb.Cookie
}

// GetCrtcGamma sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCrtcGammaCookie.Reply()
func GetCrtcGamma(c *xgb.Conn, Crtc Crtc) GetCrtcGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcGamma' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCrtcGammaRequest(c, Crtc), cookie)
	return GetCrtcGammaCookie{cookie}
}

// GetCrtcGammaUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCrtcGammaUnchecked(c *xgb.Conn, Crtc Crtc) GetCrtcGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcGamma' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCrtcGammaRequest(c, Crtc), cookie)
	return GetCrtcGammaCookie{cookie}
}

// GetCrtcGammaReply represents the data returned from a GetCrtcGamma request.
type GetCrtcGammaReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Size uint16
	// padding: 22 bytes
	Red   []uint16 // size: xgb.Pad((int(Size) * 2))
	Green []uint16 // size: xgb.Pad((int(Size) * 2))
	Blue  []uint16 // size: xgb.Pad((int(Size) * 2))
}

// Reply blocks and returns the reply data for a GetCrtcGamma request.
func (cook GetCrtcGammaCookie) Reply() (*GetCrtcGammaReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCrtcGammaReply(buf), nil
}

// getCrtcGammaReply reads a byte slice into a GetCrtcGammaReply value.
func getCrtcGammaReply(buf []byte) *GetCrtcGammaReply {
	v := new(GetCrtcGammaReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Size = xgb.Get16(buf[b:])
	b += 2

	b += 22 // padding

	v.Red = make([]uint16, v.Size)
	for i := 0; i < int(v.Size); i++ {
		v.Red[i] = xgb.Get16(buf[b:])
		b += 2
	}

	v.Green = make([]uint16, v.Size)
	for i := 0; i < int(v.Size); i++ {
		v.Green[i] = xgb.Get16(buf[b:])
		b += 2
	}

	v.Blue = make([]uint16, v.Size)
	for i := 0; i < int(v.Size); i++ {
		v.Blue[i] = xgb.Get16(buf[b:])
		b += 2
	}

	return v
}

// Write request to wire for GetCrtcGamma
// getCrtcGammaRequest writes a GetCrtcGamma request to a byte slice.
func getCrtcGammaRequest(c *xgb.Conn, Crtc Crtc) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 23 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	return buf
}

// GetCrtcGammaSizeCookie is a cookie used only for GetCrtcGammaSize requests.
type GetCrtcGammaSizeCookie struct {
	*xgb.Cookie
}

// GetCrtcGammaSize sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCrtcGammaSizeCookie.Reply()
func GetCrtcGammaSize(c *xgb.Conn, Crtc Crtc) GetCrtcGammaSizeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcGammaSize' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCrtcGammaSizeRequest(c, Crtc), cookie)
	return GetCrtcGammaSizeCookie{cookie}
}

// GetCrtcGammaSizeUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCrtcGammaSizeUnchecked(c *xgb.Conn, Crtc Crtc) GetCrtcGammaSizeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcGammaSize' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCrtcGammaSizeRequest(c, Crtc), cookie)
	return GetCrtcGammaSizeCookie{cookie}
}

// GetCrtcGammaSizeReply represents the data returned from a GetCrtcGammaSize request.
type GetCrtcGammaSizeReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Size uint16
	// padding: 22 bytes
}

// Reply blocks and returns the reply data for a GetCrtcGammaSize request.
func (cook GetCrtcGammaSizeCookie) Reply() (*GetCrtcGammaSizeReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCrtcGammaSizeReply(buf), nil
}

// getCrtcGammaSizeReply reads a byte slice into a GetCrtcGammaSizeReply value.
func getCrtcGammaSizeReply(buf []byte) *GetCrtcGammaSizeReply {
	v := new(GetCrtcGammaSizeReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Size = xgb.Get16(buf[b:])
	b += 2

	b += 22 // padding

	return v
}

// Write request to wire for GetCrtcGammaSize
// getCrtcGammaSizeRequest writes a GetCrtcGammaSize request to a byte slice.
func getCrtcGammaSizeRequest(c *xgb.Conn, Crtc Crtc) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 22 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	return buf
}

// GetCrtcInfoCookie is a cookie used only for GetCrtcInfo requests.
type GetCrtcInfoCookie struct {
	*xgb.Cookie
}

// GetCrtcInfo sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCrtcInfoCookie.Reply()
func GetCrtcInfo(c *xgb.Conn, Crtc Crtc, ConfigTimestamp xproto.Timestamp) GetCrtcInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCrtcInfoRequest(c, Crtc, ConfigTimestamp), cookie)
	return GetCrtcInfoCookie{cookie}
}

// GetCrtcInfoUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCrtcInfoUnchecked(c *xgb.Conn, Crtc Crtc, ConfigTimestamp xproto.Timestamp) GetCrtcInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCrtcInfoRequest(c, Crtc, ConfigTimestamp), cookie)
	return GetCrtcInfoCookie{cookie}
}

// GetCrtcInfoReply represents the data returned from a GetCrtcInfo request.
type GetCrtcInfoReply struct {
	Sequence           uint16 // sequence number of the request for this reply
	Length             uint32 // number of bytes in this reply
	Status             byte
	Timestamp          xproto.Timestamp
	X                  int16
	Y                  int16
	Width              uint16
	Height             uint16
	Mode               Mode
	Rotation           uint16
	Rotations          uint16
	NumOutputs         uint16
	NumPossibleOutputs uint16
	Outputs            []Output // size: xgb.Pad((int(NumOutputs) * 4))
	Possible           []Output // size: xgb.Pad((int(NumPossibleOutputs) * 4))
}

// Reply blocks and returns the reply data for a GetCrtcInfo request.
func (cook GetCrtcInfoCookie) Reply() (*GetCrtcInfoReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCrtcInfoReply(buf), nil
}

// getCrtcInfoReply reads a byte slice into a GetCrtcInfoReply value.
func getCrtcInfoReply(buf []byte) *GetCrtcInfoReply {
	v := new(GetCrtcInfoReply)
	b := 1 // skip reply determinant

	v.Status = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.X = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Y = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.Mode = Mode(xgb.Get32(buf[b:]))
	b += 4

	v.Rotation = xgb.Get16(buf[b:])
	b += 2

	v.Rotations = xgb.Get16(buf[b:])
	b += 2

	v.NumOutputs = xgb.Get16(buf[b:])
	b += 2

	v.NumPossibleOutputs = xgb.Get16(buf[b:])
	b += 2

	v.Outputs = make([]Output, v.NumOutputs)
	for i := 0; i < int(v.NumOutputs); i++ {
		v.Outputs[i] = Output(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Possible = make([]Output, v.NumPossibleOutputs)
	for i := 0; i < int(v.NumPossibleOutputs); i++ {
		v.Possible[i] = Output(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetCrtcInfo
// getCrtcInfoRequest writes a GetCrtcInfo request to a byte slice.
func getCrtcInfoRequest(c *xgb.Conn, Crtc Crtc, ConfigTimestamp xproto.Timestamp) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 20 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	xgb.Put32(buf[b:], uint32(ConfigTimestamp))
	b += 4

	return buf
}

// GetCrtcTransformCookie is a cookie used only for GetCrtcTransform requests.
type GetCrtcTransformCookie struct {
	*xgb.Cookie
}

// GetCrtcTransform sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCrtcTransformCookie.Reply()
func GetCrtcTransform(c *xgb.Conn, Crtc Crtc) GetCrtcTransformCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcTransform' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCrtcTransformRequest(c, Crtc), cookie)
	return GetCrtcTransformCookie{cookie}
}

// GetCrtcTransformUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCrtcTransformUnchecked(c *xgb.Conn, Crtc Crtc) GetCrtcTransformCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetCrtcTransform' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCrtcTransformRequest(c, Crtc), cookie)
	return GetCrtcTransformCookie{cookie}
}

// GetCrtcTransformReply represents the data returned from a GetCrtcTransform request.
type GetCrtcTransformReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	PendingTransform render.Transform
	HasTransforms    bool
	// padding: 3 bytes
	CurrentTransform render.Transform
	// padding: 4 bytes
	PendingLen        uint16
	PendingNparams    uint16
	CurrentLen        uint16
	CurrentNparams    uint16
	PendingFilterName string // size: xgb.Pad((int(PendingLen) * 1))
	// alignment gap to multiple of 4
	PendingParams     []render.Fixed // size: xgb.Pad((int(PendingNparams) * 4))
	CurrentFilterName string         // size: xgb.Pad((int(CurrentLen) * 1))
	// alignment gap to multiple of 4
	CurrentParams []render.Fixed // size: xgb.Pad((int(CurrentNparams) * 4))
}

// Reply blocks and returns the reply data for a GetCrtcTransform request.
func (cook GetCrtcTransformCookie) Reply() (*GetCrtcTransformReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCrtcTransformReply(buf), nil
}

// getCrtcTransformReply reads a byte slice into a GetCrtcTransformReply value.
func getCrtcTransformReply(buf []byte) *GetCrtcTransformReply {
	v := new(GetCrtcTransformReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.PendingTransform = render.Transform{}
	b += render.TransformRead(buf[b:], &v.PendingTransform)

	if buf[b] == 1 {
		v.HasTransforms = true
	} else {
		v.HasTransforms = false
	}
	b += 1

	b += 3 // padding

	v.CurrentTransform = render.Transform{}
	b += render.TransformRead(buf[b:], &v.CurrentTransform)

	b += 4 // padding

	v.PendingLen = xgb.Get16(buf[b:])
	b += 2

	v.PendingNparams = xgb.Get16(buf[b:])
	b += 2

	v.CurrentLen = xgb.Get16(buf[b:])
	b += 2

	v.CurrentNparams = xgb.Get16(buf[b:])
	b += 2

	{
		byteString := make([]byte, v.PendingLen)
		copy(byteString[:v.PendingLen], buf[b:])
		v.PendingFilterName = string(byteString)
		b += int(v.PendingLen)
	}

	b = (b + 3) & ^3 // alignment gap

	v.PendingParams = make([]render.Fixed, v.PendingNparams)
	for i := 0; i < int(v.PendingNparams); i++ {
		v.PendingParams[i] = render.Fixed(xgb.Get32(buf[b:]))
		b += 4
	}

	{
		byteString := make([]byte, v.CurrentLen)
		copy(byteString[:v.CurrentLen], buf[b:])
		v.CurrentFilterName = string(byteString)
		b += int(v.CurrentLen)
	}

	b = (b + 3) & ^3 // alignment gap

	v.CurrentParams = make([]render.Fixed, v.CurrentNparams)
	for i := 0; i < int(v.CurrentNparams); i++ {
		v.CurrentParams[i] = render.Fixed(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetCrtcTransform
// getCrtcTransformRequest writes a GetCrtcTransform request to a byte slice.
func getCrtcTransformRequest(c *xgb.Conn, Crtc Crtc) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 27 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	return buf
}

// GetMonitorsCookie is a cookie used only for GetMonitors requests.
type GetMonitorsCookie struct {
	*xgb.Cookie
}

// GetMonitors sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMonitorsCookie.Reply()
func GetMonitors(c *xgb.Conn, Window xproto.Window, GetActive bool) GetMonitorsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetMonitors' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMonitorsRequest(c, Window, GetActive), cookie)
	return GetMonitorsCookie{cookie}
}

// GetMonitorsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMonitorsUnchecked(c *xgb.Conn, Window xproto.Window, GetActive bool) GetMonitorsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetMonitors' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMonitorsRequest(c, Window, GetActive), cookie)
	return GetMonitorsCookie{cookie}
}

// GetMonitorsReply represents the data returned from a GetMonitors request.
type GetMonitorsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Timestamp xproto.Timestamp
	NMonitors uint32
	NOutputs  uint32
	// padding: 12 bytes
	Monitors []MonitorInfo // size: MonitorInfoListSize(Monitors)
}

// Reply blocks and returns the reply data for a GetMonitors request.
func (cook GetMonitorsCookie) Reply() (*GetMonitorsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMonitorsReply(buf), nil
}

// getMonitorsReply reads a byte slice into a GetMonitorsReply value.
func getMonitorsReply(buf []byte) *GetMonitorsReply {
	v := new(GetMonitorsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.NMonitors = xgb.Get32(buf[b:])
	b += 4

	v.NOutputs = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Monitors = make([]MonitorInfo, v.NMonitors)
	b += MonitorInfoReadList(buf[b:], v.Monitors)

	return v
}

// Write request to wire for GetMonitors
// getMonitorsRequest writes a GetMonitors request to a byte slice.
func getMonitorsRequest(c *xgb.Conn, Window xproto.Window, GetActive bool) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 42 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	if GetActive {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetOutputInfoCookie is a cookie used only for GetOutputInfo requests.
type GetOutputInfoCookie struct {
	*xgb.Cookie
}

// GetOutputInfo sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetOutputInfoCookie.Reply()
func GetOutputInfo(c *xgb.Conn, Output Output, ConfigTimestamp xproto.Timestamp) GetOutputInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetOutputInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getOutputInfoRequest(c, Output, ConfigTimestamp), cookie)
	return GetOutputInfoCookie{cookie}
}

// GetOutputInfoUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetOutputInfoUnchecked(c *xgb.Conn, Output Output, ConfigTimestamp xproto.Timestamp) GetOutputInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetOutputInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getOutputInfoRequest(c, Output, ConfigTimestamp), cookie)
	return GetOutputInfoCookie{cookie}
}

// GetOutputInfoReply represents the data returned from a GetOutputInfo request.
type GetOutputInfoReply struct {
	Sequence      uint16 // sequence number of the request for this reply
	Length        uint32 // number of bytes in this reply
	Status        byte
	Timestamp     xproto.Timestamp
	Crtc          Crtc
	MmWidth       uint32
	MmHeight      uint32
	Connection    byte
	SubpixelOrder byte
	NumCrtcs      uint16
	NumModes      uint16
	NumPreferred  uint16
	NumClones     uint16
	NameLen       uint16
	Crtcs         []Crtc   // size: xgb.Pad((int(NumCrtcs) * 4))
	Modes         []Mode   // size: xgb.Pad((int(NumModes) * 4))
	Clones        []Output // size: xgb.Pad((int(NumClones) * 4))
	Name          []byte   // size: xgb.Pad((int(NameLen) * 1))
}

// Reply blocks and returns the reply data for a GetOutputInfo request.
func (cook GetOutputInfoCookie) Reply() (*GetOutputInfoReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getOutputInfoReply(buf), nil
}

// getOutputInfoReply reads a byte slice into a GetOutputInfoReply value.
func getOutputInfoReply(buf []byte) *GetOutputInfoReply {
	v := new(GetOutputInfoReply)
	b := 1 // skip reply determinant

	v.Status = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Crtc = Crtc(xgb.Get32(buf[b:]))
	b += 4

	v.MmWidth = xgb.Get32(buf[b:])
	b += 4

	v.MmHeight = xgb.Get32(buf[b:])
	b += 4

	v.Connection = buf[b]
	b += 1

	v.SubpixelOrder = buf[b]
	b += 1

	v.NumCrtcs = xgb.Get16(buf[b:])
	b += 2

	v.NumModes = xgb.Get16(buf[b:])
	b += 2

	v.NumPreferred = xgb.Get16(buf[b:])
	b += 2

	v.NumClones = xgb.Get16(buf[b:])
	b += 2

	v.NameLen = xgb.Get16(buf[b:])
	b += 2

	v.Crtcs = make([]Crtc, v.NumCrtcs)
	for i := 0; i < int(v.NumCrtcs); i++ {
		v.Crtcs[i] = Crtc(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Modes = make([]Mode, v.NumModes)
	for i := 0; i < int(v.NumModes); i++ {
		v.Modes[i] = Mode(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Clones = make([]Output, v.NumClones)
	for i := 0; i < int(v.NumClones); i++ {
		v.Clones[i] = Output(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Name = make([]byte, v.NameLen)
	copy(v.Name[:v.NameLen], buf[b:])
	b += int(v.NameLen)

	return v
}

// Write request to wire for GetOutputInfo
// getOutputInfoRequest writes a GetOutputInfo request to a byte slice.
func getOutputInfoRequest(c *xgb.Conn, Output Output, ConfigTimestamp xproto.Timestamp) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 9 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(ConfigTimestamp))
	b += 4

	return buf
}

// GetOutputPrimaryCookie is a cookie used only for GetOutputPrimary requests.
type GetOutputPrimaryCookie struct {
	*xgb.Cookie
}

// GetOutputPrimary sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetOutputPrimaryCookie.Reply()
func GetOutputPrimary(c *xgb.Conn, Window xproto.Window) GetOutputPrimaryCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetOutputPrimary' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getOutputPrimaryRequest(c, Window), cookie)
	return GetOutputPrimaryCookie{cookie}
}

// GetOutputPrimaryUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetOutputPrimaryUnchecked(c *xgb.Conn, Window xproto.Window) GetOutputPrimaryCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetOutputPrimary' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getOutputPrimaryRequest(c, Window), cookie)
	return GetOutputPrimaryCookie{cookie}
}

// GetOutputPrimaryReply represents the data returned from a GetOutputPrimary request.
type GetOutputPrimaryReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Output Output
}

// Reply blocks and returns the reply data for a GetOutputPrimary request.
func (cook GetOutputPrimaryCookie) Reply() (*GetOutputPrimaryReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getOutputPrimaryReply(buf), nil
}

// getOutputPrimaryReply reads a byte slice into a GetOutputPrimaryReply value.
func getOutputPrimaryReply(buf []byte) *GetOutputPrimaryReply {
	v := new(GetOutputPrimaryReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Output = Output(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for GetOutputPrimary
// getOutputPrimaryRequest writes a GetOutputPrimary request to a byte slice.
func getOutputPrimaryRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 31 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// GetOutputPropertyCookie is a cookie used only for GetOutputProperty requests.
type GetOutputPropertyCookie struct {
	*xgb.Cookie
}

// GetOutputProperty sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetOutputPropertyCookie.Reply()
func GetOutputProperty(c *xgb.Conn, Output Output, Property xproto.Atom, Type xproto.Atom, LongOffset uint32, LongLength uint32, Delete bool, Pending bool) GetOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getOutputPropertyRequest(c, Output, Property, Type, LongOffset, LongLength, Delete, Pending), cookie)
	return GetOutputPropertyCookie{cookie}
}

// GetOutputPropertyUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetOutputPropertyUnchecked(c *xgb.Conn, Output Output, Property xproto.Atom, Type xproto.Atom, LongOffset uint32, LongLength uint32, Delete bool, Pending bool) GetOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getOutputPropertyRequest(c, Output, Property, Type, LongOffset, LongLength, Delete, Pending), cookie)
	return GetOutputPropertyCookie{cookie}
}

// GetOutputPropertyReply represents the data returned from a GetOutputProperty request.
type GetOutputPropertyReply struct {
	Sequence   uint16 // sequence number of the request for this reply
	Length     uint32 // number of bytes in this reply
	Format     byte
	Type       xproto.Atom
	BytesAfter uint32
	NumItems   uint32
	// padding: 12 bytes
	Data []byte // size: xgb.Pad(((int(NumItems) * (int(Format) / 8)) * 1))
}

// Reply blocks and returns the reply data for a GetOutputProperty request.
func (cook GetOutputPropertyCookie) Reply() (*GetOutputPropertyReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getOutputPropertyReply(buf), nil
}

// getOutputPropertyReply reads a byte slice into a GetOutputPropertyReply value.
func getOutputPropertyReply(buf []byte) *GetOutputPropertyReply {
	v := new(GetOutputPropertyReply)
	b := 1 // skip reply determinant

	v.Format = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Type = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.BytesAfter = xgb.Get32(buf[b:])
	b += 4

	v.NumItems = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Data = make([]byte, (int(v.NumItems) * (int(v.Format) / 8)))
	copy(v.Data[:(int(v.NumItems)*(int(v.Format)/8))], buf[b:])
	b += int((int(v.NumItems) * (int(v.Format) / 8)))

	return v
}

// Write request to wire for GetOutputProperty
// getOutputPropertyRequest writes a GetOutputProperty request to a byte slice.
func getOutputPropertyRequest(c *xgb.Conn, Output Output, Property xproto.Atom, Type xproto.Atom, LongOffset uint32, LongLength uint32, Delete bool, Pending bool) []byte {
	size := 28
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 15 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	xgb.Put32(buf[b:], uint32(Type))
	b += 4

	xgb.Put32(buf[b:], LongOffset)
	b += 4

	xgb.Put32(buf[b:], LongLength)
	b += 4

	if Delete {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if Pending {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 2 // padding

	return buf
}

// GetPanningCookie is a cookie used only for GetPanning requests.
type GetPanningCookie struct {
	*xgb.Cookie
}

// GetPanning sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPanningCookie.Reply()
func GetPanning(c *xgb.Conn, Crtc Crtc) GetPanningCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetPanning' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPanningRequest(c, Crtc), cookie)
	return GetPanningCookie{cookie}
}

// GetPanningUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPanningUnchecked(c *xgb.Conn, Crtc Crtc) GetPanningCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetPanning' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPanningRequest(c, Crtc), cookie)
	return GetPanningCookie{cookie}
}

// GetPanningReply represents the data returned from a GetPanning request.
type GetPanningReply struct {
	Sequence     uint16 // sequence number of the request for this reply
	Length       uint32 // number of bytes in this reply
	Status       byte
	Timestamp    xproto.Timestamp
	Left         uint16
	Top          uint16
	Width        uint16
	Height       uint16
	TrackLeft    uint16
	TrackTop     uint16
	TrackWidth   uint16
	TrackHeight  uint16
	BorderLeft   int16
	BorderTop    int16
	BorderRight  int16
	BorderBottom int16
}

// Reply blocks and returns the reply data for a GetPanning request.
func (cook GetPanningCookie) Reply() (*GetPanningReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPanningReply(buf), nil
}

// getPanningReply reads a byte slice into a GetPanningReply value.
func getPanningReply(buf []byte) *GetPanningReply {
	v := new(GetPanningReply)
	b := 1 // skip reply determinant

	v.Status = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Left = xgb.Get16(buf[b:])
	b += 2

	v.Top = xgb.Get16(buf[b:])
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.TrackLeft = xgb.Get16(buf[b:])
	b += 2

	v.TrackTop = xgb.Get16(buf[b:])
	b += 2

	v.TrackWidth = xgb.Get16(buf[b:])
	b += 2

	v.TrackHeight = xgb.Get16(buf[b:])
	b += 2

	v.BorderLeft = int16(xgb.Get16(buf[b:]))
	b += 2

	v.BorderTop = int16(xgb.Get16(buf[b:]))
	b += 2

	v.BorderRight = int16(xgb.Get16(buf[b:]))
	b += 2

	v.BorderBottom = int16(xgb.Get16(buf[b:]))
	b += 2

	return v
}

// Write request to wire for GetPanning
// getPanningRequest writes a GetPanning request to a byte slice.
func getPanningRequest(c *xgb.Conn, Crtc Crtc) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 28 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	return buf
}

// GetProviderInfoCookie is a cookie used only for GetProviderInfo requests.
type GetProviderInfoCookie struct {
	*xgb.Cookie
}

// GetProviderInfo sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetProviderInfoCookie.Reply()
func GetProviderInfo(c *xgb.Conn, Provider Provider, ConfigTimestamp xproto.Timestamp) GetProviderInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetProviderInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getProviderInfoRequest(c, Provider, ConfigTimestamp), cookie)
	return GetProviderInfoCookie{cookie}
}

// GetProviderInfoUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetProviderInfoUnchecked(c *xgb.Conn, Provider Provider, ConfigTimestamp xproto.Timestamp) GetProviderInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetProviderInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getProviderInfoRequest(c, Provider, ConfigTimestamp), cookie)
	return GetProviderInfoCookie{cookie}
}

// GetProviderInfoReply represents the data returned from a GetProviderInfo request.
type GetProviderInfoReply struct {
	Sequence               uint16 // sequence number of the request for this reply
	Length                 uint32 // number of bytes in this reply
	Status                 byte
	Timestamp              xproto.Timestamp
	Capabilities           uint32
	NumCrtcs               uint16
	NumOutputs             uint16
	NumAssociatedProviders uint16
	NameLen                uint16
	// padding: 8 bytes
	Crtcs                []Crtc     // size: xgb.Pad((int(NumCrtcs) * 4))
	Outputs              []Output   // size: xgb.Pad((int(NumOutputs) * 4))
	AssociatedProviders  []Provider // size: xgb.Pad((int(NumAssociatedProviders) * 4))
	AssociatedCapability []uint32   // size: xgb.Pad((int(NumAssociatedProviders) * 4))
	Name                 string     // size: xgb.Pad((int(NameLen) * 1))
}

// Reply blocks and returns the reply data for a GetProviderInfo request.
func (cook GetProviderInfoCookie) Reply() (*GetProviderInfoReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getProviderInfoReply(buf), nil
}

// getProviderInfoReply reads a byte slice into a GetProviderInfoReply value.
func getProviderInfoReply(buf []byte) *GetProviderInfoReply {
	v := new(GetProviderInfoReply)
	b := 1 // skip reply determinant

	v.Status = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Capabilities = xgb.Get32(buf[b:])
	b += 4

	v.NumCrtcs = xgb.Get16(buf[b:])
	b += 2

	v.NumOutputs = xgb.Get16(buf[b:])
	b += 2

	v.NumAssociatedProviders = xgb.Get16(buf[b:])
	b += 2

	v.NameLen = xgb.Get16(buf[b:])
	b += 2

	b += 8 // padding

	v.Crtcs = make([]Crtc, v.NumCrtcs)
	for i := 0; i < int(v.NumCrtcs); i++ {
		v.Crtcs[i] = Crtc(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Outputs = make([]Output, v.NumOutputs)
	for i := 0; i < int(v.NumOutputs); i++ {
		v.Outputs[i] = Output(xgb.Get32(buf[b:]))
		b += 4
	}

	v.AssociatedProviders = make([]Provider, v.NumAssociatedProviders)
	for i := 0; i < int(v.NumAssociatedProviders); i++ {
		v.AssociatedProviders[i] = Provider(xgb.Get32(buf[b:]))
		b += 4
	}

	v.AssociatedCapability = make([]uint32, v.NumAssociatedProviders)
	for i := 0; i < int(v.NumAssociatedProviders); i++ {
		v.AssociatedCapability[i] = xgb.Get32(buf[b:])
		b += 4
	}

	{
		byteString := make([]byte, v.NameLen)
		copy(byteString[:v.NameLen], buf[b:])
		v.Name = string(byteString)
		b += int(v.NameLen)
	}

	return v
}

// Write request to wire for GetProviderInfo
// getProviderInfoRequest writes a GetProviderInfo request to a byte slice.
func getProviderInfoRequest(c *xgb.Conn, Provider Provider, ConfigTimestamp xproto.Timestamp) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 33 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(ConfigTimestamp))
	b += 4

	return buf
}

// GetProviderPropertyCookie is a cookie used only for GetProviderProperty requests.
type GetProviderPropertyCookie struct {
	*xgb.Cookie
}

// GetProviderProperty sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetProviderPropertyCookie.Reply()
func GetProviderProperty(c *xgb.Conn, Provider Provider, Property xproto.Atom, Type xproto.Atom, LongOffset uint32, LongLength uint32, Delete bool, Pending bool) GetProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getProviderPropertyRequest(c, Provider, Property, Type, LongOffset, LongLength, Delete, Pending), cookie)
	return GetProviderPropertyCookie{cookie}
}

// GetProviderPropertyUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetProviderPropertyUnchecked(c *xgb.Conn, Provider Provider, Property xproto.Atom, Type xproto.Atom, LongOffset uint32, LongLength uint32, Delete bool, Pending bool) GetProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getProviderPropertyRequest(c, Provider, Property, Type, LongOffset, LongLength, Delete, Pending), cookie)
	return GetProviderPropertyCookie{cookie}
}

// GetProviderPropertyReply represents the data returned from a GetProviderProperty request.
type GetProviderPropertyReply struct {
	Sequence   uint16 // sequence number of the request for this reply
	Length     uint32 // number of bytes in this reply
	Format     byte
	Type       xproto.Atom
	BytesAfter uint32
	NumItems   uint32
	// padding: 12 bytes
	Data []byte // size: xgb.Pad(((int(NumItems) * (int(Format) / 8)) * 1))
}

// Reply blocks and returns the reply data for a GetProviderProperty request.
func (cook GetProviderPropertyCookie) Reply() (*GetProviderPropertyReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getProviderPropertyReply(buf), nil
}

// getProviderPropertyReply reads a byte slice into a GetProviderPropertyReply value.
func getProviderPropertyReply(buf []byte) *GetProviderPropertyReply {
	v := new(GetProviderPropertyReply)
	b := 1 // skip reply determinant

	v.Format = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Type = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.BytesAfter = xgb.Get32(buf[b:])
	b += 4

	v.NumItems = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Data = make([]byte, (int(v.NumItems) * (int(v.Format) / 8)))
	copy(v.Data[:(int(v.NumItems)*(int(v.Format)/8))], buf[b:])
	b += int((int(v.NumItems) * (int(v.Format) / 8)))

	return v
}

// Write request to wire for GetProviderProperty
// getProviderPropertyRequest writes a GetProviderProperty request to a byte slice.
func getProviderPropertyRequest(c *xgb.Conn, Provider Provider, Property xproto.Atom, Type xproto.Atom, LongOffset uint32, LongLength uint32, Delete bool, Pending bool) []byte {
	size := 28
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 41 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	xgb.Put32(buf[b:], uint32(Type))
	b += 4

	xgb.Put32(buf[b:], LongOffset)
	b += 4

	xgb.Put32(buf[b:], LongLength)
	b += 4

	if Delete {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if Pending {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 2 // padding

	return buf
}

// GetProvidersCookie is a cookie used only for GetProviders requests.
type GetProvidersCookie struct {
	*xgb.Cookie
}

// GetProviders sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetProvidersCookie.Reply()
func GetProviders(c *xgb.Conn, Window xproto.Window) GetProvidersCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetProviders' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getProvidersRequest(c, Window), cookie)
	return GetProvidersCookie{cookie}
}

// GetProvidersUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetProvidersUnchecked(c *xgb.Conn, Window xproto.Window) GetProvidersCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetProviders' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getProvidersRequest(c, Window), cookie)
	return GetProvidersCookie{cookie}
}

// GetProvidersReply represents the data returned from a GetProviders request.
type GetProvidersReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Timestamp    xproto.Timestamp
	NumProviders uint16
	// padding: 18 bytes
	Providers []Provider // size: xgb.Pad((int(NumProviders) * 4))
}

// Reply blocks and returns the reply data for a GetProviders request.
func (cook GetProvidersCookie) Reply() (*GetProvidersReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getProvidersReply(buf), nil
}

// getProvidersReply reads a byte slice into a GetProvidersReply value.
func getProvidersReply(buf []byte) *GetProvidersReply {
	v := new(GetProvidersReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.NumProviders = xgb.Get16(buf[b:])
	b += 2

	b += 18 // padding

	v.Providers = make([]Provider, v.NumProviders)
	for i := 0; i < int(v.NumProviders); i++ {
		v.Providers[i] = Provider(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetProviders
// getProvidersRequest writes a GetProviders request to a byte slice.
func getProvidersRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 32 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// GetScreenInfoCookie is a cookie used only for GetScreenInfo requests.
type GetScreenInfoCookie struct {
	*xgb.Cookie
}

// GetScreenInfo sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetScreenInfoCookie.Reply()
func GetScreenInfo(c *xgb.Conn, Window xproto.Window) GetScreenInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getScreenInfoRequest(c, Window), cookie)
	return GetScreenInfoCookie{cookie}
}

// GetScreenInfoUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetScreenInfoUnchecked(c *xgb.Conn, Window xproto.Window) GetScreenInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenInfo' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getScreenInfoRequest(c, Window), cookie)
	return GetScreenInfoCookie{cookie}
}

// GetScreenInfoReply represents the data returned from a GetScreenInfo request.
type GetScreenInfoReply struct {
	Sequence        uint16 // sequence number of the request for this reply
	Length          uint32 // number of bytes in this reply
	Rotations       byte
	Root            xproto.Window
	Timestamp       xproto.Timestamp
	ConfigTimestamp xproto.Timestamp
	NSizes          uint16
	SizeID          uint16
	Rotation        uint16
	Rate            uint16
	NInfo           uint16
	// padding: 2 bytes
	Sizes []ScreenSize   // size: xgb.Pad((int(NSizes) * 8))
	Rates []RefreshRates // size: RefreshRatesListSize(Rates)
}

// Reply blocks and returns the reply data for a GetScreenInfo request.
func (cook GetScreenInfoCookie) Reply() (*GetScreenInfoReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getScreenInfoReply(buf), nil
}

// getScreenInfoReply reads a byte slice into a GetScreenInfoReply value.
func getScreenInfoReply(buf []byte) *GetScreenInfoReply {
	v := new(GetScreenInfoReply)
	b := 1 // skip reply determinant

	v.Rotations = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Root = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.ConfigTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.NSizes = xgb.Get16(buf[b:])
	b += 2

	v.SizeID = xgb.Get16(buf[b:])
	b += 2

	v.Rotation = xgb.Get16(buf[b:])
	b += 2

	v.Rate = xgb.Get16(buf[b:])
	b += 2

	v.NInfo = xgb.Get16(buf[b:])
	b += 2

	b += 2 // padding

	v.Sizes = make([]ScreenSize, v.NSizes)
	b += ScreenSizeReadList(buf[b:], v.Sizes)

	v.Rates = make([]RefreshRates, (int(v.NInfo) - int(v.NSizes)))
	b += RefreshRatesReadList(buf[b:], v.Rates)

	return v
}

// Write request to wire for GetScreenInfo
// getScreenInfoRequest writes a GetScreenInfo request to a byte slice.
func getScreenInfoRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 5 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// GetScreenResourcesCookie is a cookie used only for GetScreenResources requests.
type GetScreenResourcesCookie struct {
	*xgb.Cookie
}

// GetScreenResources sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetScreenResourcesCookie.Reply()
func GetScreenResources(c *xgb.Conn, Window xproto.Window) GetScreenResourcesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenResources' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getScreenResourcesRequest(c, Window), cookie)
	return GetScreenResourcesCookie{cookie}
}

// GetScreenResourcesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetScreenResourcesUnchecked(c *xgb.Conn, Window xproto.Window) GetScreenResourcesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenResources' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getScreenResourcesRequest(c, Window), cookie)
	return GetScreenResourcesCookie{cookie}
}

// GetScreenResourcesReply represents the data returned from a GetScreenResources request.
type GetScreenResourcesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Timestamp       xproto.Timestamp
	ConfigTimestamp xproto.Timestamp
	NumCrtcs        uint16
	NumOutputs      uint16
	NumModes        uint16
	NamesLen        uint16
	// padding: 8 bytes
	Crtcs   []Crtc     // size: xgb.Pad((int(NumCrtcs) * 4))
	Outputs []Output   // size: xgb.Pad((int(NumOutputs) * 4))
	Modes   []ModeInfo // size: xgb.Pad((int(NumModes) * 32))
	Names   []byte     // size: xgb.Pad((int(NamesLen) * 1))
}

// Reply blocks and returns the reply data for a GetScreenResources request.
func (cook GetScreenResourcesCookie) Reply() (*GetScreenResourcesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getScreenResourcesReply(buf), nil
}

// getScreenResourcesReply reads a byte slice into a GetScreenResourcesReply value.
func getScreenResourcesReply(buf []byte) *GetScreenResourcesReply {
	v := new(GetScreenResourcesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.ConfigTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.NumCrtcs = xgb.Get16(buf[b:])
	b += 2

	v.NumOutputs = xgb.Get16(buf[b:])
	b += 2

	v.NumModes = xgb.Get16(buf[b:])
	b += 2

	v.NamesLen = xgb.Get16(buf[b:])
	b += 2

	b += 8 // padding

	v.Crtcs = make([]Crtc, v.NumCrtcs)
	for i := 0; i < int(v.NumCrtcs); i++ {
		v.Crtcs[i] = Crtc(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Outputs = make([]Output, v.NumOutputs)
	for i := 0; i < int(v.NumOutputs); i++ {
		v.Outputs[i] = Output(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Modes = make([]ModeInfo, v.NumModes)
	b += ModeInfoReadList(buf[b:], v.Modes)

	v.Names = make([]byte, v.NamesLen)
	copy(v.Names[:v.NamesLen], buf[b:])
	b += int(v.NamesLen)

	return v
}

// Write request to wire for GetScreenResources
// getScreenResourcesRequest writes a GetScreenResources request to a byte slice.
func getScreenResourcesRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 8 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// GetScreenResourcesCurrentCookie is a cookie used only for GetScreenResourcesCurrent requests.
type GetScreenResourcesCurrentCookie struct {
	*xgb.Cookie
}

// GetScreenResourcesCurrent sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetScreenResourcesCurrentCookie.Reply()
func GetScreenResourcesCurrent(c *xgb.Conn, Window xproto.Window) GetScreenResourcesCurrentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenResourcesCurrent' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getScreenResourcesCurrentRequest(c, Window), cookie)
	return GetScreenResourcesCurrentCookie{cookie}
}

// GetScreenResourcesCurrentUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetScreenResourcesCurrentUnchecked(c *xgb.Conn, Window xproto.Window) GetScreenResourcesCurrentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenResourcesCurrent' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getScreenResourcesCurrentRequest(c, Window), cookie)
	return GetScreenResourcesCurrentCookie{cookie}
}

// GetScreenResourcesCurrentReply represents the data returned from a GetScreenResourcesCurrent request.
type GetScreenResourcesCurrentReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Timestamp       xproto.Timestamp
	ConfigTimestamp xproto.Timestamp
	NumCrtcs        uint16
	NumOutputs      uint16
	NumModes        uint16
	NamesLen        uint16
	// padding: 8 bytes
	Crtcs   []Crtc     // size: xgb.Pad((int(NumCrtcs) * 4))
	Outputs []Output   // size: xgb.Pad((int(NumOutputs) * 4))
	Modes   []ModeInfo // size: xgb.Pad((int(NumModes) * 32))
	Names   []byte     // size: xgb.Pad((int(NamesLen) * 1))
}

// Reply blocks and returns the reply data for a GetScreenResourcesCurrent request.
func (cook GetScreenResourcesCurrentCookie) Reply() (*GetScreenResourcesCurrentReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getScreenResourcesCurrentReply(buf), nil
}

// getScreenResourcesCurrentReply reads a byte slice into a GetScreenResourcesCurrentReply value.
func getScreenResourcesCurrentReply(buf []byte) *GetScreenResourcesCurrentReply {
	v := new(GetScreenResourcesCurrentReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.ConfigTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.NumCrtcs = xgb.Get16(buf[b:])
	b += 2

	v.NumOutputs = xgb.Get16(buf[b:])
	b += 2

	v.NumModes = xgb.Get16(buf[b:])
	b += 2

	v.NamesLen = xgb.Get16(buf[b:])
	b += 2

	b += 8 // padding

	v.Crtcs = make([]Crtc, v.NumCrtcs)
	for i := 0; i < int(v.NumCrtcs); i++ {
		v.Crtcs[i] = Crtc(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Outputs = make([]Output, v.NumOutputs)
	for i := 0; i < int(v.NumOutputs); i++ {
		v.Outputs[i] = Output(xgb.Get32(buf[b:]))
		b += 4
	}

	v.Modes = make([]ModeInfo, v.NumModes)
	b += ModeInfoReadList(buf[b:], v.Modes)

	v.Names = make([]byte, v.NamesLen)
	copy(v.Names[:v.NamesLen], buf[b:])
	b += int(v.NamesLen)

	return v
}

// Write request to wire for GetScreenResourcesCurrent
// getScreenResourcesCurrentRequest writes a GetScreenResourcesCurrent request to a byte slice.
func getScreenResourcesCurrentRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 25 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// GetScreenSizeRangeCookie is a cookie used only for GetScreenSizeRange requests.
type GetScreenSizeRangeCookie struct {
	*xgb.Cookie
}

// GetScreenSizeRange sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetScreenSizeRangeCookie.Reply()
func GetScreenSizeRange(c *xgb.Conn, Window xproto.Window) GetScreenSizeRangeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenSizeRange' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getScreenSizeRangeRequest(c, Window), cookie)
	return GetScreenSizeRangeCookie{cookie}
}

// GetScreenSizeRangeUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetScreenSizeRangeUnchecked(c *xgb.Conn, Window xproto.Window) GetScreenSizeRangeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'GetScreenSizeRange' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getScreenSizeRangeRequest(c, Window), cookie)
	return GetScreenSizeRangeCookie{cookie}
}

// GetScreenSizeRangeReply represents the data returned from a GetScreenSizeRange request.
type GetScreenSizeRangeReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	MinWidth  uint16
	MinHeight uint16
	MaxWidth  uint16
	MaxHeight uint16
	// padding: 16 bytes
}

// Reply blocks and returns the reply data for a GetScreenSizeRange request.
func (cook GetScreenSizeRangeCookie) Reply() (*GetScreenSizeRangeReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getScreenSizeRangeReply(buf), nil
}

// getScreenSizeRangeReply reads a byte slice into a GetScreenSizeRangeReply value.
func getScreenSizeRangeReply(buf []byte) *GetScreenSizeRangeReply {
	v := new(GetScreenSizeRangeReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.MinWidth = xgb.Get16(buf[b:])
	b += 2

	v.MinHeight = xgb.Get16(buf[b:])
	b += 2

	v.MaxWidth = xgb.Get16(buf[b:])
	b += 2

	v.MaxHeight = xgb.Get16(buf[b:])
	b += 2

	b += 16 // padding

	return v
}

// Write request to wire for GetScreenSizeRange
// getScreenSizeRangeRequest writes a GetScreenSizeRange request to a byte slice.
func getScreenSizeRangeRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 6 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// ListOutputPropertiesCookie is a cookie used only for ListOutputProperties requests.
type ListOutputPropertiesCookie struct {
	*xgb.Cookie
}

// ListOutputProperties sends a checked request.
// If an error occurs, it will be returned with the reply by calling ListOutputPropertiesCookie.Reply()
func ListOutputProperties(c *xgb.Conn, Output Output) ListOutputPropertiesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ListOutputProperties' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(listOutputPropertiesRequest(c, Output), cookie)
	return ListOutputPropertiesCookie{cookie}
}

// ListOutputPropertiesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ListOutputPropertiesUnchecked(c *xgb.Conn, Output Output) ListOutputPropertiesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ListOutputProperties' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(listOutputPropertiesRequest(c, Output), cookie)
	return ListOutputPropertiesCookie{cookie}
}

// ListOutputPropertiesReply represents the data returned from a ListOutputProperties request.
type ListOutputPropertiesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumAtoms uint16
	// padding: 22 bytes
	Atoms []xproto.Atom // size: xgb.Pad((int(NumAtoms) * 4))
}

// Reply blocks and returns the reply data for a ListOutputProperties request.
func (cook ListOutputPropertiesCookie) Reply() (*ListOutputPropertiesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return listOutputPropertiesReply(buf), nil
}

// listOutputPropertiesReply reads a byte slice into a ListOutputPropertiesReply value.
func listOutputPropertiesReply(buf []byte) *ListOutputPropertiesReply {
	v := new(ListOutputPropertiesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumAtoms = xgb.Get16(buf[b:])
	b += 2

	b += 22 // padding

	v.Atoms = make([]xproto.Atom, v.NumAtoms)
	for i := 0; i < int(v.NumAtoms); i++ {
		v.Atoms[i] = xproto.Atom(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for ListOutputProperties
// listOutputPropertiesRequest writes a ListOutputProperties request to a byte slice.
func listOutputPropertiesRequest(c *xgb.Conn, Output Output) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 10 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	return buf
}

// ListProviderPropertiesCookie is a cookie used only for ListProviderProperties requests.
type ListProviderPropertiesCookie struct {
	*xgb.Cookie
}

// ListProviderProperties sends a checked request.
// If an error occurs, it will be returned with the reply by calling ListProviderPropertiesCookie.Reply()
func ListProviderProperties(c *xgb.Conn, Provider Provider) ListProviderPropertiesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ListProviderProperties' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(listProviderPropertiesRequest(c, Provider), cookie)
	return ListProviderPropertiesCookie{cookie}
}

// ListProviderPropertiesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ListProviderPropertiesUnchecked(c *xgb.Conn, Provider Provider) ListProviderPropertiesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'ListProviderProperties' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(listProviderPropertiesRequest(c, Provider), cookie)
	return ListProviderPropertiesCookie{cookie}
}

// ListProviderPropertiesReply represents the data returned from a ListProviderProperties request.
type ListProviderPropertiesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumAtoms uint16
	// padding: 22 bytes
	Atoms []xproto.Atom // size: xgb.Pad((int(NumAtoms) * 4))
}

// Reply blocks and returns the reply data for a ListProviderProperties request.
func (cook ListProviderPropertiesCookie) Reply() (*ListProviderPropertiesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return listProviderPropertiesReply(buf), nil
}

// listProviderPropertiesReply reads a byte slice into a ListProviderPropertiesReply value.
func listProviderPropertiesReply(buf []byte) *ListProviderPropertiesReply {
	v := new(ListProviderPropertiesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumAtoms = xgb.Get16(buf[b:])
	b += 2

	b += 22 // padding

	v.Atoms = make([]xproto.Atom, v.NumAtoms)
	for i := 0; i < int(v.NumAtoms); i++ {
		v.Atoms[i] = xproto.Atom(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for ListProviderProperties
// listProviderPropertiesRequest writes a ListProviderProperties request to a byte slice.
func listProviderPropertiesRequest(c *xgb.Conn, Provider Provider) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 36 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	return buf
}

// QueryOutputPropertyCookie is a cookie used only for QueryOutputProperty requests.
type QueryOutputPropertyCookie struct {
	*xgb.Cookie
}

// QueryOutputProperty sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryOutputPropertyCookie.Reply()
func QueryOutputProperty(c *xgb.Conn, Output Output, Property xproto.Atom) QueryOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'QueryOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryOutputPropertyRequest(c, Output, Property), cookie)
	return QueryOutputPropertyCookie{cookie}
}

// QueryOutputPropertyUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryOutputPropertyUnchecked(c *xgb.Conn, Output Output, Property xproto.Atom) QueryOutputPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'QueryOutputProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryOutputPropertyRequest(c, Output, Property), cookie)
	return QueryOutputPropertyCookie{cookie}
}

// QueryOutputPropertyReply represents the data returned from a QueryOutputProperty request.
type QueryOutputPropertyReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Pending   bool
	Range     bool
	Immutable bool
	// padding: 21 bytes
	ValidValues []int32 // size: xgb.Pad((int(Length) * 4))
}

// Reply blocks and returns the reply data for a QueryOutputProperty request.
func (cook QueryOutputPropertyCookie) Reply() (*QueryOutputPropertyReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryOutputPropertyReply(buf), nil
}

// queryOutputPropertyReply reads a byte slice into a QueryOutputPropertyReply value.
func queryOutputPropertyReply(buf []byte) *QueryOutputPropertyReply {
	v := new(QueryOutputPropertyReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	if buf[b] == 1 {
		v.Pending = true
	} else {
		v.Pending = false
	}
	b += 1

	if buf[b] == 1 {
		v.Range = true
	} else {
		v.Range = false
	}
	b += 1

	if buf[b] == 1 {
		v.Immutable = true
	} else {
		v.Immutable = false
	}
	b += 1

	b += 21 // padding

	v.ValidValues = make([]int32, v.Length)
	for i := 0; i < int(v.Length); i++ {
		v.ValidValues[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for QueryOutputProperty
// queryOutputPropertyRequest writes a QueryOutputProperty request to a byte slice.
func queryOutputPropertyRequest(c *xgb.Conn, Output Output, Property xproto.Atom) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 11 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	return buf
}

// QueryProviderPropertyCookie is a cookie used only for QueryProviderProperty requests.
type QueryProviderPropertyCookie struct {
	*xgb.Cookie
}

// QueryProviderProperty sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryProviderPropertyCookie.Reply()
func QueryProviderProperty(c *xgb.Conn, Provider Provider, Property xproto.Atom) QueryProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'QueryProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryProviderPropertyRequest(c, Provider, Property), cookie)
	return QueryProviderPropertyCookie{cookie}
}

// QueryProviderPropertyUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryProviderPropertyUnchecked(c *xgb.Conn, Provider Provider, Property xproto.Atom) QueryProviderPropertyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'QueryProviderProperty' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryProviderPropertyRequest(c, Provider, Property), cookie)
	return QueryProviderPropertyCookie{cookie}
}

// QueryProviderPropertyReply represents the data returned from a QueryProviderProperty request.
type QueryProviderPropertyReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Pending   bool
	Range     bool
	Immutable bool
	// padding: 21 bytes
	ValidValues []int32 // size: xgb.Pad((int(Length) * 4))
}

// Reply blocks and returns the reply data for a QueryProviderProperty request.
func (cook QueryProviderPropertyCookie) Reply() (*QueryProviderPropertyReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryProviderPropertyReply(buf), nil
}

// queryProviderPropertyReply reads a byte slice into a QueryProviderPropertyReply value.
func queryProviderPropertyReply(buf []byte) *QueryProviderPropertyReply {
	v := new(QueryProviderPropertyReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	if buf[b] == 1 {
		v.Pending = true
	} else {
		v.Pending = false
	}
	b += 1

	if buf[b] == 1 {
		v.Range = true
	} else {
		v.Range = false
	}
	b += 1

	if buf[b] == 1 {
		v.Immutable = true
	} else {
		v.Immutable = false
	}
	b += 1

	b += 21 // padding

	v.ValidValues = make([]int32, v.Length)
	for i := 0; i < int(v.Length); i++ {
		v.ValidValues[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for QueryProviderProperty
// queryProviderPropertyRequest writes a QueryProviderProperty request to a byte slice.
func queryProviderPropertyRequest(c *xgb.Conn, Provider Provider, Property xproto.Atom) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 37 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	return buf
}

// QueryVersionCookie is a cookie used only for QueryVersion requests.
type QueryVersionCookie struct {
	*xgb.Cookie
}

// QueryVersion sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryVersionCookie.Reply()
func QueryVersion(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryVersionRequest(c, MajorVersion, MinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryVersionUnchecked(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryVersionRequest(c, MajorVersion, MinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionReply represents the data returned from a QueryVersion request.
type QueryVersionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	MajorVersion uint32
	MinorVersion uint32
	// padding: 16 bytes
}

// Reply blocks and returns the reply data for a QueryVersion request.
func (cook QueryVersionCookie) Reply() (*QueryVersionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryVersionReply(buf), nil
}

// queryVersionReply reads a byte slice into a QueryVersionReply value.
func queryVersionReply(buf []byte) *QueryVersionReply {
	v := new(QueryVersionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.MajorVersion = xgb.Get32(buf[b:])
	b += 4

	v.MinorVersion = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	return v
}

// Write request to wire for QueryVersion
// queryVersionRequest writes a QueryVersion request to a byte slice.
func queryVersionRequest(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 0 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], MajorVersion)
	b += 4

	xgb.Put32(buf[b:], MinorVersion)
	b += 4

	return buf
}

// SelectInputCookie is a cookie used only for SelectInput requests.
type SelectInputCookie struct {
	*xgb.Cookie
}

// SelectInput sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SelectInput(c *xgb.Conn, Window xproto.Window, Enable uint16) SelectInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SelectInput' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(selectInputRequest(c, Window, Enable), cookie)
	return SelectInputCookie{cookie}
}

// SelectInputChecked sends a checked request.
// If an error occurs, it can be retrieved using SelectInputCookie.Check()
func SelectInputChecked(c *xgb.Conn, Window xproto.Window, Enable uint16) SelectInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SelectInput' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(selectInputRequest(c, Window, Enable), cookie)
	return SelectInputCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SelectInputCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SelectInput
// selectInputRequest writes a SelectInput request to a byte slice.
func selectInputRequest(c *xgb.Conn, Window xproto.Window, Enable uint16) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 4 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put16(buf[b:], Enable)
	b += 2

	b += 2 // padding

	return buf
}

// SetCrtcConfigCookie is a cookie used only for SetCrtcConfig requests.
type SetCrtcConfigCookie struct {
	*xgb.Cookie
}

// SetCrtcConfig sends a checked request.
// If an error occurs, it will be returned with the reply by calling SetCrtcConfigCookie.Reply()
func SetCrtcConfig(c *xgb.Conn, Crtc Crtc, Timestamp xproto.Timestamp, ConfigTimestamp xproto.Timestamp, X int16, Y int16, Mode Mode, Rotation uint16, Outputs []Output) SetCrtcConfigCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetCrtcConfig' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(setCrtcConfigRequest(c, Crtc, Timestamp, ConfigTimestamp, X, Y, Mode, Rotation, Outputs), cookie)
	return SetCrtcConfigCookie{cookie}
}

// SetCrtcConfigUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetCrtcConfigUnchecked(c *xgb.Conn, Crtc Crtc, Timestamp xproto.Timestamp, ConfigTimestamp xproto.Timestamp, X int16, Y int16, Mode Mode, Rotation uint16, Outputs []Output) SetCrtcConfigCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetCrtcConfig' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(setCrtcConfigRequest(c, Crtc, Timestamp, ConfigTimestamp, X, Y, Mode, Rotation, Outputs), cookie)
	return SetCrtcConfigCookie{cookie}
}

// SetCrtcConfigReply represents the data returned from a SetCrtcConfig request.
type SetCrtcConfigReply struct {
	Sequence  uint16 // sequence number of the request for this reply
	Length    uint32 // number of bytes in this reply
	Status    byte
	Timestamp xproto.Timestamp
	// padding: 20 bytes
}

// Reply blocks and returns the reply data for a SetCrtcConfig request.
func (cook SetCrtcConfigCookie) Reply() (*SetCrtcConfigReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return setCrtcConfigReply(buf), nil
}

// setCrtcConfigReply reads a byte slice into a SetCrtcConfigReply value.
func setCrtcConfigReply(buf []byte) *SetCrtcConfigReply {
	v := new(SetCrtcConfigReply)
	b := 1 // skip reply determinant

	v.Status = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	b += 20 // padding

	return v
}

// Write request to wire for SetCrtcConfig
// setCrtcConfigRequest writes a SetCrtcConfig request to a byte slice.
func setCrtcConfigRequest(c *xgb.Conn, Crtc Crtc, Timestamp xproto.Timestamp, ConfigTimestamp xproto.Timestamp, X int16, Y int16, Mode Mode, Rotation uint16, Outputs []Output) []byte {
	size := xgb.Pad((28 + xgb.Pad((len(Outputs) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 21 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	xgb.Put32(buf[b:], uint32(Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(ConfigTimestamp))
	b += 4

	xgb.Put16(buf[b:], uint16(X))
	b += 2

	xgb.Put16(buf[b:], uint16(Y))
	b += 2

	xgb.Put32(buf[b:], uint32(Mode))
	b += 4

	xgb.Put16(buf[b:], Rotation)
	b += 2

	b += 2 // padding

	for i := 0; i < int(len(Outputs)); i++ {
		xgb.Put32(buf[b:], uint32(Outputs[i]))
		b += 4
	}

	return buf
}

// SetCrtcGammaCookie is a cookie used only for SetCrtcGamma requests.
type SetCrtcGammaCookie struct {
	*xgb.Cookie
}

// SetCrtcGamma sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetCrtcGamma(c *xgb.Conn, Crtc Crtc, Size uint16, Red []uint16, Green []uint16, Blue []uint16) SetCrtcGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetCrtcGamma' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setCrtcGammaRequest(c, Crtc, Size, Red, Green, Blue), cookie)
	return SetCrtcGammaCookie{cookie}
}

// SetCrtcGammaChecked sends a checked request.
// If an error occurs, it can be retrieved using SetCrtcGammaCookie.Check()
func SetCrtcGammaChecked(c *xgb.Conn, Crtc Crtc, Size uint16, Red []uint16, Green []uint16, Blue []uint16) SetCrtcGammaCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetCrtcGamma' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setCrtcGammaRequest(c, Crtc, Size, Red, Green, Blue), cookie)
	return SetCrtcGammaCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetCrtcGammaCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetCrtcGamma
// setCrtcGammaRequest writes a SetCrtcGamma request to a byte slice.
func setCrtcGammaRequest(c *xgb.Conn, Crtc Crtc, Size uint16, Red []uint16, Green []uint16, Blue []uint16) []byte {
	size := xgb.Pad((((12 + xgb.Pad((int(Size) * 2))) + xgb.Pad((int(Size) * 2))) + xgb.Pad((int(Size) * 2))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 24 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	xgb.Put16(buf[b:], Size)
	b += 2

	b += 2 // padding

	for i := 0; i < int(Size); i++ {
		xgb.Put16(buf[b:], Red[i])
		b += 2
	}

	for i := 0; i < int(Size); i++ {
		xgb.Put16(buf[b:], Green[i])
		b += 2
	}

	for i := 0; i < int(Size); i++ {
		xgb.Put16(buf[b:], Blue[i])
		b += 2
	}

	return buf
}

// SetCrtcTransformCookie is a cookie used only for SetCrtcTransform requests.
type SetCrtcTransformCookie struct {
	*xgb.Cookie
}

// SetCrtcTransform sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetCrtcTransform(c *xgb.Conn, Crtc Crtc, Transform render.Transform, FilterLen uint16, FilterName string, FilterParams []render.Fixed) SetCrtcTransformCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetCrtcTransform' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setCrtcTransformRequest(c, Crtc, Transform, FilterLen, FilterName, FilterParams), cookie)
	return SetCrtcTransformCookie{cookie}
}

// SetCrtcTransformChecked sends a checked request.
// If an error occurs, it can be retrieved using SetCrtcTransformCookie.Check()
func SetCrtcTransformChecked(c *xgb.Conn, Crtc Crtc, Transform render.Transform, FilterLen uint16, FilterName string, FilterParams []render.Fixed) SetCrtcTransformCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetCrtcTransform' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setCrtcTransformRequest(c, Crtc, Transform, FilterLen, FilterName, FilterParams), cookie)
	return SetCrtcTransformCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetCrtcTransformCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetCrtcTransform
// setCrtcTransformRequest writes a SetCrtcTransform request to a byte slice.
func setCrtcTransformRequest(c *xgb.Conn, Crtc Crtc, Transform render.Transform, FilterLen uint16, FilterName string, FilterParams []render.Fixed) []byte {
	size := xgb.Pad((((48 + xgb.Pad((int(FilterLen) * 1))) + 4) + xgb.Pad((len(FilterParams) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 26 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	{
		structBytes := Transform.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	xgb.Put16(buf[b:], FilterLen)
	b += 2

	b += 2 // padding

	copy(buf[b:], FilterName[:FilterLen])
	b += int(FilterLen)

	b = (b + 3) & ^3 // alignment gap

	for i := 0; i < int(len(FilterParams)); i++ {
		xgb.Put32(buf[b:], uint32(FilterParams[i]))
		b += 4
	}

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// SetMonitorCookie is a cookie used only for SetMonitor requests.
type SetMonitorCookie struct {
	*xgb.Cookie
}

// SetMonitor sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetMonitor(c *xgb.Conn, Window xproto.Window, Monitorinfo MonitorInfo) SetMonitorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetMonitor' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setMonitorRequest(c, Window, Monitorinfo), cookie)
	return SetMonitorCookie{cookie}
}

// SetMonitorChecked sends a checked request.
// If an error occurs, it can be retrieved using SetMonitorCookie.Check()
func SetMonitorChecked(c *xgb.Conn, Window xproto.Window, Monitorinfo MonitorInfo) SetMonitorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetMonitor' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setMonitorRequest(c, Window, Monitorinfo), cookie)
	return SetMonitorCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetMonitorCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetMonitor
// setMonitorRequest writes a SetMonitor request to a byte slice.
func setMonitorRequest(c *xgb.Conn, Window xproto.Window, Monitorinfo MonitorInfo) []byte {
	size := xgb.Pad((8 + (24 + xgb.Pad((int(Monitorinfo.NOutput) * 4)))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 43 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	{
		structBytes := Monitorinfo.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	return buf
}

// SetOutputPrimaryCookie is a cookie used only for SetOutputPrimary requests.
type SetOutputPrimaryCookie struct {
	*xgb.Cookie
}

// SetOutputPrimary sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetOutputPrimary(c *xgb.Conn, Window xproto.Window, Output Output) SetOutputPrimaryCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetOutputPrimary' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setOutputPrimaryRequest(c, Window, Output), cookie)
	return SetOutputPrimaryCookie{cookie}
}

// SetOutputPrimaryChecked sends a checked request.
// If an error occurs, it can be retrieved using SetOutputPrimaryCookie.Check()
func SetOutputPrimaryChecked(c *xgb.Conn, Window xproto.Window, Output Output) SetOutputPrimaryCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetOutputPrimary' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setOutputPrimaryRequest(c, Window, Output), cookie)
	return SetOutputPrimaryCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetOutputPrimaryCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetOutputPrimary
// setOutputPrimaryRequest writes a SetOutputPrimary request to a byte slice.
func setOutputPrimaryRequest(c *xgb.Conn, Window xproto.Window, Output Output) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 30 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(Output))
	b += 4

	return buf
}

// SetPanningCookie is a cookie used only for SetPanning requests.
type SetPanningCookie struct {
	*xgb.Cookie
}

// SetPanning sends a checked request.
// If an error occurs, it will be returned with the reply by calling SetPanningCookie.Reply()
func SetPanning(c *xgb.Conn, Crtc Crtc, Timestamp xproto.Timestamp, Left uint16, Top uint16, Width uint16, Height uint16, TrackLeft uint16, TrackTop uint16, TrackWidth uint16, TrackHeight uint16, BorderLeft int16, BorderTop int16, BorderRight int16, BorderBottom int16) SetPanningCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetPanning' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(setPanningRequest(c, Crtc, Timestamp, Left, Top, Width, Height, TrackLeft, TrackTop, TrackWidth, TrackHeight, BorderLeft, BorderTop, BorderRight, BorderBottom), cookie)
	return SetPanningCookie{cookie}
}

// SetPanningUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetPanningUnchecked(c *xgb.Conn, Crtc Crtc, Timestamp xproto.Timestamp, Left uint16, Top uint16, Width uint16, Height uint16, TrackLeft uint16, TrackTop uint16, TrackWidth uint16, TrackHeight uint16, BorderLeft int16, BorderTop int16, BorderRight int16, BorderBottom int16) SetPanningCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetPanning' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(setPanningRequest(c, Crtc, Timestamp, Left, Top, Width, Height, TrackLeft, TrackTop, TrackWidth, TrackHeight, BorderLeft, BorderTop, BorderRight, BorderBottom), cookie)
	return SetPanningCookie{cookie}
}

// SetPanningReply represents the data returned from a SetPanning request.
type SetPanningReply struct {
	Sequence  uint16 // sequence number of the request for this reply
	Length    uint32 // number of bytes in this reply
	Status    byte
	Timestamp xproto.Timestamp
}

// Reply blocks and returns the reply data for a SetPanning request.
func (cook SetPanningCookie) Reply() (*SetPanningReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return setPanningReply(buf), nil
}

// setPanningReply reads a byte slice into a SetPanningReply value.
func setPanningReply(buf []byte) *SetPanningReply {
	v := new(SetPanningReply)
	b := 1 // skip reply determinant

	v.Status = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for SetPanning
// setPanningRequest writes a SetPanning request to a byte slice.
func setPanningRequest(c *xgb.Conn, Crtc Crtc, Timestamp xproto.Timestamp, Left uint16, Top uint16, Width uint16, Height uint16, TrackLeft uint16, TrackTop uint16, TrackWidth uint16, TrackHeight uint16, BorderLeft int16, BorderTop int16, BorderRight int16, BorderBottom int16) []byte {
	size := 36
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 29 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Crtc))
	b += 4

	xgb.Put32(buf[b:], uint32(Timestamp))
	b += 4

	xgb.Put16(buf[b:], Left)
	b += 2

	xgb.Put16(buf[b:], Top)
	b += 2

	xgb.Put16(buf[b:], Width)
	b += 2

	xgb.Put16(buf[b:], Height)
	b += 2

	xgb.Put16(buf[b:], TrackLeft)
	b += 2

	xgb.Put16(buf[b:], TrackTop)
	b += 2

	xgb.Put16(buf[b:], TrackWidth)
	b += 2

	xgb.Put16(buf[b:], TrackHeight)
	b += 2

	xgb.Put16(buf[b:], uint16(BorderLeft))
	b += 2

	xgb.Put16(buf[b:], uint16(BorderTop))
	b += 2

	xgb.Put16(buf[b:], uint16(BorderRight))
	b += 2

	xgb.Put16(buf[b:], uint16(BorderBottom))
	b += 2

	return buf
}

// SetProviderOffloadSinkCookie is a cookie used only for SetProviderOffloadSink requests.
type SetProviderOffloadSinkCookie struct {
	*xgb.Cookie
}

// SetProviderOffloadSink sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetProviderOffloadSink(c *xgb.Conn, Provider Provider, SinkProvider Provider, ConfigTimestamp xproto.Timestamp) SetProviderOffloadSinkCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetProviderOffloadSink' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setProviderOffloadSinkRequest(c, Provider, SinkProvider, ConfigTimestamp), cookie)
	return SetProviderOffloadSinkCookie{cookie}
}

// SetProviderOffloadSinkChecked sends a checked request.
// If an error occurs, it can be retrieved using SetProviderOffloadSinkCookie.Check()
func SetProviderOffloadSinkChecked(c *xgb.Conn, Provider Provider, SinkProvider Provider, ConfigTimestamp xproto.Timestamp) SetProviderOffloadSinkCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetProviderOffloadSink' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setProviderOffloadSinkRequest(c, Provider, SinkProvider, ConfigTimestamp), cookie)
	return SetProviderOffloadSinkCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetProviderOffloadSinkCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetProviderOffloadSink
// setProviderOffloadSinkRequest writes a SetProviderOffloadSink request to a byte slice.
func setProviderOffloadSinkRequest(c *xgb.Conn, Provider Provider, SinkProvider Provider, ConfigTimestamp xproto.Timestamp) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 34 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(SinkProvider))
	b += 4

	xgb.Put32(buf[b:], uint32(ConfigTimestamp))
	b += 4

	return buf
}

// SetProviderOutputSourceCookie is a cookie used only for SetProviderOutputSource requests.
type SetProviderOutputSourceCookie struct {
	*xgb.Cookie
}

// SetProviderOutputSource sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetProviderOutputSource(c *xgb.Conn, Provider Provider, SourceProvider Provider, ConfigTimestamp xproto.Timestamp) SetProviderOutputSourceCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetProviderOutputSource' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setProviderOutputSourceRequest(c, Provider, SourceProvider, ConfigTimestamp), cookie)
	return SetProviderOutputSourceCookie{cookie}
}

// SetProviderOutputSourceChecked sends a checked request.
// If an error occurs, it can be retrieved using SetProviderOutputSourceCookie.Check()
func SetProviderOutputSourceChecked(c *xgb.Conn, Provider Provider, SourceProvider Provider, ConfigTimestamp xproto.Timestamp) SetProviderOutputSourceCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetProviderOutputSource' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setProviderOutputSourceRequest(c, Provider, SourceProvider, ConfigTimestamp), cookie)
	return SetProviderOutputSourceCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetProviderOutputSourceCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetProviderOutputSource
// setProviderOutputSourceRequest writes a SetProviderOutputSource request to a byte slice.
func setProviderOutputSourceRequest(c *xgb.Conn, Provider Provider, SourceProvider Provider, ConfigTimestamp xproto.Timestamp) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 35 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Provider))
	b += 4

	xgb.Put32(buf[b:], uint32(SourceProvider))
	b += 4

	xgb.Put32(buf[b:], uint32(ConfigTimestamp))
	b += 4

	return buf
}

// SetScreenConfigCookie is a cookie used only for SetScreenConfig requests.
type SetScreenConfigCookie struct {
	*xgb.Cookie
}

// SetScreenConfig sends a checked request.
// If an error occurs, it will be returned with the reply by calling SetScreenConfigCookie.Reply()
func SetScreenConfig(c *xgb.Conn, Window xproto.Window, Timestamp xproto.Timestamp, ConfigTimestamp xproto.Timestamp, SizeID uint16, Rotation uint16, Rate uint16) SetScreenConfigCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetScreenConfig' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(setScreenConfigRequest(c, Window, Timestamp, ConfigTimestamp, SizeID, Rotation, Rate), cookie)
	return SetScreenConfigCookie{cookie}
}

// SetScreenConfigUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetScreenConfigUnchecked(c *xgb.Conn, Window xproto.Window, Timestamp xproto.Timestamp, ConfigTimestamp xproto.Timestamp, SizeID uint16, Rotation uint16, Rate uint16) SetScreenConfigCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetScreenConfig' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(setScreenConfigRequest(c, Window, Timestamp, ConfigTimestamp, SizeID, Rotation, Rate), cookie)
	return SetScreenConfigCookie{cookie}
}

// SetScreenConfigReply represents the data returned from a SetScreenConfig request.
type SetScreenConfigReply struct {
	Sequence        uint16 // sequence number of the request for this reply
	Length          uint32 // number of bytes in this reply
	Status          byte
	NewTimestamp    xproto.Timestamp
	ConfigTimestamp xproto.Timestamp
	Root            xproto.Window
	SubpixelOrder   uint16
	// padding: 10 bytes
}

// Reply blocks and returns the reply data for a SetScreenConfig request.
func (cook SetScreenConfigCookie) Reply() (*SetScreenConfigReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return setScreenConfigReply(buf), nil
}

// setScreenConfigReply reads a byte slice into a SetScreenConfigReply value.
func setScreenConfigReply(buf []byte) *SetScreenConfigReply {
	v := new(SetScreenConfigReply)
	b := 1 // skip reply determinant

	v.Status = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NewTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.ConfigTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Root = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.SubpixelOrder = xgb.Get16(buf[b:])
	b += 2

	b += 10 // padding

	return v
}

// Write request to wire for SetScreenConfig
// setScreenConfigRequest writes a SetScreenConfig request to a byte slice.
func setScreenConfigRequest(c *xgb.Conn, Window xproto.Window, Timestamp xproto.Timestamp, ConfigTimestamp xproto.Timestamp, SizeID uint16, Rotation uint16, Rate uint16) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 2 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(ConfigTimestamp))
	b += 4

	xgb.Put16(buf[b:], SizeID)
	b += 2

	xgb.Put16(buf[b:], Rotation)
	b += 2

	xgb.Put16(buf[b:], Rate)
	b += 2

	b += 2 // padding

	return buf
}

// SetScreenSizeCookie is a cookie used only for SetScreenSize requests.
type SetScreenSizeCookie struct {
	*xgb.Cookie
}

// SetScreenSize sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetScreenSize(c *xgb.Conn, Window xproto.Window, Width uint16, Height uint16, MmWidth uint32, MmHeight uint32) SetScreenSizeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetScreenSize' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setScreenSizeRequest(c, Window, Width, Height, MmWidth, MmHeight), cookie)
	return SetScreenSizeCookie{cookie}
}

// SetScreenSizeChecked sends a checked request.
// If an error occurs, it can be retrieved using SetScreenSizeCookie.Check()
func SetScreenSizeChecked(c *xgb.Conn, Window xproto.Window, Width uint16, Height uint16, MmWidth uint32, MmHeight uint32) SetScreenSizeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RANDR"]; !ok {
		panic("Cannot issue request 'SetScreenSize' using the uninitialized extension 'RANDR'. randr.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setScreenSizeRequest(c, Window, Width, Height, MmWidth, MmHeight), cookie)
	return SetScreenSizeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetScreenSizeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetScreenSize
// setScreenSizeRequest writes a SetScreenSize request to a byte slice.
func setScreenSizeRequest(c *xgb.Conn, Window xproto.Window, Width uint16, Height uint16, MmWidth uint32, MmHeight uint32) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RANDR"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 7 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put16(buf[b:], Width)
	b += 2

	xgb.Put16(buf[b:], Height)
	b += 2

	xgb.Put32(buf[b:], MmWidth)
	b += 4

	xgb.Put32(buf[b:], MmHeight)
	b += 4

	return buf
}
