
# strtok

Parse a string into a sequence of tokens using a specified delimiter.

```
string strtok(const char **string*, const char **delimiter*)
```

The `strtok` function parses a string into a sequence of tokens by using a specified delimiter as the delimiting string . When you initially call `strtok`, specify the string to be parsed. In each following call to obtain the next token, specify the string as NULL. You can specify a different delimiter for each call. The internal pointer that `strtok` uses to traverse the string is only valid within more than one enabling of the same probe. The `strtok` function returns NULL if no more tokens are found.

## How to use strtok to break a comma delimited string into tokens.

In this example, `strtok` is used to break a comma delimited string into tokens. Because DTrace doesn't include flow-control structures similar to while loops, you must use predicates to emulate this functionality to step through each token. The example, shows how to walk through the first two tokens generated by the string. Each predicate gets the next token and checks that it's not a NULL value, which would represent the end of the string.

```
BEGIN
 {
     this->str = "Carrots,Barley,Oatmeal,Corn,Beans";
 }
 
 BEGIN
 /(this->field = strtok(this->str, ",")) == NULL/
 {
         exit(1);
 }
 
 BEGIN
 {
         printf("First token: %s\n", this->field);
 }
 
 BEGIN
 /(this->field = strtok(NULL, ",")) == NULL/
 {
         exit(2);
 }
 
 BEGIN
 {
         printf("Second token: %s\n", this->field);
         exit(0)
 }
```

**Parent topic:**[DTrace Function Reference](../reference/dtrace_functions.md)

