/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.mfirstuc;

import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MfirstucSty;
import java.io.IOException;

public class CapitaliseWords
extends Command {
    protected byte expansion = 0;
    protected MfirstucSty sty;

    public CapitaliseWords(MfirstucSty mfirstucSty) {
        this(mfirstucSty, "capitalisewords", 0);
    }

    public CapitaliseWords(MfirstucSty mfirstucSty, String string) {
        this(mfirstucSty, string, 0);
    }

    public CapitaliseWords(MfirstucSty mfirstucSty, String string, byte by) {
        super(string);
        if (by != 0 && by != 1 && by != 2) {
            throw new IllegalArgumentException("Invalid expansion value " + by);
        }
        this.expansion = by;
        this.sty = mfirstucSty;
    }

    @Override
    public Object clone() {
        return new CapitaliseWords(this.sty, this.getName(), this.expansion);
    }

    public boolean isWordBreakCs(TeXObject teXObject) {
        return teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals("MFUwordbreak");
    }

    public boolean isWordBoundary(TeXParser teXParser, TeXObject teXObject) {
        return teXObject instanceof Space || this.isWordBreakCs(teXObject);
    }

    public boolean isPunctuation(TeXObject teXObject) {
        return teXObject instanceof CharObject && !Character.isAlphabetic(((CharObject)teXObject).getCharCode());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        if (this.expansion == 1) {
            teXObject = TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList);
        } else if (this.expansion == 2) {
            teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
        }
        ControlSequence controlSequence = TeXParserUtils.isTrue("ifMFUhyphen", teXParser) ? teXParser.getListener().getControlSequence("MFUhyphencapword") : teXParser.getListener().getControlSequence("MFUcapword");
        TeXObjectList teXObjectList2 = new TeXObjectList();
        boolean bl = true;
        boolean bl2 = false;
        if (teXObject instanceof MathGroup) {
            teXObjectList2.add(teXObject);
            return teXObjectList2;
        } else if (teXObject instanceof Group) {
            teXObjectList2.add(controlSequence);
            teXObjectList2.add(teXObject);
            return teXObjectList2;
        } else if (teXParser.isStack(teXObject) && !teXObject.isEmpty()) {
            TeXObject teXObject2;
            TeXObjectList teXObjectList3 = (TeXObjectList)teXObject;
            TeXParserListener teXParserListener = teXParser.getListener();
            do {
                teXObject2 = teXObjectList3.peekStack();
                while (teXObject2 != null && (this.isPunctuation(teXObject2) || this.isWordBoundary(teXParser, teXObject2))) {
                    teXObject2 = teXObjectList3.popStack(teXParser);
                    if (!bl2) {
                        bl2 = teXObject2 instanceof Space;
                    }
                    if (this.isWordBreakCs(teXObject2)) {
                        teXObject2 = teXObjectList3.popArg(teXParser);
                    }
                    teXObjectList2.add(teXObject2);
                    teXObject2 = teXObjectList3.peekStack();
                }
                if (teXObject2 == null) return teXObjectList2;
                TeXObjectList teXObjectList4 = new TeXObjectList();
                while (teXObject2 != null && !this.isWordBoundary(teXParser, teXObject2)) {
                    teXObject2 = teXObjectList3.popStack(teXParser);
                    teXObjectList4.add(teXObject2);
                    teXObject2 = teXObjectList3.peekStack();
                }
                if (!bl2) {
                    bl2 = teXObject2 instanceof Space;
                }
                if (!bl && this.sty.isException(teXObjectList4)) {
                    teXObjectList2.addAll(teXObjectList4);
                } else {
                    teXObjectList2.add(controlSequence);
                    Group group = teXParserListener.createGroup();
                    group.addAll(teXObjectList4);
                    teXObjectList2.add(group);
                }
                if (!bl2) continue;
                bl = false;
            } while (teXObject2 != null);
            return teXObjectList2;
        } else if (teXObject instanceof CaseChangeable) {
            teXObjectList2.add(((CaseChangeable)((Object)teXObject)).toUpperCase(teXParser));
            return teXObjectList2;
        } else {
            teXObjectList2.add(teXObject);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.expandonce(teXParser, teXObjectList).process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.expandonce(teXParser).process(teXParser);
    }
}

