/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CEMAIL_H
#define CEMAIL_H

#include <netdb.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>

#ifdef __FreeBSD__
#include <arpa/inet.h>
#include <netinet/in.h>
#endif/*__FreeBSD__*/

#include <errno.h>
#include "AMMimeUtils.h"
#include <unistd.h>
#include <sys/select.h>
#include <sys/ioctl.h>

/* error codes */
#define ERROR_EM_INVALID_SMTPSERVER		(-10)
#define ERROR_EM_SERVER_TIMEOUT			(-11)
#define ERROR_EM_SERVER_DISCONNECTED	(-12)

/* type definitions */
typedef int SOCKET;
typedef unsigned char BYTE;
typedef unsigned char* LPBYTE;


/**
@author Tomasz Fiszer
*/
class CEmail
{
protected:
	/* variable declarations */
	SOCKET	sEmail;
	int		iLastError;
	char		szRecipientAddress[256];
	char		szSenderAddress[256];
	char		szSenderName[256];
	char		szSMTPServer[256];
	char		szUser[256];
	char		szPassword[256];
	char		szErrorString[256];
	
	/* helper functions */
	int	OpenConnection();
	int	CloseConnection();
	/* communication functions */
	int	SendString(char *lpszString);
	int	SendData(LPBYTE lpData, int iSizeData);
	int	ReceiveString(char *lpszBuffer, int iSizeBuff, int iTimeout);
	int	ReceiveData(LPBYTE lpbBuffer, int iSizeBuff, int iTimeout);

public:
	/* class constructor / destructor */
	CEmail();
	~CEmail();
	/* engine init */
	int		Init(char *lpszSMTPServer, char *lpszSender, char *lpszUser, char *lpszPassword);
	/* set authorization data - name and password */	
	int		SetAuthorization(char *lpszUser, char *lpszPassword);
	/* set SMTP (-authorization) server */
	int		SetSMTPServer(char *lpszSMTPServer);
	/* set sender name and address */
	int		SetSender(char *lpszSenderAddress, char *lpszSenderName);
	/* set mail recipient address */
	int		SetRecipient(char *lpszRecipientAddress);
	/* send message to recipient address set-up before */
	int		SendMessage(char *lpszTitle, char *lpszMessage, int iMsgLen);
	/* send message to specified recipient address */
	int		SendMessageTo(char *lpszRecipientAddress, char *lpszTitle, char *lpszMessage, int iMsgLen);

	/* last error code */
	int		GetLastErrorValue();
	int		GetLastErrorString(char *lpszBuffer, int iSize);
};

#endif/*CEMAIL_H*/
