%define name	xsnap
%define version	1.5.2
%define release 1mdk

%define main_summary Program to interactively take a snapshot of a region of the screen

Name:		%{name}
Version:	%{version}
Release:	%{release}
Summary:	%{main_summary}
Group:		Graphics
License:	BSD
Url:		ftp://ftp.ac-grenoble.fr/ge/Xutils/
Source:		%{name}-%{version}.tar.bz2

Buildroot:	%{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires:  X11-devel
BuildRequires:  jpeg-devel
BuildRequires:  png-devel
BuildRequires:	X11

%description
xsnap is a program that allows one to interactively take a snapshot of a
region of the screen.  This snapshot is then saved to a window. Press "p" 
to create a pixmap of this snapshot.

%prep
%setup -q -n %{name}-%{version}

%build
xmkmf -a
%make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
make DESTDIR=$RPM_BUILD_ROOT install.man

mkdir -p $RPM_BUILD_ROOT%{_menudir}
cat > $RPM_BUILD_ROOT%{_menudir}/%{name} << EOF
?package(%name): needs="x11" \
	section="Multimedia/Graphics" \
	title="Xsnap" \
	longtitle="%{main_summary}" \
	command="/usr/X11R6/bin/%{name}" \
	icon="graphics_section.png"
EOF

 
%post
%update_menus

%postun
%clean_menus

%clean
rm -fr $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc README INSTALL AUTHORS
/usr/X11R6/bin/*
/usr/X11R6/man/man1/*
/usr/X11R6/lib/X11/doc/html/*
%_menudir/*


%changelog
* Wed Nov 08 2006 JP Demailly <demailly@fourier.ujf-grenoble.fr> 1.5.1-1mdk
- new upstream version

* Mon Apr 18 2005 Franck Villaume <fvill@mandriva.org> 1.4.3-4mdk
- more buildRequires

* Sun Mar 20 2005 Franck Villaume <fvill@mandrake.org> 1.4.3-3mdk
- fix BuildRequires

* Sat Dec 04 2004 Franck Villaume <fvill@freesurf.fr> 1.4.3-2mdk
- add BuildRequires
- missing file

* Tue Oct 19 2004 Lenny Cartier <lenny@mandrakesoft.com> 1.4.3-1mdk
- 1.4.3

* Tue Sep 21 2004 Lenny Cartier <lenny@mandrakesoft.com> 1.4.2-1mdk
- 1.4.2

* Tue Sep 20 2004 Lenny Cartier <lenny@mandrakesoft.com> 1.4-2mdk
- update to rev1

* Wed Sep 15 2004 Lenny Cartier <lenny@mandrakesoft.com> 1.4-1mdk
- 1.4

* Fri Apr 09 2004 Lenny Cartier <lenny@mandrakesoft.com> 1.3-3mdk
- fixed buildrequires

* Fri Apr 09 2004 Lenny Cartier <lenny@mandrakesoft.com> 1.3-2mdk 
- from Pierre-Michel Theveny <pmth@free.fr> :
	- Correction in description

* Sat Mar 27 2004  Pierre-Michel Theveny <pmth@free.fr> 1.3-1mdk
- First build on 9.2
