/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mslinks.Serializable;

public class HotKeyFlags
implements Serializable {
    private static HashMap<Byte, String> keys = new HashMap(Map.ofEntries(Map.entry((byte)48, "0"), Map.entry((byte)49, "1"), Map.entry((byte)50, "2"), Map.entry((byte)51, "3"), Map.entry((byte)52, "4"), Map.entry((byte)53, "5"), Map.entry((byte)54, "6"), Map.entry((byte)55, "7"), Map.entry((byte)56, "8"), Map.entry((byte)57, "9"), Map.entry((byte)65, "A"), Map.entry((byte)66, "B"), Map.entry((byte)67, "C"), Map.entry((byte)68, "D"), Map.entry((byte)69, "E"), Map.entry((byte)70, "F"), Map.entry((byte)71, "G"), Map.entry((byte)72, "H"), Map.entry((byte)73, "I"), Map.entry((byte)74, "J"), Map.entry((byte)75, "K"), Map.entry((byte)76, "L"), Map.entry((byte)77, "M"), Map.entry((byte)78, "N"), Map.entry((byte)79, "O"), Map.entry((byte)80, "P"), Map.entry((byte)81, "Q"), Map.entry((byte)82, "R"), Map.entry((byte)83, "S"), Map.entry((byte)84, "T"), Map.entry((byte)85, "U"), Map.entry((byte)86, "V"), Map.entry((byte)87, "W"), Map.entry((byte)88, "X"), Map.entry((byte)89, "Y"), Map.entry((byte)90, "Z"), Map.entry((byte)112, "F1"), Map.entry((byte)113, "F2"), Map.entry((byte)114, "F3"), Map.entry((byte)115, "F4"), Map.entry((byte)116, "F5"), Map.entry((byte)117, "F6"), Map.entry((byte)118, "F7"), Map.entry((byte)119, "F8"), Map.entry((byte)120, "F9"), Map.entry((byte)121, "F10"), Map.entry((byte)122, "F11"), Map.entry((byte)123, "F12"), Map.entry((byte)124, "F13"), Map.entry((byte)125, "F14"), Map.entry((byte)126, "F15"), Map.entry((byte)127, "F16"), Map.entry((byte)-128, "F17"), Map.entry((byte)-127, "F18"), Map.entry((byte)-126, "F19"), Map.entry((byte)-125, "F20"), Map.entry((byte)-124, "F21"), Map.entry((byte)-123, "F22"), Map.entry((byte)-122, "F23"), Map.entry((byte)-121, "F24"), Map.entry((byte)-112, "NUM LOCK"), Map.entry((byte)-111, "SCROLL LOCK"), Map.entry((byte)1, "SHIFT"), Map.entry((byte)2, "CTRL"), Map.entry((byte)4, "ALT")));
    private static HashMap<String, Byte> keysr = new HashMap();
    private byte low;
    private byte high;

    public HotKeyFlags() {
        this.high = 0;
        this.low = 0;
    }

    public HotKeyFlags(ByteReader data) throws IOException {
        this.low = (byte)data.read();
        this.high = (byte)data.read();
    }

    public String getKey() {
        return keys.get(this.low);
    }

    public HotKeyFlags setKey(String k) {
        if (k != null && !k.equals("")) {
            this.low = keysr.get(k);
        }
        return this;
    }

    public boolean isShift() {
        return (this.high & 1) != 0;
    }

    public boolean isCtrl() {
        return (this.high & 2) != 0;
    }

    public boolean isAlt() {
        return (this.high & 4) != 0;
    }

    public HotKeyFlags setShift() {
        this.high = (byte)(1 | this.high & 6);
        return this;
    }

    public HotKeyFlags setCtrl() {
        this.high = (byte)(2 | this.high & 5);
        return this;
    }

    public HotKeyFlags setAlt() {
        this.high = (byte)(4 | this.high & 3);
        return this;
    }

    public HotKeyFlags clearShift() {
        this.high = (byte)(this.high & 6);
        return this;
    }

    public HotKeyFlags clearCtrl() {
        this.high = (byte)(this.high & 5);
        return this;
    }

    public HotKeyFlags clearAlt() {
        this.high = (byte)(this.high & 3);
        return this;
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write(this.low);
        bw.write(this.high);
    }

    static {
        for (Map.Entry<Byte, String> i : keys.entrySet()) {
            keysr.put(i.getValue(), i.getKey());
        }
    }
}

