/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AccessSpecifier;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedArrayType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedPrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedTypeVariable;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedVoidType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedWildcard;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionAnnotationDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionEnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;

public class ReflectionFactory {
    private static String JAVA_LANG_OBJECT = Object.class.getCanonicalName();

    public static ResolvedReferenceTypeDeclaration typeDeclarationFor(Class<?> clazz, TypeSolver typeSolver) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("No type declaration available for an Array");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (clazz.isAnnotation()) {
            return new ReflectionAnnotationDeclaration(clazz, typeSolver);
        }
        if (clazz.isInterface()) {
            return new ReflectionInterfaceDeclaration(clazz, typeSolver);
        }
        if (clazz.isEnum()) {
            return new ReflectionEnumDeclaration(clazz, typeSolver);
        }
        return new ReflectionClassDeclaration(clazz, typeSolver);
    }

    public static ResolvedType typeUsageFor(Type type, TypeSolver typeSolver) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            boolean declaredOnClass = tv.getGenericDeclaration() instanceof Type;
            ReflectionTypeParameter typeParameter = new ReflectionTypeParameter(tv, declaredOnClass, typeSolver);
            return new ResolvedTypeVariable(typeParameter);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            ResolvedReferenceType rawType = ReflectionFactory.typeUsageFor(pt.getRawType(), typeSolver).asReferenceType();
            ArrayList<Type> actualTypes = new ArrayList<Type>();
            actualTypes.addAll(Arrays.asList(pt.getActualTypeArguments()));
            rawType = rawType.transformTypeParameters(tp -> ReflectionFactory.typeUsageFor((Type)actualTypes.remove(0), typeSolver)).asReferenceType();
            return rawType;
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isPrimitive()) {
                if (c.getName().equals(Void.TYPE.getName())) {
                    return ResolvedVoidType.INSTANCE;
                }
                return ResolvedPrimitiveType.byName(c.getName());
            }
            if (c.isArray()) {
                return new ResolvedArrayType(ReflectionFactory.typeUsageFor(c.getComponentType(), typeSolver));
            }
            return new ReferenceTypeImpl(ReflectionFactory.typeDeclarationFor(c, typeSolver));
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new ResolvedArrayType(ReflectionFactory.typeUsageFor(genericArrayType.getGenericComponentType(), typeSolver));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length <= 0 || wildcardType.getUpperBounds().length <= 0 || wildcardType.getUpperBounds().length != 1 || wildcardType.getUpperBounds()[0].getTypeName().equals(JAVA_LANG_OBJECT)) {
                // empty if block
            }
            if (wildcardType.getLowerBounds().length > 0) {
                if (wildcardType.getLowerBounds().length > 1) {
                    throw new UnsupportedOperationException();
                }
                return ResolvedWildcard.superBound(ReflectionFactory.typeUsageFor(wildcardType.getLowerBounds()[0], typeSolver));
            }
            if (wildcardType.getUpperBounds().length > 0) {
                if (wildcardType.getUpperBounds().length > 1) {
                    throw new UnsupportedOperationException();
                }
                if (wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0].getTypeName().equals(JAVA_LANG_OBJECT)) {
                    return ResolvedWildcard.UNBOUNDED;
                }
                return ResolvedWildcard.extendsBound(ReflectionFactory.typeUsageFor(wildcardType.getUpperBounds()[0], typeSolver));
            }
            return ResolvedWildcard.UNBOUNDED;
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName() + " " + type);
    }

    static AccessSpecifier modifiersToAccessLevel(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return AccessSpecifier.PUBLIC;
        }
        if (Modifier.isProtected(modifiers)) {
            return AccessSpecifier.PROTECTED;
        }
        if (Modifier.isPrivate(modifiers)) {
            return AccessSpecifier.PRIVATE;
        }
        return AccessSpecifier.NONE;
    }
}

