/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.body;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.TokenRange;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AllFieldsConstructor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.BodyDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.CompactConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.Parameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ReceiverParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.TypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.SimpleName;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithImplements;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithParameters;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.modifiers.NodeWithFinalModifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.observer.ObservableProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.LocalRecordDeclarationStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.ClassOrInterfaceType;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.TypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.CloneVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.GenericVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.VoidVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.JavaParserMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.OptionalProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.RecordDeclarationMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Resolvable;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Utils;

public class RecordDeclaration
extends TypeDeclaration<RecordDeclaration>
implements NodeWithParameters<RecordDeclaration>,
NodeWithImplements<RecordDeclaration>,
NodeWithTypeParameters<RecordDeclaration>,
NodeWithFinalModifier<RecordDeclaration>,
Resolvable<ResolvedReferenceTypeDeclaration> {
    private NodeList<TypeParameter> typeParameters;
    private NodeList<ClassOrInterfaceType> implementedTypes;
    @OptionalProperty
    private ReceiverParameter receiverParameter;
    private NodeList<Parameter> parameters;

    public RecordDeclaration() {
        this(null, new NodeList<Modifier>(), new NodeList<AnnotationExpr>(), new SimpleName(), new NodeList<Parameter>(), new NodeList<TypeParameter>(), new NodeList<ClassOrInterfaceType>(), new NodeList(), null);
    }

    public RecordDeclaration(NodeList<Modifier> modifiers, String name) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), new SimpleName(name), new NodeList<Parameter>(), new NodeList<TypeParameter>(), new NodeList<ClassOrInterfaceType>(), new NodeList(), null);
    }

    @AllFieldsConstructor
    public RecordDeclaration(NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<Parameter> parameters, NodeList<TypeParameter> typeParameters, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<BodyDeclaration<?>> members, ReceiverParameter receiverParameter) {
        this(null, modifiers, annotations, name, parameters, typeParameters, implementedTypes, members, receiverParameter);
    }

    public RecordDeclaration(TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<Parameter> parameters, NodeList<TypeParameter> typeParameters, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<BodyDeclaration<?>> members, ReceiverParameter receiverParameter) {
        super(tokenRange, modifiers, annotations, name, members);
        this.setParameters((NodeList)parameters);
        this.setTypeParameters((NodeList)typeParameters);
        this.setImplementedTypes((NodeList)implementedTypes);
        this.setReceiverParameter(receiverParameter);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public NodeList<ClassOrInterfaceType> getImplementedTypes() {
        return this.implementedTypes;
    }

    @Override
    public NodeList<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public RecordDeclaration setImplementedTypes(NodeList<ClassOrInterfaceType> implementedTypes) {
        Utils.assertNotNull(implementedTypes);
        if (implementedTypes == this.implementedTypes) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.IMPLEMENTED_TYPES, this.implementedTypes, implementedTypes);
        if (this.implementedTypes != null) {
            this.implementedTypes.setParentNode(null);
        }
        this.implementedTypes = implementedTypes;
        this.setAsParentNodeOf(implementedTypes);
        return this;
    }

    @Override
    public RecordDeclaration setTypeParameters(NodeList<TypeParameter> typeParameters) {
        Utils.assertNotNull(typeParameters);
        if (typeParameters == this.typeParameters) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE_PARAMETERS, this.typeParameters, typeParameters);
        if (this.typeParameters != null) {
            this.typeParameters.setParentNode(null);
        }
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
        return this;
    }

    public boolean isLocalRecordDeclaration() {
        return this.getParentNode().map(p -> p instanceof LocalRecordDeclarationStmt).orElse(false);
    }

    @Override
    public Optional<String> getFullyQualifiedName() {
        if (this.isLocalRecordDeclaration()) {
            return Optional.empty();
        }
        return super.getFullyQualifiedName();
    }

    @Override
    public ResolvedReferenceTypeDeclaration resolve() {
        return this.getSymbolResolver().resolveDeclaration(this, ResolvedReferenceTypeDeclaration.class);
    }

    @Override
    public boolean isRecordDeclaration() {
        return true;
    }

    @Override
    public RecordDeclaration asRecordDeclaration() {
        return this;
    }

    @Override
    public Optional<RecordDeclaration> toRecordDeclaration() {
        return Optional.of(this);
    }

    @Override
    public void ifRecordDeclaration(Consumer<RecordDeclaration> action) {
        action.accept(this);
    }

    @Override
    public boolean remove(Node node) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.implementedTypes.size(); ++i) {
            if (this.implementedTypes.get(i) != node) continue;
            this.implementedTypes.remove(i);
            return true;
        }
        for (i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != node) continue;
            this.parameters.remove(i);
            return true;
        }
        if (this.receiverParameter != null && node == this.receiverParameter) {
            this.removeReceiverParameter();
            return true;
        }
        for (i = 0; i < this.typeParameters.size(); ++i) {
            if (this.typeParameters.get(i) != node) continue;
            this.typeParameters.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.implementedTypes.size(); ++i) {
            if (this.implementedTypes.get(i) != node) continue;
            this.implementedTypes.set(i, (ClassOrInterfaceType)replacementNode);
            return true;
        }
        for (i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != node) continue;
            this.parameters.set(i, (Parameter)replacementNode);
            return true;
        }
        if (this.receiverParameter != null && node == this.receiverParameter) {
            this.setReceiverParameter((ReceiverParameter)replacementNode);
            return true;
        }
        for (i = 0; i < this.typeParameters.size(); ++i) {
            if (this.typeParameters.get(i) != node) continue;
            this.typeParameters.set(i, (TypeParameter)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public RecordDeclaration clone() {
        return (RecordDeclaration)this.accept(new CloneVisitor(), null);
    }

    @Override
    public RecordDeclarationMetaModel getMetaModel() {
        return JavaParserMetaModel.recordDeclarationMetaModel;
    }

    @Override
    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public RecordDeclaration setParameters(NodeList<Parameter> parameters) {
        Utils.assertNotNull(parameters);
        if (parameters == this.parameters) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.PARAMETERS, this.parameters, parameters);
        if (this.parameters != null) {
            this.parameters.setParentNode(null);
        }
        this.parameters = parameters;
        this.setAsParentNodeOf(parameters);
        return this;
    }

    public Optional<ReceiverParameter> getReceiverParameter() {
        return Optional.ofNullable(this.receiverParameter);
    }

    public RecordDeclaration setReceiverParameter(ReceiverParameter receiverParameter) {
        if (receiverParameter == this.receiverParameter) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.RECEIVER_PARAMETER, this.receiverParameter, receiverParameter);
        if (this.receiverParameter != null) {
            this.receiverParameter.setParentNode(null);
        }
        this.receiverParameter = receiverParameter;
        this.setAsParentNodeOf(receiverParameter);
        return this;
    }

    public RecordDeclaration removeReceiverParameter() {
        return this.setReceiverParameter(null);
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isStatic() {
        Node parentNode;
        if (this.getParentNode().isPresent() && !((parentNode = this.getParentNode().get()) instanceof CompilationUnit)) {
            return true;
        }
        return super.isStatic();
    }

    public List<CompactConstructorDeclaration> getCompactConstructors() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m -> m instanceof CompactConstructorDeclaration).map(m -> (CompactConstructorDeclaration)m).collect(Collectors.toList()));
    }
}

