/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kong.unirest.core.Config;
import kong.unirest.core.DefaultInterceptor;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.HttpRequestSummary;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.Interceptor;
import kong.unirest.core.UnirestException;
import kong.unirest.core.Util;

class CompoundInterceptor
implements Interceptor {
    private List<Interceptor> interceptors;

    CompoundInterceptor() {
        this(Collections.singletonList(new DefaultInterceptor()));
    }

    CompoundInterceptor(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void onRequest(HttpRequest<?> request, Config config) {
        this.interceptors.forEach(i -> i.onRequest(request, config));
    }

    @Override
    public void onResponse(HttpResponse<?> response, HttpRequestSummary request, Config config) {
        this.interceptors.forEach(i -> i.onResponse(response, request, config));
    }

    @Override
    public HttpResponse<?> onFail(Exception e, HttpRequestSummary request, Config config) throws UnirestException {
        return (HttpResponse)this.interceptors.stream().map(i -> Optional.ofNullable(i.onFail(e, request, config))).flatMap(Util::stream).findFirst().orElseThrow(() -> new UnirestException(e));
    }

    int size() {
        return this.interceptors.size();
    }

    List<Interceptor> getInterceptors() {
        return new ArrayList<Interceptor>(this.interceptors);
    }

    void register(Interceptor t1) {
        if (this.interceptors.stream().anyMatch(i -> i instanceof DefaultInterceptor)) {
            this.interceptors = new ArrayList<Interceptor>();
        }
        if (!this.interceptors.contains(t1)) {
            this.interceptors.add(t1);
        }
    }
}

