/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview;

import com.dlsc.gemsfx.treeview.TreeNode;
import com.dlsc.gemsfx.treeview.TreeNodeCell;
import com.dlsc.gemsfx.treeview.TreeNodeView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;

public class TreeNodeViewSkin<T>
extends SkinBase<TreeNodeView<T>> {
    private final Map<TreeNode<T>, InvalidationListener> expandListenerMap = new HashMap<TreeNode<T>, InvalidationListener>();
    private final Map<TreeNode<T>, InvalidationListener> invailidateListenerMap = new HashMap<TreeNode<T>, InvalidationListener>();
    private final Map<TreeNode<T>, ListChangeListener<TreeNode<T>>> childrenListListenerMap = new HashMap<TreeNode<T>, ListChangeListener<TreeNode<T>>>();
    private final Map<TreeNode<T>, List<Node>> nodeToComponentsMap = new HashMap<TreeNode<T>, List<Node>>();
    private final Map<TreeNode<T>, Point2D> nodeToPositionMap = new HashMap<TreeNode<T>, Point2D>();
    private final Map<TreeNode<T>, Double> nodeTotalDimensionMap = new HashMap<TreeNode<T>, Double>();
    private final Map<Integer, Double> levelToMaxDimensionMap = new HashMap<Integer, Double>();
    private final List<TreeNode<T>> currentLevelNodesCache = new ArrayList<TreeNode<T>>();
    private final Group contentGroup = new Group();

    public TreeNodeViewSkin(TreeNodeView<T> view) {
        super(view);
        this.contentGroup.getStyleClass().add((Object)"tree-content");
        this.getChildren().add((Object)this.contentGroup);
        this.initTree();
        view.rootProperty().addListener((ob, ov, newRoot) -> this.initTree());
        ChangeListener buildTreeListener = (ob, ov, nv) -> this.buildTree();
        view.layoutTypeProperty().addListener(buildTreeListener);
        view.cellFactoryProperty().addListener(buildTreeListener);
        view.cellWidthProperty().addListener(buildTreeListener);
        view.cellHeightProperty().addListener(buildTreeListener);
        view.vgapProperty().addListener(buildTreeListener);
        view.hgapProperty().addListener(buildTreeListener);
        view.nodeLineGapProperty().addListener(buildTreeListener);
        view.rowAlignmentProperty().addListener(buildTreeListener);
        view.columnAlignmentProperty().addListener(buildTreeListener);
        view.linkStrategyProperty().addListener(buildTreeListener);
        view.layoutDirectionProperty().addListener(buildTreeListener);
        view.placeholderProperty().addListener((ob, ov, nv) -> {
            if (view.getRoot() == null) {
                this.contentGroup.getChildren().setAll((Object[])new Node[]{nv});
            }
        });
    }

    private void initTree() {
        this.buildTree();
        this.initNodeListeners();
    }

    private void addListenersToNode(TreeNode<T> node) {
        InvalidationListener expandListener = this.createExpandListener(node);
        this.expandListenerMap.put(node, expandListener);
        node.expandedProperty().addListener(expandListener);
        InvalidationListener invalidationListener = it -> this.buildTree();
        this.invailidateListenerMap.put(node, invalidationListener);
        node.getChildren().addListener(invalidationListener);
        node.widthProperty().addListener(invalidationListener);
        node.heightProperty().addListener(invalidationListener);
        node.getLinkedNodes().addListener(invalidationListener);
        ListChangeListener<TreeNode<T>> nodeListChangeListener = this.createNodeListChangeListener();
        this.childrenListListenerMap.put(node, nodeListChangeListener);
        node.getChildren().addListener(nodeListChangeListener);
        node.getLinkedNodes().addListener(nodeListChangeListener);
    }

    private void removeListenersFromNode(TreeNode<T> removedNode) {
        ListChangeListener<TreeNode<T>> nodeListChangeListener;
        InvalidationListener invalidationListener;
        InvalidationListener expandListener = this.expandListenerMap.remove(removedNode);
        if (expandListener != null) {
            removedNode.expandedProperty().removeListener(expandListener);
        }
        if ((invalidationListener = this.invailidateListenerMap.remove(removedNode)) != null) {
            removedNode.getChildren().removeListener(invalidationListener);
            removedNode.widthProperty().removeListener(invalidationListener);
            removedNode.heightProperty().removeListener(invalidationListener);
            removedNode.getLinkedNodes().removeListener(invalidationListener);
        }
        if ((nodeListChangeListener = this.childrenListListenerMap.remove(removedNode)) != null) {
            removedNode.getChildren().removeListener(nodeListChangeListener);
            removedNode.getLinkedNodes().removeListener(nodeListChangeListener);
        }
        this.nodeToComponentsMap.remove(removedNode);
        this.nodeToPositionMap.remove(removedNode);
        this.nodeTotalDimensionMap.remove(removedNode);
    }

    private ListChangeListener<TreeNode<T>> createNodeListChangeListener() {
        return c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(this::addListenersToNode);
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(this::removeListenersFromNode);
            }
        };
    }

    private void initNodeListeners() {
        TreeNode rootNode = ((TreeNodeView)this.getSkinnable()).getRoot();
        if (rootNode == null) {
            return;
        }
        rootNode.stream().forEach(this::addListenersToNode);
    }

    private InvalidationListener createExpandListener(TreeNode<T> node) {
        return it -> {
            this.toggleChildrenVisibility(node, node.isExpanded(), true);
            if (node.isExpanded()) {
                this.drawNode(node);
            }
        };
    }

    private void buildTree() {
        TreeNode root = ((TreeNodeView)this.getSkinnable()).getRoot();
        this.contentGroup.getChildren().clear();
        this.clearMapsForBuild();
        if (root != null) {
            this.calculatePositions(root);
            this.drawNode(root);
            this.drawAdditionalLinkedNodes();
        } else {
            this.contentGroup.getChildren().setAll((Object[])new Node[]{((TreeNodeView)this.getSkinnable()).getPlaceholder()});
        }
    }

    private void calculatePositions(TreeNode<T> root) {
        if (((TreeNodeView)this.getSkinnable()).getLayoutType() == TreeNodeView.LayoutType.REGULAR) {
            this.positionNodesRegular(root);
        } else {
            this.positionNodesCompact(root);
        }
    }

    private void positionNodesCompact(TreeNode<T> root) {
        this.computeAndCacheNodeDimension(root);
        TreeNodeView.LayoutDirection layoutDirection = ((TreeNodeView)this.getSkinnable()).getLayoutDirection();
        if (layoutDirection == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT || layoutDirection == TreeNodeView.LayoutDirection.RIGHT_TO_LEFT) {
            this.positionNodesCompactHorizontally(root, this.findMaxColumnHeight(root), layoutDirection);
        } else {
            this.positionNodesCompactVertically(root, this.findMaxRowWidth(root), layoutDirection);
        }
    }

    private double findMaxRowWidth(TreeNode<T> root) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.offer(root);
        double maxRowWidth = 0.0;
        while (!queue.isEmpty()) {
            int size = queue.size();
            double currentRowWidth = 0.0;
            for (int i = 0; i < size; ++i) {
                TreeNode node = (TreeNode)queue.poll();
                if (node == null) continue;
                currentRowWidth += this.computeNodeWidth(node);
                if (!node.isExpanded()) continue;
                for (TreeNode child : node.getChildren()) {
                    queue.offer(child);
                }
            }
            maxRowWidth = Math.max(maxRowWidth, currentRowWidth += (double)(size - 1) * ((TreeNodeView)this.getSkinnable()).getHgap());
        }
        return maxRowWidth;
    }

    private double findMaxColumnHeight(TreeNode<T> root) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.offer(root);
        double maxColumnHeight = 0.0;
        while (!queue.isEmpty()) {
            int size = queue.size();
            double currentColumnHeight = 0.0;
            for (int i = 0; i < size; ++i) {
                TreeNode node = (TreeNode)queue.poll();
                if (node == null) continue;
                currentColumnHeight += this.computeNodeHeight(node);
                if (!node.isExpanded()) continue;
                for (TreeNode child : node.getChildren()) {
                    queue.offer(child);
                }
            }
            maxColumnHeight = Math.max(maxColumnHeight, currentColumnHeight += (double)(size - 1) * ((TreeNodeView)this.getSkinnable()).getVgap());
        }
        return maxColumnHeight;
    }

    private void drawNode(TreeNode<T> node) {
        Point2D point;
        TreeNodeView view = (TreeNodeView)this.getSkinnable();
        if (!this.nodeToPositionMap.containsKey(node)) {
            this.calculatePositions(view.getRoot());
        }
        if ((point = this.nodeToPositionMap.get(node)) == null) {
            return;
        }
        TreeNodeCell cell = (TreeNodeCell)((Object)view.getCellFactory().call(node.getValue()));
        cell.setTreeNode(node);
        cell.setPrefSize(this.computeNodeWidth(node), this.computeNodeHeight(node));
        cell.setLayoutX(point.getX());
        cell.setLayoutY(point.getY());
        this.contentGroup.getChildren().add((Object)cell);
        TreeNode parent = node.getParent();
        if (parent != null) {
            Point2D parentPoint = this.nodeToPositionMap.get(parent);
            if (parentPoint == null) {
                return;
            }
            ArrayList<Node> nodes = view.getLinkStrategy().drawNodeLink(((TreeNodeView)this.getSkinnable()).getLayoutDirection(), this.levelToMaxDimensionMap.get(node.getLevel()), parent, parentPoint, this.computeNodeWidth(parent), this.computeNodeHeight(parent), node, point, this.computeNodeWidth(node), this.computeNodeHeight(node), view.getNodeLineGap(), view.getVgap(), view.getHgap());
            if (parent.getName() != null && node.getName() != null) {
                nodes.forEach(n -> n.getStyleClass().add((Object)("link-" + parent.getName() + "-" + node.getName())));
            }
            this.contentGroup.getChildren().addAll(nodes);
            nodes.add((Node)cell);
            this.nodeToComponentsMap.put(node, nodes);
        } else {
            this.nodeToComponentsMap.put(node, List.of(cell));
        }
        for (TreeNode child : node.getChildren()) {
            if (!node.isExpanded()) continue;
            this.drawNode(child);
        }
    }

    private void positionNodesRegular(TreeNode<T> root) {
        this.nodeToPositionMap.clear();
        this.levelToMaxDimensionMap.clear();
        this.computeAndCacheNodeDimension(root);
        TreeNodeView.LayoutDirection layoutDirection = ((TreeNodeView)this.getSkinnable()).getLayoutDirection();
        if (layoutDirection == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT || layoutDirection == TreeNodeView.LayoutDirection.RIGHT_TO_LEFT) {
            this.positionNodesRegularHorizontally(root, 0.0, 0.0, layoutDirection);
        } else {
            this.positionNodesRegularVertically(root, 0.0, 0.0, layoutDirection);
        }
    }

    private void positionNodesCompactVertically(TreeNode<T> root, double maxRowWidth, TreeNodeView.LayoutDirection direction) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.offer(root);
        double currentPositionY = 0.0;
        double hgap = ((TreeNodeView)this.getSkinnable()).getHgap();
        double vgap = ((TreeNodeView)this.getSkinnable()).getVgap();
        double nodeLineGaps = ((TreeNodeView)this.getSkinnable()).getNodeLineGap() * 2.0;
        VPos alignment = ((TreeNodeView)this.getSkinnable()).getRowAlignment();
        while (!queue.isEmpty()) {
            int size = queue.size();
            double currentRowWidth = 0.0;
            double currentLevelMaxHeight = 0.0;
            this.currentLevelNodesCache.clear();
            for (int i = 0; i < size; ++i) {
                TreeNode node = (TreeNode)queue.poll();
                if (node == null) continue;
                currentRowWidth += this.computeNodeWidth(node);
                if (i < size - 1) {
                    currentRowWidth += hgap;
                }
                currentLevelMaxHeight = Math.max(currentLevelMaxHeight, this.computeNodeHeight(node));
                this.currentLevelNodesCache.add(node);
            }
            double currentLevelTotalHeight = currentLevelMaxHeight + vgap + nodeLineGaps;
            if (direction == TreeNodeView.LayoutDirection.BOTTOM_TO_TOP) {
                currentPositionY -= currentLevelTotalHeight;
            }
            double currentPositionX = (maxRowWidth - currentRowWidth) / 2.0;
            for (TreeNode<T> node : this.currentLevelNodesCache) {
                if (node == null) continue;
                double adjustedYPosition = this.computeCompactAdjustedYPosition(currentPositionY, currentLevelMaxHeight, this.computeNodeHeight(node), alignment, direction);
                this.nodeToPositionMap.put(node, new Point2D(currentPositionX, adjustedYPosition - (direction == TreeNodeView.LayoutDirection.TOP_TO_BOTTOM ? nodeLineGaps : 0.0)));
                currentPositionX += this.computeNodeWidth(node);
                if (node.equals(this.currentLevelNodesCache.get(this.currentLevelNodesCache.size() - 1))) continue;
                currentPositionX += hgap;
            }
            if (direction == TreeNodeView.LayoutDirection.TOP_TO_BOTTOM) {
                currentPositionY += currentLevelTotalHeight;
            }
            for (TreeNode<T> node : this.currentLevelNodesCache) {
                if (!node.isExpanded()) continue;
                for (TreeNode child : node.getChildren()) {
                    queue.offer(child);
                }
            }
        }
    }

    private void positionNodesCompactHorizontally(TreeNode<T> root, double maxColumnHeight, TreeNodeView.LayoutDirection direction) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.offer(root);
        double currentPositionX = 0.0;
        double hgap = ((TreeNodeView)this.getSkinnable()).getHgap();
        double vgap = ((TreeNodeView)this.getSkinnable()).getVgap();
        double nodeColumnGaps = ((TreeNodeView)this.getSkinnable()).getNodeLineGap() * 2.0;
        HPos alignment = ((TreeNodeView)this.getSkinnable()).getColumnAlignment();
        while (!queue.isEmpty()) {
            int size = queue.size();
            double currentColumnHeight = 0.0;
            double currentLevelMaxWidth = 0.0;
            this.currentLevelNodesCache.clear();
            for (int i = 0; i < size; ++i) {
                TreeNode node = (TreeNode)queue.poll();
                if (node == null) continue;
                currentColumnHeight += this.computeNodeHeight(node);
                if (i < size - 1) {
                    currentColumnHeight += vgap;
                }
                currentLevelMaxWidth = Math.max(currentLevelMaxWidth, this.computeNodeWidth(node));
                this.currentLevelNodesCache.add(node);
            }
            double currentLevelTotalWidth = currentLevelMaxWidth + hgap + nodeColumnGaps;
            if (direction == TreeNodeView.LayoutDirection.RIGHT_TO_LEFT) {
                currentPositionX -= currentLevelTotalWidth;
            }
            double currentPositionY = (maxColumnHeight - currentColumnHeight) / 2.0;
            for (TreeNode<T> node : this.currentLevelNodesCache) {
                if (node == null) continue;
                double adjustedXPosition = this.computeCompactAdjustedXPosition(currentPositionX, currentLevelMaxWidth, this.computeNodeWidth(node), alignment, direction);
                this.nodeToPositionMap.put(node, new Point2D(adjustedXPosition - (direction == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT ? nodeColumnGaps : 0.0), currentPositionY));
                currentPositionY += this.computeNodeHeight(node);
                if (node.equals(this.currentLevelNodesCache.get(this.currentLevelNodesCache.size() - 1))) continue;
                currentPositionY += vgap;
            }
            if (direction == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT) {
                currentPositionX += currentLevelTotalWidth;
            }
            for (TreeNode<T> node : this.currentLevelNodesCache) {
                if (!node.isExpanded()) continue;
                for (TreeNode child : node.getChildren()) {
                    queue.offer(child);
                }
            }
        }
    }

    private double computeAndCacheNodeDimension(TreeNode<T> node) {
        TreeNodeView.LayoutDirection direction = ((TreeNodeView)this.getSkinnable()).getLayoutDirection();
        if (direction == TreeNodeView.LayoutDirection.BOTTOM_TO_TOP || direction == TreeNodeView.LayoutDirection.TOP_TO_BOTTOM) {
            double nodeHeight = this.computeNodeHeight(node);
            int level = node.getLevel();
            this.levelToMaxDimensionMap.put(level, Math.max(nodeHeight, this.levelToMaxDimensionMap.getOrDefault(level, 0.0)));
            double nodeWidth = this.computeNodeWidth(node);
            if (!node.getChildren().isEmpty() && node.isExpanded()) {
                double childrenTotalWidth = node.getChildren().stream().mapToDouble(this::computeAndCacheNodeDimension).sum() + ((TreeNodeView)this.getSkinnable()).getHgap() * (double)(node.getChildren().size() - 1);
                nodeWidth = Math.max(nodeWidth, childrenTotalWidth);
            }
            this.nodeTotalDimensionMap.put(node, nodeWidth);
            return nodeWidth;
        }
        double nodeWidth = this.computeNodeWidth(node);
        int level = node.getLevel();
        this.levelToMaxDimensionMap.put(level, Math.max(nodeWidth, this.levelToMaxDimensionMap.getOrDefault(level, 0.0)));
        double nodeHeight = this.computeNodeHeight(node);
        if (!node.getChildren().isEmpty() && node.isExpanded()) {
            double childrenTotalHeight = node.getChildren().stream().mapToDouble(this::computeAndCacheNodeDimension).sum() + ((TreeNodeView)this.getSkinnable()).getVgap() * (double)(node.getChildren().size() - 1);
            nodeHeight = Math.max(nodeHeight, childrenTotalHeight);
        }
        this.nodeTotalDimensionMap.put(node, nodeHeight);
        return nodeHeight;
    }

    private void positionNodesRegularVertically(TreeNode<T> node, double x, double y, TreeNodeView.LayoutDirection layoutDirection) {
        double currentTotalWidth = this.nodeTotalDimensionMap.get(node);
        double currentRealWidth = this.computeNodeWidth(node);
        double startX = x + (currentTotalWidth - currentRealWidth) / 2.0;
        int level = node.getLevel();
        double maxLevelHeight = this.levelToMaxDimensionMap.get(level);
        VPos alignment = ((TreeNodeView)this.getSkinnable()).getRowAlignment();
        double adjustedY = this.computeRegularAdjustedYPosition(y, maxLevelHeight, this.computeNodeHeight(node), alignment, layoutDirection);
        this.nodeToPositionMap.put(node, new Point2D(startX, adjustedY));
        if (!node.isExpanded()) {
            return;
        }
        double childrenTotalWidth = 0.0;
        for (TreeNode child : node.getChildren()) {
            childrenTotalWidth += this.nodeTotalDimensionMap.get(child).doubleValue();
        }
        double childrenStartX = currentRealWidth > (childrenTotalWidth += ((TreeNodeView)this.getSkinnable()).getHgap() * (double)(node.getChildren().size() - 1)) ? startX + (currentRealWidth - childrenTotalWidth) / 2.0 : x;
        double nextY = layoutDirection == TreeNodeView.LayoutDirection.BOTTOM_TO_TOP ? y - maxLevelHeight - ((TreeNodeView)this.getSkinnable()).getVgap() - ((TreeNodeView)this.getSkinnable()).getNodeLineGap() * 2.0 : y + maxLevelHeight + ((TreeNodeView)this.getSkinnable()).getVgap() + ((TreeNodeView)this.getSkinnable()).getNodeLineGap() * 2.0;
        for (TreeNode child : node.getChildren()) {
            this.positionNodesRegularVertically(child, childrenStartX, nextY, layoutDirection);
            childrenStartX += this.nodeTotalDimensionMap.get(child) + ((TreeNodeView)this.getSkinnable()).getHgap();
        }
    }

    private void positionNodesRegularHorizontally(TreeNode<T> node, double x, double y, TreeNodeView.LayoutDirection layoutDirection) {
        double nextX;
        double currentTotalHeight = this.nodeTotalDimensionMap.get(node);
        double currentRealHeight = this.computeNodeHeight(node);
        double startY = y + (currentTotalHeight - currentRealHeight) / 2.0;
        int level = node.getLevel();
        Double maxLevelWidth = this.levelToMaxDimensionMap.get(level);
        HPos alignment = ((TreeNodeView)this.getSkinnable()).getColumnAlignment();
        double adjustedX = this.computeRegularAdjustedXPosition(x, maxLevelWidth, this.computeNodeWidth(node), alignment, layoutDirection);
        this.nodeToPositionMap.put(node, new Point2D(adjustedX, startY));
        if (!node.isExpanded()) {
            return;
        }
        double childrenTotalHeight = 0.0;
        for (TreeNode child : node.getChildren()) {
            childrenTotalHeight += this.nodeTotalDimensionMap.get(child).doubleValue();
        }
        double childrenStartY = startY + currentRealHeight / 2.0 - (childrenTotalHeight += ((TreeNodeView)this.getSkinnable()).getVgap() * (double)(node.getChildren().size() - 1)) / 2.0;
        double nodeLineGaps = ((TreeNodeView)this.getSkinnable()).getNodeLineGap() * 2.0;
        if (layoutDirection == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT) {
            if (alignment == HPos.LEFT) {
                nextX = adjustedX + maxLevelWidth + ((TreeNodeView)this.getSkinnable()).getHgap() + nodeLineGaps;
            } else if (alignment == HPos.CENTER) {
                offset = (maxLevelWidth - this.computeNodeWidth(node)) / 2.0;
                nextX = adjustedX + offset + this.computeNodeWidth(node) + ((TreeNodeView)this.getSkinnable()).getHgap() + nodeLineGaps;
            } else {
                nextX = adjustedX + this.computeNodeWidth(node) + ((TreeNodeView)this.getSkinnable()).getHgap() + nodeLineGaps;
            }
        } else if (alignment == HPos.LEFT) {
            nextX = adjustedX - ((TreeNodeView)this.getSkinnable()).getHgap() - nodeLineGaps;
        } else if (alignment == HPos.CENTER) {
            offset = (maxLevelWidth - this.computeNodeWidth(node)) / 2.0;
            nextX = adjustedX - offset - ((TreeNodeView)this.getSkinnable()).getHgap() - nodeLineGaps;
        } else {
            nextX = adjustedX - maxLevelWidth + this.computeNodeWidth(node) - ((TreeNodeView)this.getSkinnable()).getHgap() - nodeLineGaps;
        }
        for (TreeNode child : node.getChildren()) {
            this.positionNodesRegularHorizontally(child, nextX, childrenStartY, layoutDirection);
            childrenStartY += this.nodeTotalDimensionMap.get(child) + ((TreeNodeView)this.getSkinnable()).getVgap();
        }
    }

    private double computeRegularAdjustedXPosition(double x, double maxLevelWidth, double nodeWidth, HPos alignment, TreeNodeView.LayoutDirection direction) {
        if (direction == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT) {
            return switch (alignment) {
                default -> throw new IncompatibleClassChangeError();
                case HPos.LEFT -> x;
                case HPos.CENTER -> x + (maxLevelWidth - nodeWidth) / 2.0;
                case HPos.RIGHT -> x + maxLevelWidth - nodeWidth;
            };
        }
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case HPos.LEFT -> x - maxLevelWidth;
            case HPos.CENTER -> x - (maxLevelWidth + nodeWidth) / 2.0;
            case HPos.RIGHT -> x - nodeWidth;
        };
    }

    private double computeRegularAdjustedYPosition(double y, double maxLevelHeight, double nodeHeight, VPos alignment, TreeNodeView.LayoutDirection layoutDirection) {
        if (layoutDirection == TreeNodeView.LayoutDirection.TOP_TO_BOTTOM) {
            return switch (alignment) {
                default -> throw new IncompatibleClassChangeError();
                case VPos.TOP -> y;
                case VPos.CENTER -> y + (maxLevelHeight - nodeHeight) / 2.0;
                case VPos.BASELINE, VPos.BOTTOM -> y + maxLevelHeight - nodeHeight;
            };
        }
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case VPos.TOP -> y - maxLevelHeight;
            case VPos.CENTER -> y - (maxLevelHeight + nodeHeight) / 2.0;
            case VPos.BASELINE, VPos.BOTTOM -> y - nodeHeight;
        };
    }

    private double computeCompactAdjustedYPosition(double y, double maxLevelHeight, double nodeHeight, VPos alignment, TreeNodeView.LayoutDirection layoutDirection) {
        if (layoutDirection == TreeNodeView.LayoutDirection.TOP_TO_BOTTOM) {
            return switch (alignment) {
                default -> throw new IncompatibleClassChangeError();
                case VPos.TOP -> y;
                case VPos.CENTER -> y + (maxLevelHeight - nodeHeight) / 2.0;
                case VPos.BASELINE, VPos.BOTTOM -> y + maxLevelHeight - nodeHeight;
            };
        }
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case VPos.TOP -> y;
            case VPos.CENTER -> y + maxLevelHeight / 2.0 - nodeHeight / 2.0;
            case VPos.BASELINE, VPos.BOTTOM -> y + maxLevelHeight - nodeHeight;
        };
    }

    private double computeCompactAdjustedXPosition(double x, double maxLevelWidth, double nodeWidth, HPos alignment, TreeNodeView.LayoutDirection direction) {
        if (direction == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT) {
            return switch (alignment) {
                default -> throw new IncompatibleClassChangeError();
                case HPos.LEFT -> x;
                case HPos.CENTER -> x + (maxLevelWidth - nodeWidth) / 2.0;
                case HPos.RIGHT -> x + maxLevelWidth - nodeWidth;
            };
        }
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case HPos.LEFT -> x + maxLevelWidth - nodeWidth;
            case HPos.CENTER -> x + maxLevelWidth / 2.0 - nodeWidth / 2.0;
            case HPos.RIGHT -> x;
        };
    }

    private void toggleChildrenVisibility(TreeNode<T> node, boolean isVisible, boolean updateTreeAfterToggle) {
        for (TreeNode child : node.getChildren()) {
            List<Node> components;
            if (!this.nodeToComponentsMap.containsKey(child)) {
                this.drawNode(child);
            }
            if ((components = this.nodeToComponentsMap.get(child)) != null) {
                for (Node component : components) {
                    component.setVisible(isVisible);
                    component.setManaged(isVisible);
                }
            }
            if (!child.isExpanded()) continue;
            this.toggleChildrenVisibility(child, isVisible && child.isExpanded(), false);
        }
        if (updateTreeAfterToggle) {
            this.updateTree();
        }
    }

    private void updateTree() {
        this.contentGroup.getChildren().clear();
        this.clearMapsForUpdate();
        TreeNode root = ((TreeNodeView)this.getSkinnable()).getRoot();
        if (root != null) {
            this.calculatePositions(root);
            this.drawNode(root);
            this.drawAdditionalLinkedNodes();
        }
    }

    private void drawAdditionalLinkedNodes() {
        TreeNode root = ((TreeNodeView)this.getSkinnable()).getRoot();
        if (root != null) {
            root.stream().forEach(this::drawLinksForNode);
        }
    }

    private void drawLinksForNode(TreeNode<T> node) {
        Point2D sourcePosition = this.nodeToPositionMap.get(node);
        for (TreeNode linkedNode : node.getLinkedNodes()) {
            Point2D targetPosition = this.nodeToPositionMap.get(linkedNode);
            if (sourcePosition == null || targetPosition == null) continue;
            ArrayList<Node> nodes = ((TreeNodeView)this.getSkinnable()).getLinkStrategy().drawNodeLink(((TreeNodeView)this.getSkinnable()).getLayoutDirection(), this.levelToMaxDimensionMap.get(node.getLevel()), node, sourcePosition, this.computeNodeWidth(node), this.computeNodeHeight(node), linkedNode, targetPosition, this.computeNodeWidth(linkedNode), this.computeNodeHeight(linkedNode), ((TreeNodeView)this.getSkinnable()).getNodeLineGap(), ((TreeNodeView)this.getSkinnable()).getVgap(), ((TreeNodeView)this.getSkinnable()).getHgap());
            if (node.getName() != null && linkedNode.getName() != null) {
                nodes.forEach(n -> n.getStyleClass().add((Object)("link-extra-" + node.getName() + "-" + linkedNode.getName())));
            }
            this.contentGroup.getChildren().addAll(nodes);
        }
    }

    private void clearMapsForUpdate() {
        this.nodeToComponentsMap.clear();
        this.nodeToPositionMap.clear();
        this.nodeTotalDimensionMap.clear();
        this.levelToMaxDimensionMap.clear();
        this.currentLevelNodesCache.clear();
    }

    private void clearMapsForBuild() {
        this.clearMapsForUpdate();
        this.expandListenerMap.clear();
        this.invailidateListenerMap.clear();
        this.childrenListListenerMap.clear();
    }

    public double computeNodeWidth(TreeNode<T> node) {
        return node.getWidth() == Double.NEGATIVE_INFINITY ? ((TreeNodeView)this.getSkinnable()).getCellWidth() : node.getWidth();
    }

    public double computeNodeHeight(TreeNode<T> node) {
        return node.getHeight() == Double.NEGATIVE_INFINITY ? ((TreeNodeView)this.getSkinnable()).getCellHeight() : node.getHeight();
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.contentGroup.prefWidth(height) + leftInset + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.contentGroup.prefHeight(width) + leftInset + rightInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    public void refresh() {
        this.buildTree();
    }
}

