/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.ChipView;
import com.dlsc.gemsfx.FilterView;
import com.dlsc.gemsfx.SearchTextField;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;

public class FilterViewSkin<T>
extends SkinBase<FilterView<T>> {
    private final SearchTextField searchTextField;
    private final HBox filterGroupsPane = new HBox();
    private final FlowPane filtersPane = new FlowPane();
    private final HBox headerBox = new HBox();
    private final ScrollPane scrollPane = new ScrollPane();
    private final VBox container;
    private final Map<FilterView.Filter, CheckMenuItem> filterItemMap = new HashMap<FilterView.Filter, CheckMenuItem>();

    public FilterViewSkin(FilterView<T> view) {
        super(view);
        this.searchTextField = view.getSearchTextField();
        InvalidationListener updateHeaderListener = it -> this.updateHeaderBox();
        view.titleLabelProperty().addListener(updateHeaderListener);
        view.titlePostfixLabelProperty().addListener(updateHeaderListener);
        view.subtitleLabelProperty().addListener(updateHeaderListener);
        view.extrasProperty().addListener((obs, oldExtras, newExtras) -> {
            if (oldExtras != null) {
                this.headerBox.getChildren().remove(oldExtras);
            }
            if (newExtras != null) {
                this.headerBox.getChildren().add(newExtras);
            }
        });
        this.filterGroupsPane.getStyleClass().add((Object)"filter-groups");
        this.filterGroupsPane.setFillHeight(true);
        this.filterGroupsPane.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty(view.getFilterGroups()));
        this.filterGroupsPane.managedProperty().bind((ObservableValue)Bindings.isNotEmpty(view.getFilterGroups()));
        this.filtersPane.getStyleClass().add((Object)"filters");
        this.filtersPane.prefWrapLengthProperty().bind((ObservableValue)view.widthProperty());
        this.filtersPane.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.filtersPane.getChildren()));
        this.filtersPane.managedProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.filtersPane.getChildren()));
        this.filtersPane.setMinHeight(Double.NEGATIVE_INFINITY);
        this.searchTextField.visibleProperty().bind((ObservableValue)view.textFilterProviderProperty().isNotNull());
        this.searchTextField.managedProperty().bind((ObservableValue)view.textFilterProviderProperty().isNotNull());
        this.searchTextField.textProperty().bindBidirectional((Property)view.filterTextProperty());
        view.textFilterProviderProperty().addListener(it -> this.updateGroups());
        view.getFilterGroups().addListener(it -> this.updateGroups());
        view.getFilters().addListener(it -> this.updateFilters());
        view.filterTextProperty().addListener(it -> this.updateFilters());
        view.textFilterProviderProperty().addListener(it -> this.updateFilters());
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.managedProperty().bind((ObservableValue)this.scrollPane.visibleProperty());
        this.scrollPane.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.filtersPane.getChildren()));
        this.scrollPane.contentProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.size(view.filtersProperty()).greaterThan((ObservableNumberValue)view.scrollThresholdProperty())).then((Object)this.filtersPane).otherwise((Object)null));
        view.scrollThresholdProperty().addListener(it -> this.updateFilters());
        this.container = new VBox(new Node[]{this.headerBox, this.filterGroupsPane, this.filtersPane});
        this.container.getStyleClass().add((Object)"filter-container");
        this.container.setFillWidth(true);
        this.getChildren().add((Object)this.container);
        this.updateGroups();
        this.updateFilters();
        ((FilterView)this.getSkinnable()).getFilters().addListener(it -> Platform.runLater(() -> {
            for (FilterView.Filter filter : this.filterItemMap.keySet()) {
                CheckMenuItem menuItem = this.filterItemMap.get(filter);
                menuItem.setSelected(((FilterView)this.getSkinnable()).getFilters().contains((Object)filter));
            }
        }));
        this.headerBox.setFillHeight(true);
        this.headerBox.getStyleClass().add((Object)"header-box");
        this.headerBox.visibleProperty().bind((ObservableValue)view.showHeaderProperty());
        this.headerBox.managedProperty().bind((ObservableValue)view.showHeaderProperty());
        this.updateHeaderBox();
    }

    private void updateHeaderBox() {
        FilterView view = (FilterView)this.getSkinnable();
        Label titleLabel = view.getTitleLabel();
        titleLabel.textProperty().bind((ObservableValue)view.titleProperty());
        titleLabel.getStyleClass().add((Object)"title");
        Label titlePostfixLabel = view.getTitlePostfixLabel();
        titlePostfixLabel.textProperty().bind((ObservableValue)view.titlePostfixProperty());
        titlePostfixLabel.getStyleClass().addAll((Object[])new String[]{"title", "title-postfix"});
        HBox titleBox = new HBox(new Node[]{titleLabel, titlePostfixLabel});
        titleBox.getStyleClass().add((Object)"title-box");
        Label subtitleLabel = view.getSubtitleLabel();
        subtitleLabel.textProperty().bind((ObservableValue)view.subtitleProperty());
        subtitleLabel.getStyleClass().add((Object)"subtitle");
        VBox titleAndSubtitleBox = new VBox(new Node[]{titleBox, subtitleLabel});
        titleAndSubtitleBox.getStyleClass().add((Object)"title-subtitle-box");
        HBox.setHgrow((Node)titleAndSubtitleBox, (Priority)Priority.ALWAYS);
        if (view.getExtras() != null) {
            this.headerBox.getChildren().setAll((Object[])new Node[]{titleAndSubtitleBox, this.searchTextField, view.getExtras()});
        } else {
            this.headerBox.getChildren().setAll((Object[])new Node[]{titleAndSubtitleBox, this.searchTextField});
        }
    }

    private void updateGroups() {
        this.filterGroupsPane.getChildren().clear();
        this.filterItemMap.clear();
        ((FilterView)this.getSkinnable()).getFilterGroups().forEach(group -> {
            MenuButton menuButton = new MenuButton();
            menuButton.textProperty().bind((ObservableValue)group.nameProperty());
            menuButton.setMaxWidth(Double.MAX_VALUE);
            menuButton.setMaxHeight(Double.MAX_VALUE);
            HBox.setHgrow((Node)menuButton, (Priority)Priority.ALWAYS);
            MenuItem all = new MenuItem("All");
            ObservableList activeFilters = ((FilterView)this.getSkinnable()).getFilters();
            all.setOnAction(evt -> {
                activeFilters.removeAll(group.getFilters());
                activeFilters.addAll(group.getFilters());
            });
            MenuItem none = new MenuItem("None");
            none.setOnAction(evt -> activeFilters.removeAll(group.getFilters()));
            menuButton.getItems().addAll((Object[])new MenuItem[]{all, none, new SeparatorMenuItem()});
            group.getFilters().forEach(filter -> {
                CheckMenuItem item = new CheckMenuItem();
                item.textProperty().bind((ObservableValue)filter.nameProperty());
                item.selectedProperty().addListener(it -> {
                    if (item.isSelected()) {
                        if (!activeFilters.contains(filter)) {
                            activeFilters.add(filter);
                        }
                    } else {
                        activeFilters.remove(filter);
                    }
                });
                item.setSelected(filter.isSelected());
                menuButton.getItems().add((Object)item);
                this.filterItemMap.put((FilterView.Filter)filter, item);
            });
            this.filterGroupsPane.getChildren().add((Object)menuButton);
        });
        if (!this.filterGroupsPane.getChildren().isEmpty()) {
            ((Node)this.filterGroupsPane.getChildren().get(this.filterGroupsPane.getChildren().size() - 1)).getStyleClass().add((Object)"last");
        }
    }

    private void updateFilters() {
        this.filtersPane.getChildren().clear();
        FilterView filterView = (FilterView)this.getSkinnable();
        ObservableList filters = filterView.getFilters();
        if (!filters.isEmpty() || StringUtils.isNotBlank((CharSequence)filterView.getFilterText())) {
            this.updateFiltersWrapper();
            filters.forEach(f -> {
                ChipView<FilterView.Filter> chipView = new ChipView<FilterView.Filter>();
                chipView.setValue((FilterView.Filter)f);
                chipView.textProperty().bind((ObservableValue)f.nameProperty());
                chipView.setOnClose(filter -> filters.remove(filter));
                this.filtersPane.getChildren().add(chipView);
            });
            String filterText = filterView.getFilterText();
            if (StringUtils.isNotBlank((CharSequence)filterText)) {
                ChipView<String> chipView = new ChipView<String>();
                chipView.setValue(filterView.getFilterText());
                chipView.setText("\"" + filterView.getFilterText() + "\"");
                chipView.setOnClose(filter -> filterView.setFilterText(null));
                this.filtersPane.getChildren().add(chipView);
            }
            Label clearFilter = new Label("Clear Filter");
            clearFilter.getStyleClass().add((Object)"clear-filter-label");
            clearFilter.setOnMouseClicked(evt -> {
                filters.clear();
                filterView.setFilterText(null);
            });
            this.filtersPane.getChildren().add((Object)clearFilter);
        }
    }

    private void updateFiltersWrapper() {
        FilterView filterView = (FilterView)this.getSkinnable();
        if (filterView.getFilters().size() > filterView.getScrollThreshold()) {
            this.container.getChildren().remove((Object)this.filtersPane);
            if (!this.container.getChildren().contains((Object)this.scrollPane)) {
                this.container.getChildren().add((Object)this.scrollPane);
            }
        } else {
            this.container.getChildren().remove((Object)this.scrollPane);
            if (!this.container.getChildren().contains((Object)this.filtersPane)) {
                this.container.getChildren().add((Object)this.filtersPane);
            }
        }
    }
}

