/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.EmailField;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.textfield.CustomTextField;

public class EmailFieldSkin
extends SkinBase<EmailField> {
    public EmailFieldSkin(EmailField field) {
        super((Control)field);
        CustomTextField customTextField = field.getEditor();
        Region mailIcon = new Region();
        mailIcon.getStyleClass().add((Object)"mail-icon");
        StackPane leftIconWrapper = new StackPane(new Node[]{mailIcon});
        leftIconWrapper.getStyleClass().add((Object)"mail-icon-wrapper");
        leftIconWrapper.managedProperty().bind((ObservableValue)leftIconWrapper.visibleProperty());
        leftIconWrapper.visibleProperty().bind((ObservableValue)field.showMailIconProperty());
        leftIconWrapper.visibleProperty().addListener(it -> customTextField.requestLayout());
        Region rightIcon = new Region();
        rightIcon.getStyleClass().add((Object)"validation-icon");
        StackPane rightIconWrapper = new StackPane(new Node[]{rightIcon});
        rightIconWrapper.getStyleClass().add((Object)"validation-icon-wrapper");
        rightIconWrapper.managedProperty().bind((ObservableValue)rightIconWrapper.visibleProperty());
        rightIconWrapper.visibleProperty().bind((ObservableValue)field.showValidationIconProperty().and((ObservableBooleanValue)field.validProperty().not()));
        rightIconWrapper.visibleProperty().addListener(it -> customTextField.requestLayout());
        Tooltip invalidToolTip = new Tooltip();
        invalidToolTip.textProperty().bind((ObservableValue)field.invalidTextProperty());
        this.updateTooltipVisibility(field.getInvalidText(), rightIconWrapper, invalidToolTip);
        field.invalidTextProperty().addListener((ob, ov, newValue) -> this.updateTooltipVisibility((String)newValue, rightIconWrapper, invalidToolTip));
        customTextField.textProperty().bindBidirectional((Property)field.emailAddressProperty());
        customTextField.promptTextProperty().bind((ObservableValue)field.promptTextProperty());
        customTextField.setLeft((Node)leftIconWrapper);
        customTextField.setRight((Node)rightIconWrapper);
        this.getChildren().setAll((Object[])new Node[]{customTextField});
    }

    private void updateTooltipVisibility(String invalidText, StackPane node, Tooltip invalidToolTip) {
        if (StringUtils.isEmpty((CharSequence)invalidText)) {
            Tooltip.uninstall((Node)node, (Tooltip)invalidToolTip);
        } else {
            Tooltip.install((Node)node, (Tooltip)invalidToolTip);
        }
    }
}

