/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.YearViewSkin;
import java.time.Year;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class YearView
extends Control {
    private final ReadOnlyIntegerWrapper year = new ReadOnlyIntegerWrapper((Object)this, "year");
    private final ObjectProperty<Year> value = new SimpleObjectProperty((Object)this, "value", (Object)Year.now());
    private final IntegerProperty cols = new SimpleIntegerProperty((Object)this, "cols", 4){

        public void setValue(Number number) {
            if (number.intValue() < 1) {
                throw new IllegalArgumentException("number of columns must be larger than 0");
            }
            super.setValue(number);
        }
    };
    private final IntegerProperty rows = new SimpleIntegerProperty((Object)this, "rows", 5){

        public void setValue(Number number) {
            if (number.intValue() < 1) {
                throw new IllegalArgumentException("number of rows must be larger than 0");
            }
            super.setValue(number);
        }
    };
    private final ObjectProperty<Year> earliestYear = new SimpleObjectProperty((Object)this, "earliestYear");
    private final ObjectProperty<Year> latestYear = new SimpleObjectProperty((Object)this, "latestYear");

    public YearView() {
        this.getStyleClass().add((Object)"year-view");
        this.setFocusTraversable(false);
        this.year.bind((ObservableValue)Bindings.createIntegerBinding(() -> {
            Year value = this.getValue();
            if (value != null) {
                return value.getValue();
            }
            return -1;
        }, (Observable[])new Observable[]{this.valueProperty()}));
    }

    protected Skin<?> createDefaultSkin() {
        return new YearViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(YearView.class.getResource("year-view.css")).toExternalForm();
    }

    public final int getYear() {
        return this.year.get();
    }

    public final ReadOnlyIntegerProperty yearProperty() {
        return this.year.getReadOnlyProperty();
    }

    public final Year getValue() {
        return (Year)this.value.get();
    }

    public final ObjectProperty<Year> valueProperty() {
        return this.value;
    }

    public final void setValue(Year value) {
        this.value.set((Object)value);
    }

    public final int getCols() {
        return this.cols.get();
    }

    public final IntegerProperty colsProperty() {
        return this.cols;
    }

    public final void setCols(int cols) {
        this.cols.set(cols);
    }

    public final int getRows() {
        return this.rows.get();
    }

    public final IntegerProperty rowsProperty() {
        return this.rows;
    }

    public final void setRows(int rows) {
        this.rows.set(rows);
    }

    public final Year getEarliestYear() {
        return (Year)this.earliestYear.get();
    }

    public final ObjectProperty<Year> earliestYearProperty() {
        return this.earliestYear;
    }

    public final void setEarliestYear(Year earliestYear) {
        this.earliestYear.set((Object)earliestYear);
    }

    public final Year getLatestYear() {
        return (Year)this.latestYear.get();
    }

    public final ObjectProperty<Year> latestYearProperty() {
        return this.latestYear;
    }

    public final void setLatestYear(Year latestYear) {
        this.latestYear.set((Object)latestYear);
    }
}

