/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.ResizableTextAreaSkin;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Skin;
import javafx.scene.control.TextArea;

public class ResizableTextArea
extends TextArea {
    private static final boolean DEFAULT_RESIZE_VERTICAL = true;
    private static final boolean DEFAULT_RESIZE_HORIZONTAL = false;
    private BooleanProperty resizeVertical;
    private BooleanProperty resizeHorizontal;

    public ResizableTextArea() {
        this.getStyleClass().add((Object)"resizable-text-area");
    }

    public ResizableTextArea(String text) {
        this();
        this.setText(text);
    }

    protected Skin<?> createDefaultSkin() {
        return new ResizableTextAreaSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(ResizableTextArea.class.getResource("resizable-text-area.css")).toExternalForm();
    }

    public final boolean isResizeVertical() {
        return this.resizeVertical == null ? true : this.resizeVertical.get();
    }

    public final BooleanProperty resizeVerticalProperty() {
        if (this.resizeVertical == null) {
            this.resizeVertical = new SimpleBooleanProperty((Object)this, "resizeVertical", true);
        }
        return this.resizeVertical;
    }

    public final void setResizeVertical(boolean resizeVertical) {
        this.resizeVerticalProperty().set(resizeVertical);
    }

    public final boolean isResizeHorizontal() {
        return this.resizeHorizontal == null ? false : this.resizeHorizontal.get();
    }

    public final BooleanProperty resizeHorizontalProperty() {
        if (this.resizeHorizontal == null) {
            this.resizeHorizontal = new SimpleBooleanProperty((Object)this, "resizeHorizontal", false);
        }
        return this.resizeHorizontal;
    }

    public final void setResizeHorizontal(boolean resizeHorizontal) {
        this.resizeHorizontalProperty().set(resizeHorizontal);
    }
}

