/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.EmailFieldSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.controlsfx.control.textfield.CustomTextField;

public class EmailField
extends Control {
    private static final boolean DEFAULT_SHOW_MAIL_ICON = true;
    private static final boolean DEFAULT_SHOW_VALIDATION_ICON = true;
    private static final PseudoClass VALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"valid");
    private static final PseudoClass INVALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    private static final EmailValidator emailValidator = EmailValidator.getInstance();
    private final CustomTextField editor = new CustomTextField(){

        public String getUserAgentStylesheet() {
            return Objects.requireNonNull(EmailField.class.getResource("email-field.css")).toExternalForm();
        }
    };
    private final BooleanProperty required = new SimpleBooleanProperty((Object)this, "required", false);
    private final StringProperty promptText = new SimpleStringProperty((Object)this, "promptText");
    private final StringProperty emailAddress = new SimpleStringProperty((Object)this, "emailAddress");
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper((Object)this, "valid");
    private final StringProperty invalidText = new SimpleStringProperty((Object)this, "invalidText", "Email address is invalid.");
    private final StyleableBooleanProperty showMailIcon = new SimpleStyleableBooleanProperty(StyleableProperties.SHOW_MAIL_ICON, (Object)this, "showMailIcon", true);
    private final StyleableBooleanProperty showValidationIcon = new SimpleStyleableBooleanProperty(StyleableProperties.SHOW_VALIDATION_ICON, (Object)this, "showValidationIcon", true);

    public EmailField() {
        this.getStyleClass().add((Object)"email-field");
        this.setFocusTraversable(false);
        this.focusedProperty().addListener(it -> {
            if (this.isFocused()) {
                this.getEditor().requestFocus();
            }
        });
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.isRequired()) {
                return emailValidator.isValid(this.getEmailAddress());
            }
            return StringUtils.isBlank((CharSequence)this.getEmailAddress()) || emailValidator.isValid(this.getEmailAddress());
        }, (Observable[])new Observable[]{this.emailAddressProperty(), this.requiredProperty()}));
        this.updateValidPseudoClass(false);
        this.valid.getReadOnlyProperty().addListener((ob, ov, newValue) -> this.updateValidPseudoClass((Boolean)newValue));
    }

    public EmailField(String emailAddress) {
        this();
        this.setEmailAddress(emailAddress);
    }

    private void updateValidPseudoClass(Boolean isValid) {
        this.pseudoClassStateChanged(VALID_PSEUDO_CLASS, isValid);
        this.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, isValid == false);
    }

    protected Skin<?> createDefaultSkin() {
        return new EmailFieldSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(EmailField.class.getResource("email-field.css")).toExternalForm();
    }

    public final CustomTextField getEditor() {
        return this.editor;
    }

    public final boolean isRequired() {
        return this.required.get();
    }

    public final BooleanProperty requiredProperty() {
        return this.required;
    }

    public final void setRequired(boolean required) {
        this.required.set(required);
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final void setPromptText(String promptText) {
        this.promptText.set((Object)promptText);
    }

    public final String getEmailAddress() {
        return (String)this.emailAddress.get();
    }

    public final StringProperty emailAddressProperty() {
        return this.emailAddress;
    }

    public final void setEmailAddress(String emailAddress) {
        this.emailAddress.set((Object)emailAddress);
    }

    public final boolean isValid() {
        return this.valid.get();
    }

    public final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    public final String getInvalidText() {
        return (String)this.invalidText.get();
    }

    public final StringProperty invalidTextProperty() {
        return this.invalidText;
    }

    public final void setInvalidText(String invalidText) {
        this.invalidText.set((Object)invalidText);
    }

    public final boolean isShowMailIcon() {
        return this.showMailIcon.get();
    }

    public final BooleanProperty showMailIconProperty() {
        return this.showMailIcon;
    }

    public final void setShowMailIcon(boolean showMailIcon) {
        this.showMailIcon.set(showMailIcon);
    }

    public final boolean isShowValidationIcon() {
        return this.showValidationIcon.get();
    }

    public final BooleanProperty showValidationIconProperty() {
        return this.showValidationIcon;
    }

    public final void setShowValidationIcon(boolean showValidationIcon) {
        this.showValidationIcon.set(showValidationIcon);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return EmailField.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<EmailField, Boolean> SHOW_MAIL_ICON = new CssMetaData<EmailField, Boolean>("-fx-show-mail-icon", BooleanConverter.getInstance(), Boolean.valueOf(true)){

            public StyleableProperty<Boolean> getStyleableProperty(EmailField control) {
                return (StyleableProperty)control.showMailIconProperty();
            }

            public boolean isSettable(EmailField control) {
                return !control.showMailIcon.isBound();
            }
        };
        private static final CssMetaData<EmailField, Boolean> SHOW_VALIDATION_ICON = new CssMetaData<EmailField, Boolean>("-fx-show-validation-icon", BooleanConverter.getInstance(), Boolean.valueOf(true)){

            public StyleableProperty<Boolean> getStyleableProperty(EmailField control) {
                return (StyleableProperty)control.showValidationIconProperty();
            }

            public boolean isSettable(EmailField control) {
                return !control.showValidationIcon.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SHOW_MAIL_ICON, SHOW_VALIDATION_ICON);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

