/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.Property;

class FxPropertyField<T, M, R extends Property<T>>
implements PropertyField<T, M, R> {
    private T defaultValue;
    private final Function<M, Property<T>> accessor;
    private final R targetProperty;

    public FxPropertyField(SideEffect updateFunction, Function<M, Property<T>> accessor, Supplier<Property<T>> propertySupplier) {
        this(updateFunction, accessor, null, propertySupplier);
    }

    public FxPropertyField(SideEffect updateFunction, Function<M, Property<T>> accessor, T defaultValue, Supplier<Property<T>> propertySupplier) {
        this.accessor = accessor;
        this.defaultValue = defaultValue;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.addListener((observable, oldValue, newValue) -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
        this.accessor.apply(wrappedObject).setValue(this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        this.targetProperty.setValue(this.accessor.apply(wrappedObject).getValue());
    }

    @Override
    public void resetToDefault() {
        this.targetProperty.setValue(this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = this.accessor.apply(wrappedObject).getValue();
    }

    @Override
    public R getProperty() {
        return this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        Object wrapperValue;
        Object modelValue = this.accessor.apply(wrappedObject).getValue();
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty.getValue());
    }
}

