/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.unitfx.util;

import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public final class ControlsUtil {
    private ControlsUtil() {
    }

    public static void bindBooleanToStyleClass(Node node, ObservableValue<Boolean> booleanProperty, String styleClass) {
        booleanProperty.addListener((obs, oldV, newV) -> {
            if (Boolean.TRUE.equals(booleanProperty.getValue())) {
                if (!node.getStyleClass().contains((Object)styleClass)) {
                    node.getStyleClass().add((Object)styleClass);
                }
            } else {
                node.getStyleClass().remove((Object)styleClass);
            }
        });
    }

    public static void bindBooleanToPseudoclass(Node node, ObservableValue<Boolean> booleanProperty, PseudoClass pseudoClass) {
        booleanProperty.addListener((obs, oldV, newV) -> node.pseudoClassStateChanged(pseudoClass, Boolean.TRUE.equals(booleanProperty.getValue())));
    }

    public static double distance(double alpha, double beta) {
        double phi = Math.abs(beta - alpha) % 360.0;
        return phi > 180.0 ? 360.0 - phi : phi;
    }

    public static double rotation(double alpha, double beta) {
        double distance = ControlsUtil.distance(alpha, beta);
        int sign = alpha - beta >= 0.0 && alpha - beta <= 180.0 || alpha - beta <= -180.0 && alpha - beta >= -360.0 ? 1 : -1;
        return distance * (double)sign;
    }

    public static Point2D calculatePointOnCircle(Point2D middle, double radius, double angle) {
        double newAngle = Math.abs(angle) % 360.0;
        if (angle < 0.0) {
            newAngle = 360.0 - newAngle;
        }
        double radians = Math.toRadians(newAngle);
        double tempX = radius * Math.cos(radians);
        double tempY = radius * Math.sin(radians);
        double x = middle.getX();
        double y = middle.getY();
        y = ControlsUtil.switchPixelAndCartesian(y);
        y += tempY;
        y = ControlsUtil.switchPixelAndCartesian(y);
        return new Point2D(x += tempX, y);
    }

    private static double switchPixelAndCartesian(double value) {
        return value == 0.0 ? value : -value;
    }
}

