/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactfx.util.Left;
import org.reactfx.util.Success;
import org.reactfx.util.Try;

class Failure<T>
extends Left<Throwable, T>
implements Try<T> {
    public Failure(Throwable thrown) {
        super(thrown);
    }

    @Override
    public T getOrElse(T fallback) {
        return fallback;
    }

    @Override
    public T getOrElse(Supplier<T> fallback) {
        return fallback.get();
    }

    @Override
    public Try<T> orElse(Try<T> fallback) {
        return fallback;
    }

    @Override
    public Try<T> orElse(Supplier<Try<T>> fallback) {
        return fallback.get();
    }

    @Override
    public Try<T> orElseTry(Callable<? extends T> fallback) {
        return Try.tryGet(fallback);
    }

    @Override
    public Try<T> recover(Function<Throwable, Optional<T>> f) {
        Optional<T> recovered = f.apply(this.getFailure());
        if (recovered.isPresent()) {
            return new Success<T>(recovered.get());
        }
        return this;
    }

    @Override
    public <U> Try<U> map(Function<? super T, ? extends U> f) {
        return new Failure<T>(this.getFailure());
    }

    @Override
    public <U> Try<U> flatMap(Function<? super T, Try<U>> f) {
        return new Failure<T>(this.getFailure());
    }

    @Override
    public String toString() {
        return "failure(" + this.getFailure() + ")";
    }
}

