/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import org.reactfx.EventStream;
import org.reactfx.Guard;
import org.reactfx.ObservableBase;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.util.AccumulationFacility;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.NotificationAccumulator;

public abstract class SuspendableBase<O, T, A>
extends ObservableBase<O, T>
implements Suspendable {
    private final EventStream<T> input;
    private final AccumulationFacility<T, A> af;
    private int suspended = 0;
    private boolean hasValue = false;
    private A accumulatedValue = null;

    protected SuspendableBase(EventStream<T> input, NotificationAccumulator<O, T, A> pn) {
        super(pn);
        this.input = input;
        this.af = pn.getAccumulationFacility();
    }

    protected abstract AccumulatorSize sizeOf(A var1);

    protected abstract T headOf(A var1);

    protected abstract A tailOf(A var1);

    protected A initialAccumulator(T value) {
        return this.af.initialAccumulator(value);
    }

    protected A reduce(A accum, T value) {
        return this.af.reduce(accum, value);
    }

    protected final boolean isSuspended() {
        return this.suspended > 0;
    }

    @Override
    public final Guard suspend() {
        ++this.suspended;
        return Guard.closeableOnce(this::resume);
    }

    @Override
    protected final Subscription observeInputs() {
        Subscription sub = this.input.subscribe(this::handleEvent);
        return sub.and(this::reset);
    }

    private void resume() {
        --this.suspended;
        if (this.suspended == 0 && this.hasValue) {
            while (this.sizeOf(this.accumulatedValue) == AccumulatorSize.MANY) {
                this.enqueueNotifications(this.headOf(this.accumulatedValue));
                this.accumulatedValue = this.tailOf(this.accumulatedValue);
            }
            if (this.sizeOf(this.accumulatedValue) == AccumulatorSize.ONE) {
                this.enqueueNotifications(this.headOf(this.accumulatedValue));
            }
            this.reset();
            this.notifyObservers();
        }
    }

    private void reset() {
        this.hasValue = false;
        this.accumulatedValue = null;
    }

    private void handleEvent(T event) {
        if (this.isSuspended()) {
            if (this.hasValue) {
                this.accumulatedValue = this.reduce(this.accumulatedValue, event);
            } else {
                this.accumulatedValue = this.initialAccumulator(event);
                this.hasValue = true;
            }
        } else {
            this.notifyObservers(event);
        }
    }
}

