/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring.internal.freedesktop;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.secret.Collection;
import org.freedesktop.secret.Item;
import org.freedesktop.secret.Pair;
import org.freedesktop.secret.Prompt;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Session;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.TransportEncryption;
import org.freedesktop.secret.interfaces.Collection;
import org.freedesktop.secret.interfaces.Prompt;
import org.gnome.keyring.InternalUnsupportedGuiltRiddenInterface;

public final class SimpleCollection
implements AutoCloseable {
    private TransportEncryption encryption = null;
    private Service service = null;
    private Session session = null;
    private Prompt prompt = null;
    private InternalUnsupportedGuiltRiddenInterface withoutPrompt = null;
    private Collection collection;
    private Secret encrypted = null;

    public SimpleCollection() throws IOException {
        this.init();
        ObjectPath path = Static.Convert.toObjectPath((String)"/org/freedesktop/secrets/aliases/default");
        this.collection = new Collection((DBusPath)path, this.service);
        this.unlock();
    }

    private void init() throws IOException {
        try {
            this.encryption = new TransportEncryption();
            this.encryption.initialize();
            this.encryption.openSession();
            this.encryption.generateSessionKey();
            this.service = this.encryption.getService();
            this.session = this.service.getSession();
            this.prompt = new Prompt(this.service);
            this.withoutPrompt = new InternalUnsupportedGuiltRiddenInterface(this.service);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | DBusException ex) {
            throw new IOException(ex.toString(), ex.getCause());
        }
    }

    private void performPrompt(ObjectPath path) {
        if (!"/".equals(path.getPath())) {
            this.prompt.await(path);
        }
    }

    private void unlock() {
        if (this.collection.isLocked()) {
            if (this.encrypted == null) {
                Pair response = this.service.unlock(Arrays.asList(this.collection.getPath()));
                this.performPrompt((ObjectPath)response.b);
            } else {
                this.withoutPrompt.unlockWithMasterPassword((DBusPath)this.collection.getPath(), this.encrypted);
            }
        }
    }

    private Item getItem(String path) {
        return new Item(Static.Convert.toObjectPath((String)path), this.service);
    }

    public void clear() {
        if (this.encryption != null) {
            this.encryption.clear();
        }
        if (this.encrypted != null) {
            this.encrypted.clear();
        }
    }

    @Override
    public void close() throws Exception {
        this.clear();
        if (this.service != null) {
            DBusConnection connection = this.service.getConnection();
            if (connection != null) {
                this.service.getConnection().close();
            }
            connection.close();
        }
    }

    public String createItem(String label, CharSequence password, Map<String, String> attributes) throws IllegalArgumentException {
        if (password == null) {
            throw new IllegalArgumentException("The password may not be null.");
        }
        if (label == null) {
            throw new IllegalArgumentException("The label of the password may not be null.");
        }
        this.unlock();
        DBusPath item = null;
        Map properties = Item.createProperties((String)label, attributes);
        try (Secret secret = this.encryption.encrypt(password);){
            Pair response = this.collection.createItem(properties, secret, false);
            item = (DBusPath)response.a;
            if ("/".equals(item.getPath())) {
                Prompt.Completed completed = this.prompt.await((ObjectPath)response.b);
                if (!completed.dismissed) {
                    Collection.ItemCreated ic = (Collection.ItemCreated)this.collection.getSignalHandler().getLastHandledSignal(Collection.ItemCreated.class);
                    item = ic.item;
                }
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
        return item.getPath();
    }

    public String createItem(String label, CharSequence password) throws IllegalArgumentException {
        return this.createItem(label, password, null);
    }

    public void updateItem(String objectPath, String label, CharSequence password, Map<String, String> attributes) throws IllegalArgumentException {
        if (objectPath == null) {
            throw new IllegalArgumentException("The object path of the item may not be null.");
        }
        this.unlock();
        Item item = this.getItem(objectPath);
        if (label != null) {
            item.setLabel(label);
        }
        if (attributes != null) {
            item.setAttributes(attributes);
        }
        if (password != null) {
            try (Secret secret = this.encryption.encrypt(password);){
                item.setSecret(secret);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
                // empty catch block
            }
        }
    }

    public List<String> getItems(Map<String, String> attributes) {
        this.unlock();
        List objects = this.collection.searchItems(attributes);
        if (objects != null && !objects.isEmpty()) {
            return Static.Convert.toStrings((List)objects);
        }
        return null;
    }

    public char[] getSecret(String objectPath) {
        this.unlock();
        Item item = this.getItem(objectPath);
        char[] decrypted = null;
        try (Secret secret = item.getSecret(this.session.getPath());){
            decrypted = this.encryption.decrypt(secret);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
        return decrypted;
    }

    public void deleteItem(String objectPath) throws AccessControlException {
        Item item = this.getItem(objectPath);
        ObjectPath promptPath = item.delete();
        this.performPrompt(promptPath);
    }
}

