/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.KeyringStorageType;
import com.github.javakeyring.PasswordAccessException;
import com.github.javakeyring.internal.KeyringBackend;
import com.github.javakeyring.internal.KeyringBackendFactory;

public class Keyring
implements AutoCloseable {
    private final KeyringBackend backend;

    public static Keyring create() throws BackendNotSupportedException {
        return new Keyring(KeyringBackendFactory.create());
    }

    public static Keyring create(KeyringStorageType keyring) throws BackendNotSupportedException {
        return new Keyring(KeyringBackendFactory.create(keyring));
    }

    private Keyring(KeyringBackend backend) {
        this.backend = backend;
    }

    public KeyringStorageType getKeyringStorageType() {
        return KeyringStorageType.getLabelForBackend(this.backend.getClass());
    }

    public String getPassword(String service, String account) throws PasswordAccessException {
        return this.backend.getPassword(service, account);
    }

    public void setPassword(String service, String account, String password) throws PasswordAccessException {
        this.backend.setPassword(service, account, password);
    }

    public void deletePassword(String service, String account) throws PasswordAccessException {
        this.backend.deletePassword(service, account);
    }

    @Override
    public void close() throws Exception {
        this.backend.close();
    }
}

