/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.javamodularity.moduleplugin.shadow.javaparser.TokenRange;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AllFieldsConstructor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.BooleanLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.observer.ObservableProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.Statement;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.CloneVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.GenericVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.VoidVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.AssertStmtMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.JavaParserMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.OptionalProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Utils;

public class AssertStmt
extends Statement {
    private Expression check;
    @OptionalProperty
    private Expression message;

    public AssertStmt() {
        this(null, new BooleanLiteralExpr(), null);
    }

    public AssertStmt(Expression check) {
        this(null, check, null);
    }

    @AllFieldsConstructor
    public AssertStmt(Expression check, Expression message) {
        this(null, check, message);
    }

    public AssertStmt(TokenRange tokenRange, Expression check, Expression message) {
        super(tokenRange);
        this.setCheck(check);
        this.setMessage(message);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getCheck() {
        return this.check;
    }

    public Optional<Expression> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public AssertStmt setCheck(Expression check) {
        Utils.assertNotNull(check);
        if (check == this.check) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.CHECK, this.check, check);
        if (this.check != null) {
            this.check.setParentNode(null);
        }
        this.check = check;
        this.setAsParentNodeOf(check);
        return this;
    }

    public AssertStmt setMessage(Expression message) {
        if (message == this.message) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.MESSAGE, this.message, message);
        if (this.message != null) {
            this.message.setParentNode(null);
        }
        this.message = message;
        this.setAsParentNodeOf(message);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.message != null && node == this.message) {
            this.removeMessage();
            return true;
        }
        return super.remove(node);
    }

    public AssertStmt removeMessage() {
        return this.setMessage(null);
    }

    @Override
    public AssertStmt clone() {
        return (AssertStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public AssertStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.assertStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.check) {
            this.setCheck((Expression)replacementNode);
            return true;
        }
        if (this.message != null && node == this.message) {
            this.setMessage((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isAssertStmt() {
        return true;
    }

    @Override
    public AssertStmt asAssertStmt() {
        return this;
    }

    @Override
    public void ifAssertStmt(Consumer<AssertStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<AssertStmt> toAssertStmt() {
        return Optional.of(this);
    }
}

