/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLDistPointName;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRLDistPoint
implements ASN1Object,
Externalizable {
    private CRLDistPointName distPointName = null;
    private boolean[] reasons;
    private int reasonsCount;
    private ArrayList<GeneralName> crlIssuer = null;
    private transient ASN1Object contents = null;

    public CRLDistPoint() {
    }

    public CRLDistPoint(CRLDistPointName distPointName) {
        this.distPointName = distPointName;
    }

    public CRLDistPoint(GeneralName crlIssuerName) {
        this.crlIssuer = new ArrayList();
        this.crlIssuer.add(crlIssuerName);
    }

    public CRLDistPoint(InputStream is) throws IOException {
        this.input(is);
    }

    public void setDistPointName(CRLDistPointName distPointName) {
        this.distPointName = distPointName;
        this.update();
    }

    public CRLDistPointName getDistPointName() {
        return this.distPointName;
    }

    public boolean hasReasonFlag(CRLReason reason) {
        int i = reason.getValue();
        return this.reasons != null && i < this.reasons.length ? this.reasons[i] : false;
    }

    public void setReasonFlag(CRLReason reason) {
        this.doSetReasonFlag(reason);
        this.update();
    }

    public void setReasonFlags(CRLReason[] crlReasons) {
        int len = crlReasons.length;
        for (int i = 0; i < len; ++i) {
            this.doSetReasonFlag(crlReasons[i]);
        }
        this.update();
    }

    public void clearReasonFlag(CRLReason reason) {
        int i = reason.getValue();
        if (this.reasons != null && i < this.reasons.length) {
            this.reasons[i] = false;
        }
        this.update();
    }

    public void clearAllReasonFlags() {
        if (this.reasons != null) {
            int len = this.reasons.length;
            for (int i = 0; i < len; ++i) {
                this.reasons[i] = false;
            }
            this.update();
        }
    }

    private void doSetReasonFlag(CRLReason reason) {
        if (this.reasons == null || this.reasons.length < CRLReason.LIST.length) {
            boolean[] newReasons = new boolean[CRLReason.LIST.length];
            if (this.reasons != null) {
                System.arraycopy(this.reasons, 0, newReasons, 0, this.reasons.length);
            }
            this.reasons = newReasons;
        }
        this.reasons[reason.getValue()] = true;
        ++this.reasonsCount;
    }

    public void addCRLIssuerName(GeneralName crlIssuerName) {
        if (this.crlIssuer == null) {
            this.crlIssuer = new ArrayList();
        }
        this.crlIssuer.add(crlIssuerName);
        this.update();
    }

    @Deprecated
    public Vector<GeneralName> getCRLIssuerNames() {
        return this.crlIssuer == null ? null : new VectorOverArrayList(this.crlIssuer);
    }

    public ArrayList<GeneralName> getCRLIssuerNamesAsList() {
        return this.crlIssuer;
    }

    public void input(InputStream is) throws IOException {
        this.update();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
            ASN1ConstructedInputStream distPointNameIS = new ASN1ConstructedInputStream((InputStream)sis, 0);
            this.distPointName = new CRLDistPointName((InputStream)distPointNameIS);
            distPointNameIS.terminate();
        } else {
            this.distPointName = null;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
            int i;
            sis.setCurrentTag(3);
            ASN1BitString b = new ASN1BitString((InputStream)sis);
            this.reasons = new boolean[b.bitLength()];
            try {
                for (i = 0; i < this.reasons.length; ++i) {
                    this.reasons[i] = b.testBit(i);
                    ++this.reasonsCount;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new ASN1FormatException("Unknown reasons flag: " + i);
            }
        } else {
            this.reasons = null;
            this.reasonsCount = 0;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 2) {
            sis.setCurrentTag(16);
            this.crlIssuer = new ArrayList();
            ASN1SequenceInputStream crlIssuerIS = new ASN1SequenceInputStream((InputStream)sis);
            while (crlIssuerIS.hasMoreData()) {
                this.crlIssuer.add(new GeneralName((InputStream)crlIssuerIS));
            }
            crlIssuerIS.terminate();
        } else {
            this.crlIssuer = null;
        }
        sis.terminate();
        if (this.distPointName == null && this.reasons == null && this.crlIssuer == null) {
            throw new ASN1FormatException("Empty DRLDistPoint input");
        }
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            if (this.distPointName == null && this.reasons == null && this.crlIssuer == null) {
                throw new IllegalStateException("Invalid CRLDistPoint, all fields missing");
            }
            ASN1Sequence s = new ASN1Sequence();
            if (this.distPointName != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.distPointName, 0));
            }
            if (this.reasons != null && this.reasonsCount > 0) {
                ASN1BitString b = new ASN1BitString(this.reasons.length);
                for (int i = 0; i < this.reasons.length; ++i) {
                    if (!this.reasons[i]) continue;
                    b.setBit(i);
                }
                s.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)b, 1));
            }
            if (this.crlIssuer != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed(this.crlIssuer, 2));
            }
            this.contents = s;
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private void update() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

