import asyncio

from typing import Tuple

from grpclib.client import Channel

# generated by protoc
from .primes_pb2 import Request
from .primes_grpc import PrimesStub


PRIMES = [
    112272535095293,
    112582705942171,
    112272535095293,
    115280095190773,
    115797848077099,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
]


async def main() -> None:
    async with Channel('127.0.0.1', 50051) as channel:
        primes = PrimesStub(channel)

        async def check(n: int) -> Tuple[int, bool]:
            reply = await primes.Check(Request(number=n))
            return n, reply.is_prime.value

        for f in asyncio.as_completed([check(n) for n in PRIMES]):
            number, is_prime = await f
            print(f'Number {number} {"is" if is_prime else "is not"} prime')


if __name__ == '__main__':
    asyncio.run(main())
