\page Examplescavenger Example scavenger

\author F. Chappuis (a), L. Desorgher (b), H. Tran (c)      \n
(a) flore.chappuis@chuv.ch                                  \n
(b) laurent.desorgher@chuv.ch                               \n
(c) tran@cenbg.in2p3.fr                                     \n

(a,b) Institute of Radiation Physics (IRA), Lausanne University Hospital        \n
      and University of Lausanne, CH-1007 Lausanne, Switzerland                 \n
(c) CNRS, CENBG, UMR 5797, Université de Bordeaux, F-33170 Gradignan, France    \n

Funding: FNS Synergia grant MAGIC-FNS CRSII5_186369.

This example is provided by the Geant4-DNA collaboration.
(http://geant4-dna.org)

Any report or published results obtained using the Geant4-DNA software shall 
cite the following Geant4-DNA collaboration publications: \n
Med. Phys. 45 (2018) e722-e739  \n
Phys. Med. 31 (2015) 861-874    \n
Med. Phys. 37 (2010) 4692-4708  \n
Int. J. Model. Simul. Sci. Comput. 1 (2010) 157–178 \n


## INTRODUCTION

This example shows how to activate the scavenging process in chemistry
using the deterministic treatment of the IRT model (see chem6 example).
It allows to define chemical reactions and the concentration of
scavengers by means of a user text file (see section 10). The
concentration of scavengers is assumed to be constant over time.

To run the example:

    mkdir scavenger-build
    cd scavenger-build
    cmake ../pathToExamples/scavenger
    make

In interactive mode, run:

    ./scavenger

(Note: the interactive mode only allows the visualisation of the
physical stage and does not work for the chemical stage)

In batch mode, the macro beam.in can be used as follows:

    ./scavenger beam.in

or

    ./scavenger beam.in 123
        123 is the user's seed number

## GEOMETRY DEFINITION

The world volume is a simple water box which represents a 'pseudo infinite'
homogeneous medium.

Two parameters define the geometry :
- the material of the box for the physical stage is water.
- for the chemistry stage, the concentration of scavengers in [mole/l]
  is added. This concentration is supposed to have no effect on the 
  physical stage.

The default geometry is constructed in DetectorConstruction class.

## PHYSICS LIST

Physics list is Geant4 modular physics list using G4EmDNAPhysics_option2
and EmDNAChemistry constructors (the chemistry constructor uses the
independent reaction time method).

## ACTION INITIALIZATION

The class ActionInitialization instantiates and registers
to Geant4 kernel all user action classes.

While in sequential mode the action classes are instantiated just once,
via invoking the method
ActionInitialization::Build()
in multi-threading mode the same method is invoked for each thread worker
and so all user action classes are defined thread-local.

A run action class is instantiated both thread-local
and global that's why its instance is created also in the method
ActionInitialization::BuildForMaster()
which is invoked only in multi-threading mode.
  
To not register a molecule, add this command:
G4MoleculeCounter::Instance()->DontRegister(G4O2::Definition());

## AN EVENT: PRIMARY GENERATOR
    
The primary kinematic consists of a single particle starting at the
center of the box. The type of the particle and its energy are set
in the PrimaryGeneratorAction class, and can be changed via the G4 
build-in commands of G4GeneralParticleSource class.
The chemistry module is triggered in the StackingAction class when
all physical tracks have been processed.

## DETECTOR RESPONSE : Scorers

### Species scorer

Scorers are defined in DetectorConstruction::ConstructSDandField().
There is one G4MultiFunctionalDetector object which computes the 
energy deposition and the number of species along time in order to
extract the radiochemical yields:
```
(Number of species X) / (100 eV of deposited energy).
```

Run::RecordEvent(), called at end of event, collects information
event per event from the hits collections, and accumulates statistic
for RunAction::EndOfRunAction().

In multi-threading mode the accumulated statistics per workers is
merged to the master in Run::Merge().
    
These two macro commands can be used to control the scoring time:

```
/scorer/species/addTimeToRecord 1 ps
# user can select time bin to score G values.

/scorer/species/nOfTimeBins
# or user can automatically select time bin logarithmically.
```
    
The information about all the molecular species is scored in a ROOT
ntuple file, the name of which can be given by the user through the
macro command: /scoreSpecies/setRootFileName scorer.root.
The ROOT program plotG.C can be used to plot the G values vs time
for each species.
  
### Primary Killer

The G values are computed for a range of deposited energy. We are
in an infinite volume. Therefore the energy lost by the primary
equals the deposited energy since all secondary particles will
finally slow down to the thermal energy. 
The primary is killed once it has deposited more energy than a 
minimum threshold. 
    
IMPORTANT: However, when the primary particle loses more energy 
in few interaction steps than the maximum allowed threshold, the
event is disregarded (= aborted).

These two macro commands can be used to control the energy loss by 
the primary:

```
/primaryKiller/eLossMin 10 keV
# after 10 keV of energy loss by the primary particle, the primary is killed
      
/primaryKiller/eLossMax 10.1 keV
# if the primary particle loses more than 10.1 keV, the event is aborted
```

The G values are then computed for a deposited energy in the range
[10 keV; 10.1 keV].
 
Note that if the upper boundary of the energy lost by the primary
is not set, the chemistry may take a lot of time to compute. 
This set of macros is embedded in the PrimaryKiller class.
The species scorer must check whether the event was aborted before
taking it or not into account for the computation of the results.

The size of detector can be controlled by this class using user
macro command:

```
/primaryKiller/setSize 5 5 5 um
# kill the particles (primary and secondary) outside of the virtual volume
```

## STACKING ACTION

scavenger::StackingAction::NewStage() is called when a stack of tracks has been
processed (for more details, look at the Geant4 documentation).
A verification on whether physical tracks remain to be processed
is done. If no tracks remain to be processed, the chemical module
is then triggered.

## VISUALIZATION

The visualization manager is set via the G4VisExecutive class in the
main() function in scavenger.cc.
The initialization of the drawing is done via a set of /vis/ commands
in the macro vis.mac. To activate the visualization mode, run:

```
./scavenger
```

## OUTPUT

Physics initialization and the defined reaction table are printed.
G4Scheduler processes the chemical stage after the physical stage has been completed.
   
## RELEVANT MACRO COMMANDS AND MACRO FILE

```
/primaryKiller/eLossMin 10 keV 
# after 10 keV of energy loss by the primary particle, the primary is killed
    
/primaryKiller/eLossMax 10.1 keV 
# if the primary particle loses more than 10.1 keV, the event is aborted
    
/scheduler/verbose 1 
# set the verbose level of the G4Scheduler class (time steps, reactions ...)

/scheduler/endTime 1 microsecond 
# set the time at which the simulation stops
    
/scheduler/whyDoYouStop 
# for advanced users: print information at the end of the chemical stage to know why the simulation has stopped
```

The user macro file is beam.in (electron simulations with primary killer method).

## REACTION PARSER FILE

This file is used to define chemical reactions and the concentration
of scavengers for the EmDNAChemistry constructor.
    
Definition of scavengers:
```
scavenger: NAME  CONCENTRATION
# concentration in [mole/l]
```
      
Definition of chemical reactions:
```
REACTANTS -> PRODUCTS , RATE   TYPE
# reaction rate in [1/s/(mole/l)], for first order reaction in [1/s]
# reaction type based on Frongillo et al., Rad. Phys. Chem., 1998
```
      
In any reaction, the molecules surrounded by square brackets [] are
scavengers. In the products of a reaction, the user can also use [] 
to prevent a molecule from being produced.

In this example, we provide 2 reaction tables for 2 different scavengers:
one with O2 and another with NO2-/NO3-. We encourage the user to add 
chemical reactions and/or scavengers. However, the parser does not allow
the addition of molecules not defined in the model. This aspect will be
improved in future releases. In the meantime, please refer to the NO2- 
or NO3- ions defined in EmDNAChemistry::ConstructMolecule() to add new
molecules.

## PLOT

The information about all the molecular species is scored in a ROOT
(https://root.cern) ntuple file scorer.root. The ROOT program plotG
can be used to plot the G values vs time for each species.

Execute plotG as:
```
root plotG.C
```

or print G values to scorer.txt
```
root plotG.C > scorer.txt
```

The results show the molecular species (G values) as a function of
time (ns). Please ignore the O_2^0 molecule.
The function (plotG()) should have the same name as the
file without file extension (plotG).
  
## OTHER

In physics: How can I display the tracking information?
```
/tracking/verbose 1
```

In chemistry: How can I display the reaction information?
```
/scheduler/verbose 1
```

How can I display the step by step information?
```
/scheduler/verbose 3
```
