/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessibleKt;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\"B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\n\u001a\u00060\u000bR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\t\u0010\u0010\u001a\u00020\u0011X\u0082\u0004R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/Accessible;", "Ljava/awt/Component;", "semanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "controller", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/platform/a11y/AccessibilityController;)V", "cachedSemanticsConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "composeAccessibleContext", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "getComposeAccessibleContext", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "composeAccessibleContext$delegate", "Lkotlin/Lazy;", "isNativelyInitialized", "Lkotlinx/atomicfu/AtomicBoolean;", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "semanticsConfig", "getSemanticsConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", "value", "getSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "setSemanticsNode", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "ComposeAccessibleComponent", "ui"})
@StabilityInferred(parameters=0)
public final class ComposeAccessible
extends Component
implements Accessible {
    @NotNull
    private final AccessibilityController controller;
    @NotNull
    private SemanticsNode semanticsNode;
    @Nullable
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    @NotNull
    private final Lazy composeAccessibleContext$delegate;
    private boolean removed;
    public static final int $stable = 8;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;

    public ComposeAccessible(@NotNull SemanticsNode semanticsNode, @NotNull AccessibilityController controller) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"semanticsNode");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.semanticsNode = semanticsNode;
        this.isNativelyInitialized$volatile = 0;
        this.composeAccessibleContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleComponent>(this){
            final /* synthetic */ ComposeAccessible this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ComposeAccessibleComponent invoke() {
                return this.this$0.new ComposeAccessibleComponent();
            }
        }));
    }

    @NotNull
    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    public final void setSemanticsNode(@NotNull SemanticsNode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.semanticsNode = value;
        this.cachedSemanticsConfig = null;
    }

    private final SemanticsConfiguration getSemanticsConfig() {
        SemanticsConfiguration semanticsConfiguration = this.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration it = semanticsConfiguration2 = this.semanticsNode.getConfig();
            boolean bl = false;
            this.cachedSemanticsConfig = it;
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    private final /* synthetic */ int isNativelyInitialized$volatile() {
        return this.isNativelyInitialized$volatile;
    }

    private final /* synthetic */ void setNativelyInitialized$volatile(int value) {
        this.isNativelyInitialized$volatile = value;
    }

    @NotNull
    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    public final boolean getRemoved() {
        return this.removed;
    }

    public final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @Override
    @Nullable
    public AccessibleContext getAccessibleContext() {
        if (this.removed) {
            return null;
        }
        if (ComposeAccessible.isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible((Accessible)this);
        }
        return this.getComposeAccessibleContext();
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0006\u00a2\u0001\u00a3\u0001\u00a4\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u0011\u0010O\u001a\u00020\u00172\u0006\u0010P\u001a\u00020QH\u0096\u0002J\u0010\u0010R\u001a\u00020\u00172\u0006\u0010S\u001a\u000204H\u0016J\n\u0010T\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010U\u001a\u000204H\u0016J\u0010\u0010V\u001a\u00020W2\u0006\u0010S\u001a\u000204H\u0016J\u0012\u0010X\u001a\u0004\u0018\u00010\u000f2\u0006\u0010P\u001a\u00020QH\u0016J\u0012\u0010Y\u001a\u0004\u0018\u00010\u000f2\u0006\u0010S\u001a\u000204H\u0016J\b\u0010Z\u001a\u000204H\u0016J\n\u0010[\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010\\\u001a\u0004\u0018\u00010WH\u0016J\n\u0010]\u001a\u0004\u0018\u00010^H\u0016J\b\u0010_\u001a\u000204H\u0016J\n\u0010`\u001a\u0004\u0018\u00010WH\u0016J\n\u0010a\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010b\u001a\u00020cH\u0016J\b\u0010d\u001a\u00020eH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010fH\u0016J\n\u0010g\u001a\u0004\u0018\u00010hH\u0016J\b\u0010i\u001a\u00020jH\u0016J\b\u0010k\u001a\u00020lH\u0016J\b\u0010m\u001a\u00020nH\u0016J\b\u0010o\u001a\u00020pH\u0016J\u0012\u0010q\u001a\u00020r2\b\u0010s\u001a\u0004\u0018\u00010pH\u0016J\b\u0010t\u001a\u00020jH\u0016J\b\u0010u\u001a\u00020vH\u0016J\b\u0010w\u001a\u00020QH\u0016J\b\u0010x\u001a\u00020QH\u0016J\b\u0010y\u001a\u00020zH\u0016J\b\u0010{\u001a\u00020\u0017H\u0016J\b\u0010|\u001a\u00020\u0017H\u0016J\b\u0010}\u001a\u00020\u0017H\u0016J\b\u0010~\u001a\u00020\u0017H\u0016J\u0011\u0010\u007f\u001a\u00020\u000f2\u0007\u0010\u0080\u0001\u001a\u00020\u0017H\u0002J\u0013\u0010\u0081\u0001\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\t\u0010\u0082\u0001\u001a\u00020LH\u0016J\u0014\u0010\u0083\u0001\u001a\u00020L2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010jH\u0016J\u0014\u0010\u0085\u0001\u001a\u00020L2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010lH\u0016J\u0014\u0010\u0087\u0001\u001a\u00020L2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010nH\u0016J\u0012\u0010\u0089\u0001\u001a\u00020L2\u0007\u0010\u008a\u0001\u001a\u00020\u0017H\u0016J\u0013\u0010\u008b\u0001\u001a\u00020L2\b\u0010s\u001a\u0004\u0018\u00010pH\u0016J\u0014\u0010\u008c\u0001\u001a\u00020L2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010jH\u0016J\u0013\u0010\u008d\u0001\u001a\u00020L2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J\u0014\u0010\u008e\u0001\u001a\u00020L2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010zH\u0016J\u0012\u0010\u0090\u0001\u001a\u00020L2\u0007\u0010\u008a\u0001\u001a\u00020\u0017H\u0016J\u001a\u0010\u0091\u0001\u001a\u00020z*\u00030\u0092\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0093\u0001\u0010\u0094\u0001J\u001a\u0010\u0095\u0001\u001a\u00020Q*\u00030\u0096\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0097\u0001\u0010\u0098\u0001J\u001a\u0010\u0099\u0001\u001a\u000204*\u00030\u009a\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009b\u0001\u0010\u009c\u0001J\u000e\u0010\u009d\u0001\u001a\u00020l*\u00030\u009e\u0001H\u0002J\u001d\u0010\u009f\u0001\u001a\u00030\u0096\u0001*\u00020QH\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00a0\u0001\u0010\u00a1\u0001R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u0006\u001a\f\u0018\u00010\u0007R\u00060\u0000R\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%RI\u0010&\u001a:\u00124\u00122\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u00170(\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0013\u00100\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0019R1\u00102\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001703\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010/R%\u00106\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\u001707\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010/R\u0013\u0010:\u001a\u0004\u0018\u0001088F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0013\u0010=\u001a\u0004\u0018\u00010>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0019\u0010A\u001a\u0004\u0018\u00010B8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0013\u0010E\u001a\u0004\u0018\u00010F8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0013\u0010I\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001d\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00a5\u0001"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible;)V", "accessibleAction", "accessibleText", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "getAccessibleText", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "accessibleText$delegate", "Lkotlin/Lazy;", "auxiliaryChildren", "", "Ljavax/accessibility/Accessible;", "getAuxiliaryChildren", "()Ljava/util/List;", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "focused", "", "getFocused", "()Ljava/lang/Boolean;", "horizontalScroll", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScroll", "()Landroidx/compose/ui/semantics/ScrollAxisRange;", "isContainer", "isPassword", "()Z", "isTraversalGroup", "progressBarRangeInfo", "Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getProgressBarRangeInfo", "()Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "scrollBy", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getScrollBy", "()Landroidx/compose/ui/semantics/AccessibilityAction;", "selected", "getSelected", "setSelection", "Lkotlin/Function3;", "", "getSetSelection", "setText", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString;", "getSetText", "text", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "textSelectionRange", "Landroidx/compose/ui/text/TextRange;", "getTextSelectionRange-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "toggleableState", "Landroidx/compose/ui/state/ToggleableState;", "getToggleableState", "()Landroidx/compose/ui/state/ToggleableState;", "verticalScroll", "getVerticalScroll", "addFocusListener", "", "l", "Ljava/awt/event/FocusListener;", "contains", "p", "Ljava/awt/Point;", "doAccessibleAction", "i", "getAccessibleAction", "getAccessibleActionCount", "getAccessibleActionDescription", "", "getAccessibleAt", "getAccessibleChild", "getAccessibleChildrenCount", "getAccessibleComponent", "getAccessibleDescription", "getAccessibleEditableText", "Ljavax/accessibility/AccessibleEditableText;", "getAccessibleIndexInParent", "getAccessibleName", "getAccessibleParent", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "Ljavax/accessibility/AccessibleText;", "getAccessibleValue", "Ljavax/accessibility/AccessibleValue;", "getBackground", "Ljava/awt/Color;", "getBounds", "Ljava/awt/Rectangle;", "getCursor", "Ljava/awt/Cursor;", "getFont", "Ljava/awt/Font;", "getFontMetrics", "Ljava/awt/FontMetrics;", "f", "getForeground", "getLocale", "Ljava/util/Locale;", "getLocation", "getLocationOnScreen", "getSize", "Ljava/awt/Dimension;", "isEnabled", "isFocusTraversable", "isShowing", "isVisible", "makeScrollbarChild", "vertical", "removeFocusListener", "requestFocus", "setBackground", "c", "setBounds", "r", "setCursor", "cursor", "setEnabled", "b", "setFont", "setForeground", "setLocation", "setSize", "d", "setVisible", "toAwtDimension", "Landroidx/compose/ui/unit/IntSize;", "toAwtDimension-ozmzZPI", "(J)Ljava/awt/Dimension;", "toAwtPoint", "Landroidx/compose/ui/geometry/Offset;", "toAwtPoint-k-4lQ0M", "(J)Ljava/awt/Point;", "toAwtPx", "Landroidx/compose/ui/unit/Dp;", "toAwtPx-0680j_4", "(F)I", "toAwtRectangle", "Landroidx/compose/ui/geometry/Rect;", "toComposeOffset", "toComposeOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "ComposeAccessibleEditableText", "ComposeAccessibleText", "ScrollBarAccessible", "ui"})
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n*L\n1#1,884:1\n149#2:885\n350#3,7:886\n82#4:893\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n*L\n225#1:885\n327#1:886,7\n365#1:893\n*E\n"})
    public class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleComponent,
    AccessibleAction {
        @Nullable
        private AccessibleAction accessibleAction;
        @NotNull
        private final Lazy accessibleText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleText>(this){
            final /* synthetic */ ComposeAccessibleComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ComposeAccessibleText invoke() {
                return this.this$0.getSetText() != null ? (ComposeAccessibleText)this.this$0.new ComposeAccessibleEditableText() : (this.this$0.getText() != null ? this.this$0.new ComposeAccessibleText() : null);
            }
        }));

        @Nullable
        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        @Nullable
        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        @Nullable
        public final AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> getSetSelection() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetSelection());
        }

        @Nullable
        public final AnnotatedString getText() {
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString == null) {
                annotatedString = (AnnotatedString)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getText());
            }
            return annotatedString;
        }

        @Nullable
        public final TextLayoutResult getTextLayoutResult() {
            Function1<List<TextLayoutResult>, Boolean> function1;
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            Boolean getLayoutResult = accessibilityAction != null && (function1 = accessibilityAction.getAction()) != null ? (Boolean)function1.invoke((Object)textLayoutResults) : null;
            return Intrinsics.areEqual(getLayoutResult, (Object)true) ? (TextLayoutResult)textLayoutResults.get(0) : null;
        }

        @Nullable
        public final Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        @Nullable
        public final Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return ComposeAccessible.this.controller.getDesktopComponent().getDensity();
        }

        @Nullable
        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        @Nullable
        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        @Nullable
        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final boolean isPassword() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getPassword()) != null;
        }

        @Nullable
        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        @NotNull
        public final List<Accessible> getAuxiliaryChildren() {
            List list2;
            block1: {
                ScrollAxisRange it;
                List $this$_get_auxiliaryChildren__u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                ScrollAxisRange scrollAxisRange = this.getHorizontalScroll();
                if (scrollAxisRange != null) {
                    it = scrollAxisRange;
                    boolean bl2 = false;
                    $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
                }
                ScrollAxisRange scrollAxisRange2 = this.getVerticalScroll();
                if (scrollAxisRange2 == null) break block1;
                it = scrollAxisRange2;
                boolean bl3 = false;
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list2);
        }

        @Nullable
        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        @Nullable
        public final Boolean isContainer() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsContainer());
        }

        @Nullable
        public final Boolean isTraversalGroup() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
        }

        private final Accessible makeScrollbarChild(boolean vertical) {
            ScrollBarAccessible bar = new ScrollBarAccessible(vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, ComposeAccessible.this);
            bar.getContext().getAccessibleRelationSet().add(controllerFor);
            this.getAccessibleRelationSet().add(controlledBy);
            return bar;
        }

        private final long toComposeOffset-tuRUvjQ(Point $this$toComposeOffset_u2dtuRUvjQ) {
            Density $this$toComposeOffset_tuRUvjQ_u24lambda_u243 = this.getDensity();
            boolean bl = false;
            int $this$dp$iv = $this$toComposeOffset_u2dtuRUvjQ.x;
            boolean $i$f$getDp = false;
            float f = $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv));
            $this$dp$iv = $this$toComposeOffset_u2dtuRUvjQ.y;
            $i$f$getDp = false;
            return OffsetKt.Offset(f, $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv)));
        }

        private final int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            return Float.isInfinite($this$toAwtPx_u2d0680j_4) ? Integer.MAX_VALUE : MathKt.roundToInt((float)$this$toAwtPx_u2d0680j_4);
        }

        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            boolean bl = false;
            return new Rectangle(this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getWidth())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getHeight())));
        }

        private final Point toAwtPoint-k-4lQ0M(long $this$toAwtPoint_u2dk_u2d4lQ0M) {
            Density $this$toAwtPoint_k_4lQ0M_u24lambda_u245 = this.getDensity();
            boolean bl = false;
            return new Point(this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Offset.getX-impl($this$toAwtPoint_u2dk_u2d4lQ0M))), this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Offset.getY-impl($this$toAwtPoint_u2dk_u2d4lQ0M))));
        }

        private final Dimension toAwtDimension-ozmzZPI(long $this$toAwtDimension_u2dozmzZPI) {
            Density $this$toAwtDimension_ozmzZPI_u24lambda_u246 = this.getDensity();
            boolean bl = false;
            return new Dimension(this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM(IntSize.getWidth-impl($this$toAwtDimension_u2dozmzZPI))), this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM(IntSize.getHeight-impl($this$toAwtDimension_u2dozmzZPI))));
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            AnnotatedString annotatedString = this.getText();
            return annotatedString != null ? annotatedString.toString() : null;
        }

        @Override
        @Nullable
        public String getAccessibleDescription() {
            return (String)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getContentDescription());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @Nullable
        public Accessible getAccessibleParent() {
            Accessible accessible2;
            Object object = ComposeAccessible.this.getSemanticsNode().getParent();
            if (object != null) {
                int n = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = ComposeAccessible.this;
                int id = n;
                boolean bl = false;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(id);
                Intrinsics.checkNotNull((Object)composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    accessible2 = (Accessible)object;
                    return accessible2;
                }
            }
            accessible2 = this.accessibleParent;
            return accessible2;
        }

        @Override
        @Nullable
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        @Nullable
        public AccessibleAction getAccessibleAction() {
            List actions = new ArrayList();
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getOnClick());
            if (accessibilityAction != null) {
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getDismiss());
            if (actions.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction(actions, ComposeAccessible.this){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    this.$actions = $actions;
                    this.this$0 = $receiver;
                }

                public int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                @Nullable
                public String getAccessibleActionDescription(int i) {
                    String label = (String)this.$actions.get(i).component1();
                    return label;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean doAccessibleAction(int i) {
                    SemanticsPropertyKey actionKey = (SemanticsPropertyKey)this.$actions.get(i).component2();
                    AccessibilityAction accessibilityAction = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), actionKey);
                    Object object = accessibilityAction;
                    if (accessibilityAction == null) return false;
                    AccessibilityAction it = object;
                    boolean bl = false;
                    Function0 function0 = (Function0)it.getAction();
                    if (function0 == null) return false;
                    Boolean bl2 = (Boolean)function0.invoke();
                    object = bl2;
                    if (bl2 == null) return false;
                    boolean bl3 = (Boolean)object;
                    return bl3;
                }
            };
            return this.accessibleAction;
        }

        @Override
        @Nullable
        public AccessibleValue getAccessibleValue() {
            return this.getToggleableState() != null ? (AccessibleValue)new ToggleableAccessibleValue(this) : (this.getProgressBarRangeInfo() != null ? (AccessibleValue)new ProgressBarAccessibleValue(this) : null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getAccessibleIndexInParent() {
            int n;
            block4: {
                List<SemanticsNode> parentChildren;
                SemanticsNode semanticsNode = ComposeAccessible.this.getSemanticsNode().getParent();
                List<SemanticsNode> list2 = parentChildren = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (list2 != null) {
                    void $this$indexOfFirst$iv;
                    List<SemanticsNode> list3 = list2;
                    ComposeAccessible composeAccessible = ComposeAccessible.this;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        SemanticsNode it = (SemanticsNode)item$iv;
                        boolean bl = false;
                        if (it.getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n = -1;
                } else {
                    n = -1;
                }
            }
            return n;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        @Override
        @Nullable
        public Accessible getAccessibleChild(int i) {
            List<SemanticsNode> replacedChildren = ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui();
            int replacedChildrenSize = replacedChildren.size();
            return i < replacedChildrenSize ? (Accessible)ComposeAccessible.this.controller.accessibleByNodeId(replacedChildren.get(i).getId()) : this.getAuxiliaryChildren().get(i - replacedChildrenSize);
        }

        @Override
        @NotNull
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            return locale;
        }

        @Override
        @NotNull
        public Point getLocationOnScreen() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionOnScreen-F1C5BW0());
        }

        @Override
        @NotNull
        public Point getLocation() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionInRoot-F1C5BW0());
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            return this.toAwtRectangle(ComposeAccessible.this.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        @NotNull
        public Dimension getSize() {
            return this.toAwtDimension-ozmzZPI(ComposeAccessible.this.getSemanticsNode().getSize-YbymL2g());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isVisible() {
            if (ComposeAccessible.this.getSemanticsConfig().contains(SemanticsProperties.INSTANCE.getInvisibleToUser())) return false;
            boolean bl = false;
            if (DelegatableNodeKt.requireCoordinator-64DMado(ComposeAccessible.this.getSemanticsNode().getOuterSemanticsNode$ui(), NodeKind.constructor-impl(8)).isTransparent()) return false;
            return true;
        }

        @Override
        public boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean contains(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.getBounds().contains(p);
        }

        @Override
        @Nullable
        public Accessible getAccessibleAt(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                AccessibleComponent child;
                Accessible accessible2 = this.getAccessibleChild(i);
                Object object = accessible2 != null ? accessible2.getAccessibleContext() : null;
                AccessibleComponent accessibleComponent = child = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child == null || (object = child.getAccessibleAt(p)) == null) continue;
                Object it = object;
                boolean bl = false;
                return it;
            }
            if (this.contains(p)) {
                return ComposeAccessible.this;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public void requestFocus() {
            Function0<Boolean> function0;
            AccessibilityAction<Function0<Boolean>> accessibilityAction;
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)false) && (accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus())) != null && (function0 = accessibilityAction.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)function0.invoke();
            }
        }

        @Override
        public void addFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void removeFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole;
            AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
            Role role = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            int n = Role.Companion.getButton-o7Vup1c();
            Role role2 = role;
            if (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) {
                accessibleRole = AccessibleRole.PUSH_BUTTON;
            } else {
                n = Role.Companion.getCheckbox-o7Vup1c();
                Role role3 = role;
                if (role3 == null ? false : Role.equals-impl0(role3.unbox-impl(), n)) {
                    accessibleRole = AccessibleRole.CHECK_BOX;
                } else {
                    n = Role.Companion.getRadioButton-o7Vup1c();
                    Role role4 = role;
                    if (role4 == null ? false : Role.equals-impl0(role4.unbox-impl(), n)) {
                        accessibleRole = AccessibleRole.RADIO_BUTTON;
                    } else {
                        n = Role.Companion.getTab-o7Vup1c();
                        Role role5 = role;
                        if (role5 == null ? false : Role.equals-impl0(role5.unbox-impl(), n)) {
                            accessibleRole = AccessibleRole.PAGE_TAB;
                        } else {
                            n = Role.Companion.getDropdownList-o7Vup1c();
                            Role role6 = role;
                            accessibleRole = (role6 == null ? false : Role.equals-impl0(role6.unbox-impl(), n)) ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            AccessibleRole fromSemanticRole = accessibleRole;
            AccessibleRole accessibleRole2 = fromSemanticRole;
            if (accessibleRole2 == null) {
                if (this.isPassword()) {
                    AccessibleRole accessibleRole3 = AccessibleRole.PASSWORD_TEXT;
                    accessibleRole2 = accessibleRole3;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole3, (String)"PASSWORD_TEXT");
                } else if (this.getScrollBy() != null) {
                    AccessibleRole accessibleRole4 = AccessibleRole.SCROLL_PANE;
                    accessibleRole2 = accessibleRole4;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole4, (String)"SCROLL_PANE");
                } else if (this.getSetText() != null) {
                    AccessibleRole accessibleRole5 = AccessibleRole.TEXT;
                    accessibleRole2 = accessibleRole5;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole5, (String)"TEXT");
                } else if (this.getText() != null) {
                    AccessibleRole accessibleRole6 = AccessibleRole.LABEL;
                    accessibleRole2 = accessibleRole6;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole6, (String)"LABEL");
                } else if (this.getProgressBarRangeInfo() != null) {
                    AccessibleRole accessibleRole7 = AccessibleRole.PROGRESS_BAR;
                    accessibleRole2 = accessibleRole7;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole7, (String)"PROGRESS_BAR");
                } else if (this.isContainer() != null) {
                    AccessibleRole accessibleRole8 = AccessibleRole.GROUP_BOX;
                    accessibleRole2 = accessibleRole8;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole8, (String)"GROUP_BOX");
                } else if (this.isTraversalGroup() != null) {
                    AccessibleRole accessibleRole9 = AccessibleRole.GROUP_BOX;
                    accessibleRole2 = accessibleRole9;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole9, (String)"GROUP_BOX");
                } else {
                    AccessibleRole accessibleRole10 = AccessibleRole.UNKNOWN;
                    accessibleRole2 = accessibleRole10;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole10, (String)"UNKNOWN");
                }
            }
            return accessibleRole2;
        }

        @Override
        @NotNull
        public AccessibleStateSet getAccessibleStateSet() {
            boolean canCollapse;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            ComposeAccessible composeAccessible = ComposeAccessible.this;
            AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u2412 = accessibleStateSet;
            boolean bl = false;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)true)) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSED);
            }
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.CHECKED);
                    break;
                }
                case 2: {
                    $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.INDETERMINATE);
                }
            }
            boolean canExpand = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getExpand()) != null;
            boolean bl2 = canCollapse = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            if (this.getSelected() != null) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTABLE);
            }
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)true)) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        @Nullable
        public AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        @Override
        @Nullable
        public AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText2 = this.getAccessibleText();
            return accessibleText2 instanceof AccessibleEditableText ? (AccessibleEditableText)((Object)accessibleText2) : null;
        }

        @Override
        public void setBounds(@Nullable Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setSize(@Nullable Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setLocation(@Nullable Point p) {
            System.out.println((Object)"Not implemented: setLocation");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setBackground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setForeground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setCursor(@Nullable Cursor cursor2) {
            System.out.println((Object)"Not implemented: setCursor");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setFont(@Nullable Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public FontMetrics getFontMetrics(@Nullable Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setEnabled(boolean b) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setVisible(boolean b) {
            System.out.println((Object)"Not implemented: setVisible");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.getAccessibleActionCount() : 0;
        }

        @Override
        @NotNull
        public String getAccessibleActionDescription(int i) {
            AccessibleAction accessibleAction = this.accessibleAction;
            String string2 = accessibleAction != null ? accessibleAction.getAccessibleActionDescription(i) : null;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.doAccessibleAction(i) : false;
        }

        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
            block0: {
                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this$0.getSemanticsConfig(), key);
                if (accessibilityAction == null) break block0;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions.add((Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>)new Pair((Object)it.getLabel(), key));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/AccessibleEditableText;", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "cut", "", "startIndex", "", "endIndex", "delete", "getTextRange", "", "insertTextAtIndex", "index", "s", "paste", "replaceText", "selectText", "setAttributes", "as", "Ljavax/swing/text/AttributeSet;", "setTextContents", "ui"})
        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,884:1\n1241#2:885\n1241#2:886\n1241#2:887\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n688#1:885\n703#1:886\n721#1:887\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            @Override
            public void setTextContents(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString(s, null, null, 6, null));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void insertTextAtIndex(int index2, @NotNull String s) {
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(0, index2));
                $this$insertTextAtIndex_u24lambda_u240.append(s);
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(index2, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return ((Object)((CharSequence)annotatedString).subSequence(startIndex, endIndex)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void delete(int startIndex, int endIndex) {
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$delete_u24lambda_u241.append(text.subSequence(0, startIndex));
                $this$delete_u24lambda_u241.append(text.subSequence(endIndex, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void cut(int startIndex, int endIndex) {
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            public void paste(int startIndex) {
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void replaceText(int startIndex, int endIndex, @NotNull String s) {
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$replaceText_u24lambda_u242.append(text.subSequence(0, startIndex));
                $this$replaceText_u24lambda_u242.append(s);
                $this$replaceText_u24lambda_u242.append(text.subSequence(endIndex, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void selectText(int startIndex, int endIndex) {
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetSelection();
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)startIndex, (Object)endIndex, (Object)false);
            }

            @Override
            public void setAttributes(int startIndex, int endIndex, @Nullable AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\""}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "getAfterIndex", "", "part", "", "index", "getAtIndex", "getBeforeIndex", "getCaretPosition", "getCharCount", "getCharacterAttribute", "Ljavax/swing/text/AttributeSet;", "i", "getCharacterBounds", "Ljava/awt/Rectangle;", "getIndexAtPoint", "p", "Ljava/awt/Point;", "getSelectedText", "getSelectionEnd", "getSelectionStart", "getTextBounds", "startIndex", "endIndex", "getTextRange", "getTextSequenceAfter", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAt", "getTextSequenceBefore", "partToBreakIterator", "Lorg/jetbrains/skia/BreakIterator;", "ui"})
        public class ComposeAccessibleText
        implements AccessibleText,
        AccessibleExtendedText {
            @Override
            public int getIndexAtPoint(@NotNull Point p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.this.toComposeOffset-tuRUvjQ(p));
            }

            @Override
            @NotNull
            public Rectangle getCharacterBounds(int i) {
                block3: {
                    block2: {
                        if (i < 0) break block2;
                        AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        if (i < annotatedString.length()) break block3;
                    }
                    return new Rectangle((int)((float)ComposeAccessibleComponent.this.getLocation().x / ComposeAccessibleComponent.this.getDensity().getDensity()), (int)((float)ComposeAccessibleComponent.this.getLocation().y / ComposeAccessibleComponent.this.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.this.toAwtRectangle(textLayoutResult.getBoundingBox(i));
            }

            @Override
            public int getCharCount() {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange2 = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange2 != null ? TextRange.getStart-impl(textRange2.unbox-impl()) : -1;
            }

            private final BreakIterator partToBreakIterator(int part) {
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                iter.setText(annotatedString.toString());
                return iter;
            }

            @Override
            @NotNull
            public String getAtIndex(int part, int index2) {
                String string2;
                int end2 = this.partToBreakIterator(part).following(index2);
                if (end2 == -1) {
                    string2 = "";
                } else {
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    string2 = annotatedString.subSequence(index2, end2).toString();
                }
                return string2;
            }

            @Override
            @NotNull
            public String getAfterIndex(int part, int index2) {
                BreakIterator iterator2 = this.partToBreakIterator(part);
                int start = index2;
                while (true) {
                    if ((start = iterator2.following(start)) == -1) {
                        return "";
                    }
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    if (annotatedString.charAt(start) == ' ') continue;
                    AnnotatedString annotatedString2 = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString2);
                    if (annotatedString2.charAt(start) != '\n') break;
                }
                int end2 = iterator2.next();
                int end3 = end2 == -1 ? iterator2.last() : end2;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence(start, end3).toString();
            }

            @Override
            @NotNull
            public String getBeforeIndex(int part, int index2) {
                String string2;
                int start = this.partToBreakIterator(part).preceding(index2);
                if (start == -1) {
                    string2 = "";
                } else {
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    string2 = annotatedString.subSequence(start, index2).toString();
                }
                return string2;
            }

            @Override
            @NotNull
            public AttributeSet getCharacterAttribute(int i) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange2 = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange2 != null ? TextRange.getStart-impl(textRange2.unbox-impl()) : 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange2 = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange2 != null ? TextRange.getEnd-impl(textRange2.unbox-impl()) : 0;
            }

            @Override
            @NotNull
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        object = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange2 = object;
                        ComposeAccessibleComponent composeAccessibleComponent = ComposeAccessibleComponent.this;
                        long selection = textRange2.unbox-impl();
                        boolean bl = false;
                        AnnotatedString annotatedString = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        String string2 = annotatedString.subSequence(TextRange.getStart-impl(selection), TextRange.getEnd-impl(selection)).toString();
                        object = string2;
                        if (string2 != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence(startIndex, endIndex).toString();
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAt(int part, int index2) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAfter(int part, int index2) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceBefore(int part, int index2) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            @NotNull
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ScrollBarAccessible;", "Ljavax/accessibility/Accessible;", "vertical", "", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;Z)V", "context", "Ljavax/accessibility/AccessibleContext;", "getContext", "()Ljavax/accessibility/AccessibleContext;", "getVertical", "()Z", "getAccessibleContext", "ui"})
        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            @NotNull
            private final AccessibleContext context;

            public ScrollBarAccessible(boolean vertical) {
                this.vertical = vertical;
                this.context = (AccessibleContext)((Object)new AccessibleValue(this, ComposeAccessibleComponent.this, ComposeAccessible.this){
                    @NotNull
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = $receiver3;
                        if ($receiver.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = $receiver2.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull((Object)scrollAxisRange2);
                        } else {
                            ScrollAxisRange scrollAxisRange3 = $receiver2.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull((Object)scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    @NotNull
                    public AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    @NotNull
                    public AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_BAR");
                        return accessibleRole;
                    }

                    @NotNull
                    public AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        boolean bl = false;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        if (scrollBarAccessible.getVertical()) {
                            $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL);
                        } else {
                            $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.HORIZONTAL);
                        }
                        return accessibleStateSet;
                    }

                    @NotNull
                    public Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public int getAccessibleChildrenCount() {
                        return 0;
                    }

                    @Nullable
                    public Accessible getAccessibleChild(int i) {
                        return null;
                    }

                    @NotNull
                    public Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        return locale;
                    }

                    @NotNull
                    public Number getCurrentAccessibleValue() {
                        return (Number)this.range.getValue().invoke();
                    }

                    public boolean setCurrentAccessibleValue(@Nullable Number n) {
                        boolean bl;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            bl = (Boolean)function2.invoke((Object)f, (Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        } else {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            bl = (Boolean)function2.invoke((Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                        }
                        return bl;
                    }

                    @NotNull
                    public Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    @NotNull
                    public Number getMaximumAccessibleValue() {
                        return (Number)this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            @NotNull
            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            @NotNull
            public AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

