/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.ExperimentalAnimationSpecApi;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ8\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001cJ \u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0003J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J8\u0010 \u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J#\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006%"}, d2={"Landroidx/compose/animation/core/MonoSpline;", "", "time", "", "y", "", "periodicBias", "", "([F[[FF)V", "isExtrapolate", "", "slopeTemp", "tangents", "[[F", "timePoints", "values", "diff", "h", "x", "y1", "y2", "t1", "t2", "getPos", "", "v", "Landroidx/compose/animation/core/AnimationVector;", "index", "", "t", "j", "getSlope", "interpolate", "makeFloatArray", "a", "b", "(II)[[F", "animation-core"})
@ExperimentalAnimationSpecApi
@StabilityInferred(parameters=0)
public final class MonoSpline {
    @NotNull
    private final float[] timePoints;
    @NotNull
    private final float[][] values;
    @NotNull
    private final float[][] tangents;
    private final boolean isExtrapolate;
    @NotNull
    private final float[] slopeTemp;
    public static final int $stable = 8;

    public MonoSpline(@NotNull float[] time, @NotNull float[][] y, float periodicBias) {
        int j;
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.isExtrapolate = true;
        int n = time.length;
        int dim = y[0].length;
        this.slopeTemp = new float[dim];
        float[][] slope = this.makeFloatArray(n - 1, dim);
        float[][] tangent = this.makeFloatArray(n, dim);
        for (j = 0; j < dim; ++j) {
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                float dt = time[i + 1] - time[i];
                slope[i][j] = (y[i + 1][j] - y[i][j]) / dt;
                tangent[i][j] = i == 0 ? slope[i][j] : (slope[i - 1][j] + slope[i][j]) * 0.5f;
            }
            tangent[n - 1][j] = slope[n - 2][j];
        }
        if (!Float.isNaN(periodicBias)) {
            for (j = 0; j < dim; ++j) {
                float adjustedSlope;
                slope[0][j] = adjustedSlope = slope[n - 2][j] * (1.0f - periodicBias) + slope[0][j] * periodicBias;
                slope[n - 2][j] = adjustedSlope;
                tangent[n - 1][j] = adjustedSlope;
                tangent[0][j] = adjustedSlope;
            }
        }
        int n3 = n - 1;
        for (int i = 0; i < n3; ++i) {
            for (int j2 = 0; j2 < dim; ++j2) {
                if (slope[i][j2] == 0.0f) {
                    tangent[i][j2] = 0.0f;
                    tangent[i + 1][j2] = 0.0f;
                    continue;
                }
                float a = tangent[i][j2] / slope[i][j2];
                float b = tangent[i + 1][j2] / slope[i][j2];
                float h = (float)Math.hypot(a, b);
                if (!((double)h > 9.0)) continue;
                float t = 3.0f / h;
                tangent[i][j2] = t * a * slope[i][j2];
                tangent[i + 1][j2] = t * b * slope[i][j2];
            }
        }
        this.timePoints = time;
        this.values = y;
        this.tangents = tangent;
    }

    private final float[][] makeFloatArray(int a, int b) {
        int n = 0;
        float[][] fArrayArray = new float[a][];
        while (n < a) {
            int n2 = n++;
            fArrayArray[n2] = new float[b];
        }
        return fArrayArray;
    }

    public final float getPos(float t, int j) {
        int n = this.timePoints.length;
        if (this.isExtrapolate) {
            if (t <= this.timePoints[0]) {
                return this.values[0][j] + (t - this.timePoints[0]) * this.getSlope(this.timePoints[0], j);
            }
            if (t >= this.timePoints[n - 1]) {
                return this.values[n - 1][j] + (t - this.timePoints[n - 1]) * this.getSlope(this.timePoints[n - 1], j);
            }
        } else {
            if (t <= this.timePoints[0]) {
                return this.values[0][j];
            }
            if (t >= this.timePoints[n - 1]) {
                return this.values[n - 1][j];
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.timePoints[i]) {
                return this.values[i][j];
            }
            if (!(t < this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            float y1 = this.values[i][j];
            float y2 = this.values[i + 1][j];
            float t1 = this.tangents[i][j];
            float t2 = this.tangents[i + 1][j];
            return this.interpolate(h, x, y1, y2, t1, t2);
        }
        return 0.0f;
    }

    public final void getPos(float time, @NotNull AnimationVector v, int index2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = this.timePoints.length;
        int dim = this.values[0].length;
        if (this.isExtrapolate) {
            if (time <= this.timePoints[0]) {
                this.getSlope(this.timePoints[0], this.slopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core(j, this.values[0][j] + (time - this.timePoints[0]) * this.slopeTemp[j]);
                }
                return;
            }
            if (time >= this.timePoints[n - 1]) {
                this.getSlope(this.timePoints[n - 1], this.slopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core(j, this.values[n - 1][j] + (time - this.timePoints[n - 1]) * this.slopeTemp[j]);
                }
                return;
            }
        } else {
            if (time <= this.timePoints[0]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core(j, this.values[0][j]);
                }
                return;
            }
            if (time >= this.timePoints[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core(j, this.values[n - 1][j]);
                }
                return;
            }
        }
        int n2 = n - 1;
        for (int i = index2; i < n2; ++i) {
            if (time == this.timePoints[i]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core(j, this.values[i][j]);
                }
            }
            if (!(time < this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (time - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values[i][j];
                float y2 = this.values[i + 1][j];
                float t1 = this.tangents[i][j];
                float t2 = this.tangents[i + 1][j];
                v.set$animation_core(j, this.interpolate(h, x, y1, y2, t1, t2));
            }
            return;
        }
    }

    public static /* synthetic */ void getPos$default(MonoSpline monoSpline, float f, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getPos(f, animationVector, n);
    }

    public final void getSlope(float time, @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float t = time;
        int n = this.timePoints.length;
        int dim = this.values[0].length;
        if (t <= this.timePoints[0]) {
            t = this.timePoints[0];
        } else if (t >= this.timePoints[n - 1]) {
            t = this.timePoints[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t <= this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values[i][j];
                float y2 = this.values[i + 1][j];
                float t1 = this.tangents[i][j];
                float t2 = this.tangents[i + 1][j];
                v[j] = this.diff(h, x, y1, y2, t1, t2) / h;
            }
            break;
        }
    }

    public final void getSlope(float time, @NotNull AnimationVector v, int index2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float t = time;
        int n = this.timePoints.length;
        int dim = this.values[0].length;
        if (t <= this.timePoints[0]) {
            for (int j = 0; j < dim; ++j) {
                v.set$animation_core(j, this.tangents[0][j]);
            }
            return;
        }
        if (t >= this.timePoints[n - 1]) {
            for (int j = 0; j < dim; ++j) {
                v.set$animation_core(j, this.tangents[n - 1][j]);
            }
            return;
        }
        int n2 = n - 1;
        for (int i = index2; i < n2; ++i) {
            if (!(t <= this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values[i][j];
                float y2 = this.values[i + 1][j];
                float t1 = this.tangents[i][j];
                float t2 = this.tangents[i + 1][j];
                v.set$animation_core(j, this.diff(h, x, y1, y2, t1, t2) / h);
            }
            break;
        }
    }

    public static /* synthetic */ void getSlope$default(MonoSpline monoSpline, float f, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getSlope(f, animationVector, n);
    }

    private final float getSlope(float time, int j) {
        float t = time;
        int n = this.timePoints.length;
        if (t < this.timePoints[0]) {
            t = this.timePoints[0];
        } else if (t >= this.timePoints[n - 1]) {
            t = this.timePoints[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t <= this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            float y1 = this.values[i][j];
            float y2 = this.values[i + 1][j];
            float t1 = this.tangents[i][j];
            float t2 = this.tangents[i + 1][j];
            return this.diff(h, x, y1, y2, t1, t2) / h;
        }
        return 0.0f;
    }

    private final float interpolate(float h, float x, float y1, float y2, float t1, float t2) {
        float x2 = x * x;
        float x3 = x2 * x;
        return (float)-2 * x3 * y2 + (float)3 * x2 * y2 + (float)2 * x3 * y1 - (float)3 * x2 * y1 + y1 + h * t2 * x3 + h * t1 * x3 - h * t2 * x2 - (float)2 * h * t1 * x2 + h * t1 * x;
    }

    private final float diff(float h, float x, float y1, float y2, float t1, float t2) {
        float x2 = x * x;
        return (float)-6 * x2 * y2 + (float)6 * x * y2 + (float)6 * x2 * y1 - (float)6 * x * y1 + (float)3 * h * t2 * x2 + (float)3 * h * t1 * x2 - (float)2 * h * t2 * x - (float)4 * h * t1 * x + h * t1;
    }
}

