/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.junit.Assert;

public class EditorMouseFixture {
    private final EditorImpl myEditor;
    private int myX;
    private int myY;
    private int myModifiers;
    private int myButton = 1;
    private int myLastId;
    private int myLastClickCount;
    private Component myLastComponent;

    public EditorMouseFixture(EditorImpl editor2) {
        this.myEditor = editor2;
    }

    public EditorMouseFixture pressAtXY(int x, int y) {
        return this.pressAt(1, new Point(x, y));
    }

    public EditorMouseFixture pressAt(int visualLine, int visualColumn) {
        return this.pressAt(1, this.getPoint(visualLine, visualColumn));
    }

    public EditorMouseFixture pressAtLineNumbers(int visualLine) {
        assert (this.myEditor.getSettings().isLineNumbersShown());
        return this.pressAt((Component)this.myEditor.getGutterComponentEx(), 1, new Point(0, this.myEditor.visualLineToY(visualLine)));
    }

    private EditorMouseFixture pressAt(int clickCount, Point p) {
        EditorComponentImpl component = this.myEditor.getContentComponent();
        return this.pressAt((Component)component, clickCount, p);
    }

    private EditorMouseFixture pressAt(Component component, int clickCount, Point p) {
        this.myLastComponent = component;
        this.myLastId = 501;
        this.myX = p.x;
        this.myY = p.y;
        this.myLastClickCount = clickCount;
        component.dispatchEvent(new MouseEvent(this.myLastComponent, 501, System.currentTimeMillis(), this.myModifiers | EditorMouseFixture.getModifiersForButtonPress(this.myButton), this.myX, this.myY, this.myLastClickCount, false, this.myButton));
        return this;
    }

    public EditorMouseFixture release() {
        int oldLastId = this.myLastId;
        int clickCount = this.myLastId == 501 ? this.myLastClickCount : 0;
        this.myLastId = 502;
        this.myLastClickCount = clickCount;
        this.myLastComponent.dispatchEvent(new MouseEvent(this.myLastComponent, 502, System.currentTimeMillis(), this.myModifiers | EditorMouseFixture.getModifiersForButtonRelease(this.myButton), this.myX, this.myY, this.myLastClickCount, this.myButton == 3, this.myButton));
        if (oldLastId == 501) {
            this.myLastId = 500;
            this.myLastComponent.dispatchEvent(new MouseEvent(this.myLastComponent, 500, System.currentTimeMillis(), this.myModifiers | EditorMouseFixture.getModifiersForButtonRelease(this.myButton), this.myX, this.myY, clickCount, false, this.myButton));
        }
        this.myLastComponent = null;
        return this;
    }

    public EditorMouseFixture clickAtXY(int x, int y) {
        return this.pressAtXY(x, y).release();
    }

    public EditorMouseFixture clickAt(int visualLine, int visualColumn) {
        return this.pressAt(visualLine, visualColumn).release();
    }

    public EditorMouseFixture doubleClickAt(int visualLine, int visualColumn) {
        return this.doubleClickNoReleaseAt(visualLine, visualColumn).release();
    }

    public EditorMouseFixture doubleClickNoReleaseAt(int visualLine, int visualColumn) {
        return this.clickAt(visualLine, visualColumn).pressAt(2, this.getPoint(visualLine, visualColumn));
    }

    public EditorMouseFixture tripleClickAt(int visualLine, int visualColumn) {
        return this.doubleClickAt(visualLine, visualColumn).pressAt(3, this.getPoint(visualLine, visualColumn)).release();
    }

    public EditorMouseFixture moveTo(int visualLine, int visualColumn) {
        Point p = this.getPoint(visualLine, visualColumn);
        return this.moveToXY(p.x, p.y);
    }

    public EditorMouseFixture dragTo(int visualLine, int visualColumn) {
        Point p = this.getPoint(visualLine, visualColumn);
        return this.dragToXY(p.x, p.y);
    }

    public EditorMouseFixture dragToLineNumbers(int visualLine) {
        assert (this.myEditor.getSettings().isLineNumbersShown());
        return this.dragToXY((JComponent)this.myEditor.getGutterComponentEx(), 0, this.myEditor.visualLineToY(visualLine));
    }

    public EditorMouseFixture moveToXY(int x, int y) {
        EditorComponentImpl component = this.myEditor.getContentComponent();
        this.myLastId = 503;
        this.myX = x;
        this.myY = y;
        this.myLastClickCount = 0;
        component.dispatchEvent(new MouseEvent((Component)component, 503, System.currentTimeMillis(), this.myModifiers, this.myX, this.myY, 0, false, 0));
        return this;
    }

    public EditorMouseFixture dragToXY(int x, int y) {
        Assert.assertFalse((String)"Cannot test mouse dragging: editor visible size is not set. Use EditorTestUtil.setEditorVisibleSize(width, height)", (boolean)this.myEditor.getScrollingModel().getVisibleArea().isEmpty());
        EditorComponentImpl component = this.myEditor.getContentComponent();
        return this.dragToXY((JComponent)component, x, y);
    }

    private EditorMouseFixture dragToXY(JComponent component, int x, int y) {
        this.myLastId = 506;
        this.myX = x;
        this.myY = y;
        this.myLastClickCount = 1;
        component.dispatchEvent(new MouseEvent(component, 506, System.currentTimeMillis(), this.myModifiers | EditorMouseFixture.getModifiersForButtonPress(this.myButton), this.myX, this.myY, 1, false, 0));
        return this;
    }

    public EditorMouseFixture ctrl() {
        this.myModifiers |= SystemInfo.isMac ? 256 : 128;
        return this;
    }

    public EditorMouseFixture alt() {
        this.myModifiers |= 0x200;
        return this;
    }

    public EditorMouseFixture shift() {
        this.myModifiers |= 0x40;
        return this;
    }

    public EditorMouseFixture noModifiers() {
        this.myModifiers = 0;
        return this;
    }

    public EditorMouseFixture middle() {
        this.myButton = 2;
        return this;
    }

    public EditorMouseFixture right() {
        this.myButton = 3;
        return this;
    }

    private Point getPoint(int visualLine, int visualColumn) {
        return this.myEditor.visualPositionToXY(new VisualPosition(visualLine, visualColumn));
    }

    private static int getModifiersForButtonPress(int button) {
        return switch (button) {
            case 1 -> 1024;
            case 2 -> 2048;
            case 3 -> 4096;
            default -> 0;
        };
    }

    private static int getModifiersForButtonRelease(int button) {
        return switch (button) {
            case 2 -> 512;
            case 3 -> 256;
            default -> 0;
        };
    }
}

