/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dvcs/push/ui/PushLogTreeModel;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleAsyncChangesTreeModel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "commitNodes", "", "Lcom/intellij/dvcs/push/ui/CommitNode;", "getCommitNodes", "()Ljava/util/List;", "setCommitNodes", "(Ljava/util/List;)V", "buildTreeModelSync", "Ljavax/swing/tree/DefaultTreeModel;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "intellij.platform.vcs.dvcs.impl"})
public final class PushLogTreeModel
extends SimpleAsyncChangesTreeModel {
    @NotNull
    private final Project project;
    @NotNull
    private volatile List<? extends CommitNode> commitNodes;

    public PushLogTreeModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.commitNodes = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<CommitNode> getCommitNodes() {
        return this.commitNodes;
    }

    public final void setCommitNodes(@NotNull List<? extends CommitNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.commitNodes = list;
    }

    @NotNull
    public DefaultTreeModel buildTreeModelSync(@NotNull ChangesGroupingPolicyFactory grouping) {
        Intrinsics.checkNotNullParameter((Object)grouping, (String)"grouping");
        List<Change> list = PushLog.collectAllChanges(this.commitNodes);
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectAllChanges(...)");
        List<Change> currentChanges = list;
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges((Project)this.project, (ChangesGroupingPolicyFactory)grouping, (Collection)currentChanges, null);
        Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"buildFromChanges(...)");
        return defaultTreeModel;
    }
}

