/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tH\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\fH\u0002R<\u0010\u0004\u001a.\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\t\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsLogFilterModel;", "Lcom/intellij/diagnostic/logging/LogFilterModel;", "<init>", "()V", "listeners", "", "Lcom/intellij/diagnostic/logging/LogFilterListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "Ljava/util/List;", "customFilter", "", "getCustomFilter", "addFilterListener", "", "listener", "removeFilterListener", "getLogFilters", "Lcom/intellij/diagnostic/logging/LogFilter;", "isFilterSelected", "", "filter", "selectFilter", "updateCustomFilter", "processLine", "Lcom/intellij/diagnostic/logging/LogFilterModel$MyProcessingResult;", "line", "defineContentType", "Lcom/intellij/execution/process/ProcessOutputType;", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nStatisticsLogFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsLogFilterModel.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsLogFilterModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1755#2,3:54\n1755#2,3:57\n*S KotlinDebug\n*F\n+ 1 StatisticsLogFilterModel.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsLogFilterModel\n*L\n47#1:54,3\n48#1:57,3\n*E\n"})
public final class StatisticsLogFilterModel
extends LogFilterModel {
    @NotNull
    private final List<LogFilterListener> listeners;
    @Nullable
    private String customFilter;

    public StatisticsLogFilterModel() {
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list;
    }

    @Nullable
    public String getCustomFilter() {
        return this.customFilter;
    }

    public void addFilterListener(@Nullable LogFilterListener listener) {
        this.listeners.add(listener);
    }

    public void removeFilterListener(@Nullable LogFilterListener listener) {
        this.listeners.remove(listener);
    }

    @NotNull
    public List<LogFilter> getLogFilters() {
        return CollectionsKt.emptyList();
    }

    public boolean isFilterSelected(@Nullable LogFilter filter2) {
        return false;
    }

    public void selectFilter(@Nullable LogFilter filter2) {
    }

    public void updateCustomFilter(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        super.updateCustomFilter(filter2);
        this.customFilter = filter2;
        for (LogFilterListener listener : this.listeners) {
            listener.onTextFilterChange();
        }
    }

    @NotNull
    public LogFilterModel.MyProcessingResult processLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        ProcessOutputType contentType = this.defineContentType(line);
        boolean applicable = this.isApplicable(line);
        return new LogFilterModel.MyProcessingResult((Key)contentType, applicable, null);
    }

    private final ProcessOutputType defineContentType(String line) {
        ProcessOutputType processOutputType;
        Object it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block10: {
            $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ValidationResultType)element$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = line;
                    String string = it.getDescription();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            ProcessOutputType processOutputType2 = ProcessOutputType.STDERR;
            processOutputType = processOutputType2;
            Intrinsics.checkNotNullExpressionValue((Object)processOutputType2, (String)"STDERR");
        } else {
            boolean bl3;
            block11: {
                $this$any$iv = StatisticsEventLogToolWindow.Companion.getAlertEvents();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl4 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)((CharSequence)it), (boolean)false, (int)2, null)) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                ProcessOutputType processOutputType3 = ProcessOutputType.STDERR;
                processOutputType = processOutputType3;
                Intrinsics.checkNotNullExpressionValue((Object)processOutputType3, (String)"STDERR");
            } else {
                ProcessOutputType processOutputType4 = ProcessOutputType.STDOUT;
                processOutputType = processOutputType4;
                Intrinsics.checkNotNullExpressionValue((Object)processOutputType4, (String)"STDOUT");
            }
        }
        return processOutputType;
    }
}

