/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SerializablePersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.configuration.TextMatePersistentBundle;
import org.jetbrains.plugins.textmate.configuration.TextMateUserBundleServiceState;

@State(name="TextMateUserBundlesSettings", storages={@Storage(value="textmate.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0007R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings;", "Lcom/intellij/openapi/components/SerializablePersistentStateComponent;", "Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundleServiceState;", "<init>", "()V", "bundles", "", "", "Lorg/jetbrains/plugins/textmate/configuration/TextMatePersistentBundle;", "getBundles", "()Ljava/util/Map;", "setBundlesConfig", "", "addBundle", "path", "name", "removeBundle", "disableBundle", "hasEnabledBundle", "", "Companion", "intellij.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateUserBundlesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateUserBundlesSettings.kt\norg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings\n+ 2 SerializablePersistentStateComponent.kt\ncom/intellij/openapi/components/SerializablePersistentStateComponent\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n63#2,6:67\n70#2,4:79\n63#2,11:84\n63#2,6:96\n70#2,4:109\n63#2,11:114\n477#3:73\n423#3:74\n535#3:102\n520#3,6:103\n1246#4,4:75\n1#5:83\n1#5:95\n1#5:113\n1#5:125\n*S KotlinDebug\n*F\n+ 1 TextMateUserBundlesSettings.kt\norg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings\n*L\n20#1:67,6\n20#1:79,4\n27#1:84,11\n34#1:96,6\n34#1:109,4\n41#1:114,11\n21#1:73\n21#1:74\n35#1:102\n35#1:103,6\n21#1:75,4\n20#1:83\n27#1:95\n34#1:113\n41#1:125\n*E\n"})
public final class TextMateUserBundlesSettings
extends SerializablePersistentStateComponent<TextMateUserBundleServiceState> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TextMateUserBundlesSettings() {
        super((Object)new TextMateUserBundleServiceState(null, 1, null));
    }

    @NotNull
    public final Map<String, TextMatePersistentBundle> getBundles() {
        return ((TextMateUserBundleServiceState)this.getState()).bundles;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBundlesConfig(@NotNull Map<String, TextMatePersistentBundle> bundles) {
        Intrinsics.checkNotNullParameter(bundles, (String)"bundles");
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        boolean haveNext$iv = false;
        while (true) {
            void it$iv;
            Object object;
            if (!haveNext$iv) {
                void $this$mapKeysTo$iv$iv;
                TextMateUserBundleServiceState it = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                Map<String, TextMatePersistentBundle> $this$mapKeys$iv = bundles;
                boolean $i$f$mapKeys = false;
                Map<String, TextMatePersistentBundle> map = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    String string;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl2 = false;
                    String path = (String)entry.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)path), (String)"toSystemIndependentName(...)");
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map3 = map2;
                    boolean bl3 = false;
                    entry = it$iv$iv.getValue();
                    map3.put(string, entry);
                }
                Map map4 = destination$iv$iv;
                next$iv = new TextMateUserBundleServiceState(map4);
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            haveNext$iv = object3 == object;
        }
        Intrinsics.checkNotNull(next$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBundle(@NotNull String path, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        boolean haveNext$iv = false;
        while (true) {
            void it$iv;
            Object object;
            if (!haveNext$iv) {
                TextMateUserBundleServiceState state = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                next$iv = new TextMateUserBundleServiceState(MapsKt.plus(state.bundles, (Pair)TuplesKt.to((Object)normalizedPath, (Object)new TextMatePersistentBundle(name, true))));
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            haveNext$iv = object3 == object;
        }
        Intrinsics.checkNotNull(next$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBundle(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        boolean haveNext$iv = false;
        while (true) {
            void it$iv;
            Object object;
            if (!haveNext$iv) {
                void $this$filterTo$iv$iv;
                TextMateUserBundleServiceState state = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                Map<String, TextMatePersistentBundle> $this$filter$iv = state.bundles;
                boolean $i$f$filter = false;
                Map<String, TextMatePersistentBundle> map = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it.getKey(), (Object)normalizedPath))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map map2 = destination$iv$iv;
                next$iv = new TextMateUserBundleServiceState(map2);
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            haveNext$iv = object3 == object;
        }
        Intrinsics.checkNotNull(next$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void disableBundle(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        boolean haveNext$iv = false;
        while (true) {
            void it$iv;
            Object object;
            if (!haveNext$iv) {
                TextMateUserBundleServiceState state = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                if (state.bundles.get(normalizedPath) != null) {
                    TextMatePersistentBundle bundle;
                    boolean bl2 = false;
                    v1 = new TextMateUserBundleServiceState(MapsKt.plus(state.bundles, (Pair)TuplesKt.to((Object)normalizedPath, (Object)TextMatePersistentBundle.copy$default(bundle, null, false, 1, null))));
                } else {
                    v1 = next$iv = state;
                }
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            haveNext$iv = object3 == object;
        }
        Intrinsics.checkNotNull(next$iv);
    }

    public final boolean hasEnabledBundle(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        TextMatePersistentBundle textMatePersistentBundle = this.getBundles().get(normalizedPath);
        return textMatePersistentBundle != null ? textMatePersistentBundle.getEnabled() : false;
    }

    @JvmStatic
    @Nullable
    public static final TextMateUserBundlesSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings;", "intellij.textmate"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final TextMateUserBundlesSettings getInstance() {
            return (TextMateUserBundlesSettings)((Object)ApplicationManager.getApplication().getService(TextMateUserBundlesSettings.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

