/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.tree;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegateWithContextMenu;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitIncomingOutgoingStateKt;
import git4idea.branch.GitTagType;
import git4idea.branch.IncomingOutgoingState;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.tree.GitBranchesTreeModel;
import git4idea.ui.branch.tree.GitBranchesTreeRenderer;
import git4idea.ui.branch.tree.GitBranchesWithDetailsTreeRendererKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001/B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H&JL\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0016J\u0019\u0010%\u001a\t\u0018\u00010&\u00a2\u0006\u0002\b'2\b\u0010(\u001a\u0004\u0018\u00010\u0018H\u0002J\u001c\u0010)\u001a\u0004\u0018\u00010**\u00020+2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u0012\u0010,\u001a\u00020-2\b\u0010(\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020+H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lgit4idea/ui/branch/tree/GitBranchesWithDetailsTreeRenderer;", "Lgit4idea/ui/branch/tree/GitBranchesTreeRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "treeModel", "Lgit4idea/ui/branch/tree/GitBranchesTreeModel;", "selectedRepository", "Lgit4idea/repo/GitRepository;", "repositories", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/tree/GitBranchesTreeModel;Lgit4idea/repo/GitRepository;Ljava/util/List;)V", "secondaryLabel", "Ljavax/swing/JLabel;", "arrowLabel", "incomingLabel", "outgoingLabel", "mainPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getMainPanel", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "hasRightArrow", "", "nodeUserObject", "", "configureTreeCellComponent", "", "tree", "Ljavax/swing/JTree;", "userObject", "value", "selected", "expanded", "leaf", "row", "", "hasFocus", "getSecondaryText", "", "Lcom/intellij/openapi/util/NlsSafe;", "treeNode", "getCommonTrackedBranch", "Lgit4idea/GitRemoteBranch;", "Lgit4idea/GitLocalBranch;", "getIncomingOutgoingState", "Lgit4idea/branch/IncomingOutgoingState;", "branch", "MyMainPanel", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchesWithDetailsTreeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesWithDetailsTreeRenderer.kt\ngit4idea/ui/branch/tree/GitBranchesWithDetailsTreeRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1755#2,3:238\n*S KotlinDebug\n*F\n+ 1 GitBranchesWithDetailsTreeRenderer.kt\ngit4idea/ui/branch/tree/GitBranchesWithDetailsTreeRenderer\n*L\n112#1:238,3\n*E\n"})
public abstract class GitBranchesWithDetailsTreeRenderer
extends GitBranchesTreeRenderer {
    @NotNull
    private final JLabel secondaryLabel;
    @NotNull
    private final JLabel arrowLabel;
    @NotNull
    private final JLabel incomingLabel;
    @NotNull
    private final JLabel outgoingLabel;
    @NotNull
    private final BorderLayoutPanel mainPanel;

    /*
     * WARNING - void declaration
     */
    public GitBranchesWithDetailsTreeRenderer(@NotNull Project project, @NotNull GitBranchesTreeModel treeModel, @Nullable GitRepository selectedRepository, @NotNull List<? extends GitRepository> repositories) {
        void $this$outgoingLabel_u24lambda_u243;
        JLabel $this$incomingLabel_u24lambda_u242;
        JLabel $this$arrowLabel_u24lambda_u241;
        JLabel $this$secondaryLabel_u24lambda_u240;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)treeModel), (String)"treeModel");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        super(project, treeModel, selectedRepository, repositories, false, 16, null);
        JLabel jLabel2 = jLabel = new JLabel();
        GitBranchesWithDetailsTreeRenderer gitBranchesWithDetailsTreeRenderer = this;
        boolean bl = false;
        $this$secondaryLabel_u24lambda_u240.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        $this$secondaryLabel_u24lambda_u240.setHorizontalAlignment(4);
        gitBranchesWithDetailsTreeRenderer.secondaryLabel = jLabel;
        $this$secondaryLabel_u24lambda_u240 = jLabel = new JLabel();
        gitBranchesWithDetailsTreeRenderer = this;
        boolean bl2 = false;
        $this$arrowLabel_u24lambda_u241.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        gitBranchesWithDetailsTreeRenderer.arrowLabel = jLabel;
        $this$arrowLabel_u24lambda_u241 = jLabel = GitBranchesWithDetailsTreeRendererKt.createIncomingLabel();
        gitBranchesWithDetailsTreeRenderer = this;
        boolean bl3 = false;
        $this$incomingLabel_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)0, (int)1));
        gitBranchesWithDetailsTreeRenderer.incomingLabel = jLabel;
        $this$incomingLabel_u24lambda_u242 = jLabel = GitBranchesWithDetailsTreeRendererKt.createOutgoingLabel();
        gitBranchesWithDetailsTreeRenderer = this;
        boolean bl4 = false;
        $this$outgoingLabel_u24lambda_u243.setBorder((Border)JBUI.Borders.empty((int)1, (int)2, (int)0, (int)10));
        gitBranchesWithDetailsTreeRenderer.outgoingLabel = jLabel;
        this.mainPanel = new MyMainPanel();
    }

    @Override
    @NotNull
    public BorderLayoutPanel getMainPanel() {
        return this.mainPanel;
    }

    public abstract boolean hasRightArrow(@Nullable Object var1);

    @Override
    public void configureTreeCellComponent(@NotNull JTree tree, @Nullable Object userObject, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        IncomingOutgoingState incomingOutgoingState = this.getIncomingOutgoingState(userObject);
        if (!Intrinsics.areEqual((Object)incomingOutgoingState, (Object)IncomingOutgoingState.EMPTY)) {
            GitBranchesWithDetailsTreeRendererKt.updateIncomingCommitLabel(this.incomingLabel, incomingOutgoingState);
            GitBranchesWithDetailsTreeRendererKt.updateOutgoingCommitLabel(this.outgoingLabel, incomingOutgoingState);
            tree.setToolTipText(GitIncomingOutgoingStateKt.calcTooltip(incomingOutgoingState));
        } else {
            this.incomingLabel.setVisible(false);
            this.outgoingLabel.setVisible(false);
            tree.setToolTipText(null);
        }
        JLabel $this$configureTreeCellComponent_u24lambda_u244 = jLabel = this.arrowLabel;
        boolean bl = false;
        $this$configureTreeCellComponent_u24lambda_u244.setVisible(this.hasRightArrow(userObject));
        $this$configureTreeCellComponent_u24lambda_u244.setIcon(selected ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow);
        JLabel $this$configureTreeCellComponent_u24lambda_u245 = jLabel = this.secondaryLabel;
        boolean bl2 = false;
        $this$configureTreeCellComponent_u24lambda_u245.setText(this.getSecondaryText(userObject));
        $this$configureTreeCellComponent_u24lambda_u245.setForeground(GitBranchesTreeRenderer.Companion.isDisabledActionItem$intellij_vcs_git(userObject) ? NamedColorUtil.getInactiveTextColor() : (selected ? JBUI.CurrentTheme.Tree.foreground((boolean)true, (boolean)true) : (Color)JBColor.GRAY));
        $this$configureTreeCellComponent_u24lambda_u245.setBorder(!this.arrowLabel.isVisible() && ExperimentalUI.Companion.isNewUI() ? (Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)JBUI.CurrentTheme.Popup.Selection.innerInsets().right) : (Border)JBUI.Borders.emptyLeft((int)10));
    }

    private final String getSecondaryText(Object treeNode) {
        String string;
        Object object = treeNode;
        if (object instanceof PopupFactoryImpl.ActionItem) {
            string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)((PopupFactoryImpl.ActionItem)treeNode).getAction());
        } else if (object instanceof GitRepository) {
            string = GitBranchUtil.getDisplayableBranchText((GitRepository)treeNode);
        } else if (object instanceof GitBranchesTreeModel.TopLevelRepository) {
            string = GitBranchUtil.getDisplayableBranchText(((GitBranchesTreeModel.TopLevelRepository)treeNode).getRepository());
        } else if (object instanceof GitLocalBranch) {
            GitRemoteBranch gitRemoteBranch = this.getCommonTrackedBranch((GitLocalBranch)treeNode, this.getAffectedRepositories());
            string = gitRemoteBranch != null ? gitRemoteBranch.getName() : null;
        } else if (object instanceof GitTagType) {
            boolean bl;
            block13: {
                List<GitRepository> list = GitRepositoryManager.getInstance(this.getProject()).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl2 = false;
                        if (!it.getTagHolder().isLoading()) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            string = bl ? GitBundle.message("group.Git.Tags.loading.text", new Object[0]) : null;
        } else {
            string = null;
        }
        return string;
    }

    private final GitRemoteBranch getCommonTrackedBranch(GitLocalBranch $this$getCommonTrackedBranch, List<? extends GitRepository> repositories) {
        GitRemoteBranch commonTrackedBranch = null;
        for (GitRepository gitRepository : repositories) {
            GitRemoteBranch trackedBranch;
            if ($this$getCommonTrackedBranch.findTrackedBranch(gitRepository) == null) {
                return null;
            }
            if (commonTrackedBranch == null) {
                commonTrackedBranch = trackedBranch;
                continue;
            }
            if (Intrinsics.areEqual((Object)commonTrackedBranch.getName(), (Object)trackedBranch.getName())) continue;
            return null;
        }
        return commonTrackedBranch;
    }

    private final IncomingOutgoingState getIncomingOutgoingState(Object treeNode) {
        if (treeNode == null) {
            return IncomingOutgoingState.EMPTY;
        }
        Object object = treeNode;
        return object instanceof GitLocalBranch ? this.getIncomingOutgoingState((GitLocalBranch)treeNode) : (object instanceof GitBranchesTreeModel.RefUnderRepository ? this.getIncomingOutgoingState(((GitBranchesTreeModel.RefUnderRepository)treeNode).getRef()) : IncomingOutgoingState.EMPTY);
    }

    private final IncomingOutgoingState getIncomingOutgoingState(GitLocalBranch branch) {
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(...)");
        GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
        IncomingOutgoingState incomingOutgoingState = incomingOutgoingManager.getIncomingOutgoingState((Collection<GitRepository>)this.getAffectedRepositories(), branch);
        Intrinsics.checkNotNullExpressionValue((Object)incomingOutgoingState, (String)"getIncomingOutgoingState(...)");
        return incomingOutgoingState;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016R\u0018\u0010\u0004\u001a\n \u0005*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/tree/GitBranchesWithDetailsTreeRenderer$MyMainPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "<init>", "(Lgit4idea/ui/branch/tree/GitBranchesWithDetailsTreeRenderer;)V", "branchInfoPanel", "kotlin.jvm.PlatformType", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "textPanel", "Ljavax/swing/JPanel;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "intellij.vcs.git"})
    private final class MyMainPanel
    extends BorderLayoutPanel {
        private final BorderLayoutPanel branchInfoPanel;
        @NotNull
        private final JPanel textPanel;

        /*
         * WARNING - void declaration
         */
        public MyMainPanel() {
            GridBagConstraints gridBagConstraints;
            void $this$textPanel_u24lambda_u241;
            this.branchInfoPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)((Component)GitBranchesWithDetailsTreeRenderer.this.getMainTextComponent())).addToLeft((Component)GitBranchesWithDetailsTreeRenderer.this.getMainIconComponent()).andTransparent();
            JPanel jPanel = new JPanel(new GridBagLayout());
            GitBranchesWithDetailsTreeRenderer gitBranchesWithDetailsTreeRenderer = GitBranchesWithDetailsTreeRenderer.this;
            JPanel jPanel2 = jPanel;
            MyMainPanel myMainPanel = this;
            boolean bl = false;
            $this$textPanel_u24lambda_u241.setOpaque(false);
            GridBagConstraints $this$textPanel_u24lambda_u241_u24lambda_u240 = gridBagConstraints = new GridBagConstraints();
            boolean bl2 = false;
            $this$textPanel_u24lambda_u241_u24lambda_u240.anchor = 21;
            $this$textPanel_u24lambda_u241_u24lambda_u240.weightx = 0.0;
            GridBagConstraints gbc = gridBagConstraints;
            $this$textPanel_u24lambda_u241.add((Component)this.branchInfoPanel, gbc);
            $this$textPanel_u24lambda_u241.add((Component)gitBranchesWithDetailsTreeRenderer.incomingLabel, gbc);
            $this$textPanel_u24lambda_u241.add((Component)gitBranchesWithDetailsTreeRenderer.outgoingLabel, gbc);
            gbc.anchor = 22;
            gbc.weightx = 0.75;
            $this$textPanel_u24lambda_u241.add((Component)gitBranchesWithDetailsTreeRenderer.secondaryLabel, gbc);
            myMainPanel.textPanel = jPanel;
            this.addToCenter(this.textPanel);
            this.addToRight(GitBranchesWithDetailsTreeRenderer.this.arrowLabel);
            this.andTransparent();
            this.withBorder((Border)JBUI.Borders.emptyRight((int)JBUI.CurrentTheme.ActionsList.cellPadding().right));
        }

        @NotNull
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                AccessibleContext accessibleContext = GitBranchesWithDetailsTreeRenderer.this.getMainTextComponent().getAccessibleContext();
                this.accessibleContext = (AccessibleContext)new AccessibleContextDelegateWithContextMenu(this, accessibleContext){
                    final /* synthetic */ MyMainPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    protected Container getDelegateParent() {
                        Container container = this.this$0.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
                        return container;
                    }

                    protected void doShowContextMenu() {
                        ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("ShowPopupMenu"), null, null, null, true);
                    }
                };
            }
            AccessibleContext accessibleContext = this.accessibleContext;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
            return accessibleContext;
        }
    }
}

