/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/io/WindowsElevationStatus;", "", "<init>", "()V", "isElevated", "", "TOKEN_ELEVATION", "intellij.platform.ide.util.io"})
final class WindowsElevationStatus {
    @NotNull
    public static final WindowsElevationStatus INSTANCE = new WindowsElevationStatus();

    private WindowsElevationStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isElevated() {
        WinNT.HANDLEByReference tokenHandle = new WinNT.HANDLEByReference();
        WinNT.HANDLE currentProcess = Kernel32.INSTANCE.GetCurrentProcess();
        if (!Advapi32.INSTANCE.OpenProcessToken(currentProcess, 40, tokenHandle)) {
            int lastError = Kernel32.INSTANCE.GetLastError();
            throw new RuntimeException("OpenProcessToken: " + lastError + " " + Kernel32Util.formatMessageFromLastErrorCode((int)lastError));
        }
        try {
            IntByReference cbNeeded = new IntByReference(0);
            TOKEN_ELEVATION token = new TOKEN_ELEVATION();
            int infoClass = 20;
            if (!Advapi32.INSTANCE.GetTokenInformation(tokenHandle.getValue(), infoClass, (Structure)token, token.size(), cbNeeded)) {
                int lastError = Kernel32.INSTANCE.GetLastError();
                throw new RuntimeException("GetTokenInformation: " + lastError + " " + Kernel32Util.formatMessageFromLastErrorCode((int)lastError));
            }
            boolean bl = token.TokenIsElevated.intValue() != 0;
            return bl;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(tokenHandle.getValue());
        }
    }

    @Structure.FieldOrder(value={"TokenIsElevated"})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/io/WindowsElevationStatus$TOKEN_ELEVATION;", "Lcom/sun/jna/Structure;", "<init>", "()V", "TokenIsElevated", "Lcom/sun/jna/platform/win32/WinDef$DWORD;", "intellij.platform.ide.util.io"})
    public static final class TOKEN_ELEVATION
    extends Structure {
        @JvmField
        @NotNull
        public WinDef.DWORD TokenIsElevated = new WinDef.DWORD(0L);
    }
}

