/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.smartUpdate;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.smartUpdate.IdeUpdateStepKt;
import com.intellij.smartUpdate.SmartUpdate;
import com.intellij.smartUpdate.SmartUpdateBundle;
import com.intellij.smartUpdate.SmartUpdateDialogKt;
import com.intellij.smartUpdate.StepOption;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.ToolboxUpdateAction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/smartUpdate/IdeUpdateStep;", "Lcom/intellij/smartUpdate/StepOption;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "stepName", "getStepName", "optionName", "getOptionName", "groupName", "getGroupName", "performUpdateStep", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onSuccess", "Lkotlin/Function0;", "getDetailsComponent", "Ljavax/swing/JComponent;", "getDescription", "intellij.smart.update"})
@SourceDebugExtension(value={"SMAP\nIdeUpdateStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeUpdateStep.kt\ncom/intellij/smartUpdate/IdeUpdateStep\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,87:1\n31#2,2:88\n*S KotlinDebug\n*F\n+ 1 IdeUpdateStep.kt\ncom/intellij/smartUpdate/IdeUpdateStep\n*L\n35#1:88,2\n*E\n"})
public final class IdeUpdateStep
implements StepOption {
    @NotNull
    private final String id;
    @NotNull
    private final String stepName = SmartUpdateBundle.INSTANCE.message("checkbox.update.ide", new Object[0]);
    @NotNull
    private final String optionName = SmartUpdateBundle.INSTANCE.message("update.ide.option.toolbox", new Object[0]);
    @NotNull
    private final String groupName = SmartUpdateBundle.INSTANCE.message("update.ide.group", new Object[0]);

    public IdeUpdateStep() {
        this.id = "ide.update";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getStepName() {
        return this.stepName;
    }

    @Override
    @NotNull
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    @NotNull
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void performUpdateStep(@NotNull Project project, @Nullable AnActionEvent e, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        ToolboxUpdateAction updateAction = IdeUpdateStepKt.access$getUpdateAction();
        IdeUpdateStepKt.access$getLOG$p().info("Update action: " + updateAction);
        if (updateAction != null) {
            updateAction.perform();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SmartUpdate> serviceClass$iv = SmartUpdate.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((SmartUpdate)object).setRestartRequested(true);
        } else {
            onSuccess.invoke();
        }
    }

    @Override
    @NotNull
    public JComponent getDetailsComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (JComponent)SmartUpdateDialogKt.hintLabel(this.getDescription());
    }

    @Nls
    private final String getDescription() {
        ToolboxUpdateAction updateAction = IdeUpdateStepKt.access$getUpdateAction();
        if (updateAction == null) {
            return SmartUpdateBundle.INSTANCE.message("no.updates.available", new Object[0]);
        }
        String string = updateAction.getTemplatePresentation().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

