/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.patchItemHandlers.FrontendEditorPatchItemHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.engine.handlers.PatchVersionUpdater;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendEditorPatchItemHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchEditorVersion;", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "<init>", "()V", "validate", "", "version", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "update", "", "tryCreateVersionsUpdater", "Lcom/jetbrains/rdclient/engine/handlers/PatchVersionUpdater;", "speculativeUpdatedVersion", "backendUpdatedVersions", "getEditorSynchronizer", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "apply", "item", "(Lcom/jetbrains/rd/ide/model/RdPatchItem;Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorPatchItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorPatchItemHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendEditorPatchItemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n68#2,4:84\n*S KotlinDebug\n*F\n+ 1 FrontendEditorPatchItemHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendEditorPatchItemHandler\n*L\n33#1:84,4\n*E\n"})
public final class FrontendEditorPatchItemHandler
implements FrontendRdPatchItemHandler<RdPatchEditorVersion, RdPatchItem> {
    @Override
    public boolean validate(@NotNull RdPatchEditorVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdEditorVersion expectedVersion = version.getVersion();
        EditorSynchronizer editorSynchronizer = this.getEditorSynchronizer(version);
        if (editorSynchronizer == null || (editorSynchronizer = editorSynchronizer.getVersion()) == null) {
            return true;
        }
        EditorSynchronizer actualVersion = editorSynchronizer;
        if (!Intrinsics.areEqual((Object)actualVersion, (Object)expectedVersion)) {
            FrontendEditorPatchItemHandlerKt.access$getLogger$p().error("Not matched versions for " + version.getId() + ", actual: " + (RdAbstractEditorVersion)actualVersion + ", expected: " + expectedVersion);
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchEditorVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Logger $this$trace$iv = FrontendEditorPatchItemHandlerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Update editor version: " + version.getVersion() + " for operation " + context.getOperation());
            }
            PatchItemOperationType patchItemOperationType = context.getOperation();
            if (!(patchItemOperationType instanceof PatchItemOperationType.Rollback) && !(patchItemOperationType instanceof PatchItemOperationType.UpdateVersions) && !(patchItemOperationType instanceof PatchItemOperationType.Merge)) break block2;
            EditorSynchronizer editorSynchronizer = this.getEditorSynchronizer(version);
            if (editorSynchronizer != null) {
                editorSynchronizer.resetVersion((RdAbstractEditorVersion)version.getVersion());
            }
        }
    }

    @Override
    @Nullable
    public PatchVersionUpdater<RdPatchEditorVersion> tryCreateVersionsUpdater(@NotNull RdPatchEditorVersion speculativeUpdatedVersion, @NotNull RdPatchEditorVersion backendUpdatedVersions) {
        Intrinsics.checkNotNullParameter((Object)speculativeUpdatedVersion, (String)"speculativeUpdatedVersion");
        Intrinsics.checkNotNullParameter((Object)backendUpdatedVersions, (String)"backendUpdatedVersions");
        boolean bl = Intrinsics.areEqual((Object)speculativeUpdatedVersion.getId(), (Object)backendUpdatedVersions.getId());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Speculative: " + speculativeUpdatedVersion + " and backend: " + backendUpdatedVersions + " versions must have the same ID.";
            throw new AssertionError((Object)string);
        }
        int shift = backendUpdatedVersions.getVersion().getCaretModelVersion() - speculativeUpdatedVersion.getVersion().getCaretModelVersion();
        if (shift == 0) {
            return null;
        }
        return new PatchVersionUpdater<RdPatchEditorVersion>(speculativeUpdatedVersion, backendUpdatedVersions, shift){
            final /* synthetic */ RdPatchEditorVersion $speculativeUpdatedVersion;
            final /* synthetic */ RdPatchEditorVersion $backendUpdatedVersions;
            final /* synthetic */ int $shift;
            {
                this.$speculativeUpdatedVersion = $speculativeUpdatedVersion;
                this.$backendUpdatedVersions = $backendUpdatedVersions;
                this.$shift = $shift;
            }

            public RdPatchEditorVersion update(RdPatchEditorVersion oldVersion) {
                Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
                boolean bl = Intrinsics.areEqual((Object)this.$speculativeUpdatedVersion.getId(), (Object)this.$backendUpdatedVersions.getId());
                RdPatchEditorVersion rdPatchEditorVersion = this.$speculativeUpdatedVersion;
                RdPatchEditorVersion rdPatchEditorVersion2 = this.$backendUpdatedVersions;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Speculative: " + rdPatchEditorVersion + " and backend: " + rdPatchEditorVersion2 + " versions must have the same ID.";
                    throw new AssertionError((Object)string);
                }
                bl = oldVersion.getVersion().getCaretModelVersion() >= this.$speculativeUpdatedVersion.getVersion().getCaretModelVersion();
                rdPatchEditorVersion = this.$speculativeUpdatedVersion;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "An attempt to update an older version: " + oldVersion + " than the base version: " + rdPatchEditorVersion + " used for the updater";
                    throw new AssertionError((Object)string);
                }
                return new RdPatchEditorVersion(new RdEditorVersion(oldVersion.getVersion().getCaretModelVersion() + this.$shift), oldVersion.getId());
            }
        };
    }

    private final EditorSynchronizer getEditorSynchronizer(RdPatchEditorVersion version) {
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.TextControlId");
        Editor editor = FrontendTextControlHostKt.toEditorOrNull((TextControlId)rdPatchItemId);
        if (editor == null) {
            FrontendEditorPatchItemHandler $this$getEditorSynchronizer_u24lambda_u242 = this;
            boolean bl = false;
            FrontendEditorPatchItemHandlerKt.access$getLogger$p().warn("There is no editor for " + version.getId());
            return null;
        }
        Editor editor2 = editor;
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor2);
        if (editorSynchronizer == null) {
            FrontendEditorPatchItemHandler $this$getEditorSynchronizer_u24lambda_u243 = this;
            boolean bl = false;
            FrontendEditorPatchItemHandlerKt.access$getLogger$p().warn("There is no EditorSynchronizer for " + version.getId());
            return null;
        }
        EditorSynchronizer synchronizer = editorSynchronizer;
        return synchronizer;
    }

    @Override
    @Nullable
    public Object apply(@NotNull RdPatchItem item, @NotNull FrontendRdPatchHandlerContext context, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }
}

