/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionHandler;
import com.jetbrains.rdclient.services.IdeBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/editorActions/FrontendEscapeHandlerAction;", "Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.client"})
public final class FrontendEscapeHandlerAction
extends FrontendEditorActionHandler {
    public FrontendEscapeHandlerAction(@NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        super("EditorEscape", baseHandler);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(project2);
        if (ideBackend == null) {
            return false;
        }
        IdeBackend backend = ideBackend;
        Boolean backendResult = backend.isEscapeAvailable();
        if (backendResult != null) {
            return backendResult != false && super.backendIsEnabledForCaret(editor, caret, dataContext);
        }
        String string = this.getFrontendId();
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        return BackendActionDelegationKt.backendUpdate(string, anActionEvent);
    }
}

