/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveTrailingBlankLinesFix
implements ModCommandAction {
    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        if (context == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(0);
        }
        return Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.HIGH);
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        if (context == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(1);
        }
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)context.file(), (file, updater) -> RemoveTrailingBlankLinesFix.removeTrailingBlankLines(file));
        if (modCommand == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(2);
        }
        return modCommand;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.remove.trailing.blank.lines", new Object[0]);
        if (string == null) {
            RemoveTrailingBlankLinesFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void removeTrailingBlankLines(PsiFile file) {
        Document document = file.getFileDocument();
        int lastBlankLineOffset = -1;
        for (int i = document.getLineCount() - 1; i >= 0; --i) {
            int lineStart = document.getLineStartOffset(i);
            String trimmed = document.getCharsSequence().subSequence(lineStart, document.getLineEndOffset(i)).toString().trim();
            if (trimmed.length() > 0) break;
            lastBlankLineOffset = lineStart;
        }
        if (lastBlankLineOffset > 0) {
            document.deleteString(lastBlankLineOffset, document.getTextLength());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/RemoveTrailingBlankLinesFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/RemoveTrailingBlankLinesFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

