/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstImportElement;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.namespacePackages.PyNamespacePackagesService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "PyMarkAsNamespacePackageQuickFix", "PyChangeToSameDirectoryImportQuickFix", "intellij.python.community.impl"})
public final class PyRelativeImportInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!PyNamespacePackagesService.isEnabled() || LanguageLevel.forElement((PsiElement)((PsiElement)holder.getFile())).isOlderThan(LanguageLevel.PYTHON34)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection$PyChangeToSameDirectoryImportQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "replaceByImportStatements", "oldImport", "Lcom/jetbrains/python/psi/PyFromImportStatement;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyRelativeImportInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRelativeImportInspection.kt\ncom/jetbrains/python/inspections/PyRelativeImportInspection$PyChangeToSameDirectoryImportQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,144:1\n11165#2:145\n11500#2,3:146\n*S KotlinDebug\n*F\n+ 1 PyRelativeImportInspection.kt\ncom/jetbrains/python/inspections/PyRelativeImportInspection$PyChangeToSameDirectoryImportQuickFix\n*L\n134#1:145\n134#1:146,3\n*E\n"})
    private static final class PyChangeToSameDirectoryImportQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("QFIX.change.to.same.directory.import", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            PyFromImportStatement pyFromImportStatement = element instanceof PyFromImportStatement ? (PyFromImportStatement)element : null;
            if (pyFromImportStatement == null) {
                return;
            }
            PyFromImportStatement oldImport = pyFromImportStatement;
            boolean bl2 = bl = oldImport.getRelativeLevel() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            PyReferenceExpression qualifier = oldImport.getImportSource();
            if (qualifier != null) {
                boolean bl3;
                PsiElement possibleDot = PsiTreeUtil.prevVisibleLeaf((PsiElement)((PsiElement)qualifier));
                boolean bl4 = bl3 = possibleDot != null && Intrinsics.areEqual((Object)possibleDot.getNode().getElementType(), (Object)PyTokenTypes.DOT);
                if (_Assertions.ENABLED && !bl3) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                PsiElement psiElement = possibleDot;
                if (psiElement != null) {
                    psiElement.delete();
                }
            } else {
                this.replaceByImportStatements(oldImport);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void replaceByImportStatements(PyFromImportStatement oldImport) {
            void $this$mapTo$iv$iv;
            Project project = oldImport.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PyElementGenerator generator = PyElementGenerator.getInstance(project2);
            PyAstImportElement[] pyAstImportElementArray = oldImport.getImportElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyAstImportElementArray, (String)"getImportElements(...)");
            Object[] $this$map$iv = pyAstImportElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyImportElement pyImportElement = (PyImportElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            List names = (List)destination$iv$iv;
            if (names.isEmpty()) {
                return;
            }
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)((PsiElement)oldImport));
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"forElement(...)");
            LanguageLevel langLevel = languageLevel;
            for (String name2 : CollectionsKt.reversed((Iterable)names)) {
                PyImportStatement newImport;
                Intrinsics.checkNotNullExpressionValue((Object)generator.createImportStatement(langLevel, name2, null), (String)"createImportStatement(...)");
                oldImport.getParent().addAfter((PsiElement)newImport, (PsiElement)oldImport);
            }
            oldImport.delete();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection$PyMarkAsNamespacePackageQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.python.community.impl"})
    private static final class PyMarkAsNamespacePackageQuickFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final VirtualFile directory;

        public PyMarkAsNamespacePackageQuickFix(@NotNull Module module, @NotNull VirtualFile directory) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.module = module;
            this.directory = directory;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final VirtualFile getDirectory() {
            return this.directory;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.directory.getName()};
            String string = PyBundle.message("QFIX.mark.as.namespace.package", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(descriptor2.getPsiElement().getContainingFile());
            Document[] documentArray = new Document[]{document};
            Document[] documentArray2 = documentArray;
            var undoableAction2 = new BasicUndoableAction(this, documentArray2){
                final /* synthetic */ PyMarkAsNamespacePackageQuickFix this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void undo() {
                    PyNamespacePackagesService.getInstance(this.this$0.getModule()).toggleMarkingAsNamespacePackage(this.this$0.getDirectory());
                }

                public void redo() {
                    PyNamespacePackagesService.getInstance(this.this$0.getModule()).toggleMarkingAsNamespacePackage(this.this$0.getDirectory());
                }
            };
            undoableAction2.redo();
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undoableAction2);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyFromImportStatement", "", "node", "Lcom/jetbrains/python/psi/PyFromImportStatement;", "isInsideOrdinaryPackage", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "handleRelativeImportNotInsidePackage", "getMarkAsNamespacePackageQuickFix", "Lcom/jetbrains/python/inspections/PyRelativeImportInspection$PyMarkAsNamespacePackageQuickFix;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyRelativeImportInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRelativeImportInspection.kt\ncom/jetbrains/python/inspections/PyRelativeImportInspection$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,144:1\n1#2:145\n37#3,2:146\n*S KotlinDebug\n*F\n+ 1 PyRelativeImportInspection.kt\ncom/jetbrains/python/inspections/PyRelativeImportInspection$Visitor\n*L\n67#1:146,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        @Override
        public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiFile psiFile = node.getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getContainingDirectory()) == null) {
                return;
            }
            PsiFile directory = psiFile;
            if (node.getRelativeLevel() > 0 && !PyUtil.isExplicitPackage((PsiDirectory)directory) && !this.isInsideOrdinaryPackage((PsiDirectory)directory)) {
                this.handleRelativeImportNotInsidePackage(node, (PsiDirectory)directory);
            }
        }

        private final boolean isInsideOrdinaryPackage(PsiDirectory directory) {
            for (PsiDirectory curDir = directory; curDir != null; curDir = curDir.getParentDirectory()) {
                if (!PyUtil.isOrdinaryPackage(curDir)) continue;
                return true;
            }
            return false;
        }

        private final void handleRelativeImportNotInsidePackage(PyFromImportStatement node, PsiDirectory directory) {
            List fixes = new ArrayList();
            PyMarkAsNamespacePackageQuickFix pyMarkAsNamespacePackageQuickFix = this.getMarkAsNamespacePackageQuickFix(directory);
            if (pyMarkAsNamespacePackageQuickFix != null) {
                PyMarkAsNamespacePackageQuickFix it = pyMarkAsNamespacePackageQuickFix;
                boolean bl = false;
                fixes.add(it);
            }
            if (node.getRelativeLevel() == 1) {
                fixes.add(new PyChangeToSameDirectoryImportQuickFix());
            }
            String string = PyPsiBundle.message("INSP.relative.import.relative.import.outside.package", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            this.registerProblem((PsiElement)node, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }

        private final PyMarkAsNamespacePackageQuickFix getMarkAsNamespacePackageQuickFix(PsiDirectory directory) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory));
            if (module == null) {
                return null;
            }
            Module module2 = module;
            PsiDirectory curDir = directory;
            while (curDir != null) {
                Intrinsics.checkNotNullExpressionValue((Object)curDir.getVirtualFile(), (String)"getVirtualFile(...)");
                if (PyUtil.isRoot((PsiFileSystemItem)curDir)) {
                    return null;
                }
                PsiDirectory parentDir = curDir.getParentDirectory();
                if (parentDir != null && (PyUtil.isRoot((PsiFileSystemItem)parentDir) || PyUtil.isOrdinaryPackage(parentDir))) {
                    VirtualFile virtualFile;
                    return new PyMarkAsNamespacePackageQuickFix(module2, virtualFile);
                }
                curDir = parentDir;
            }
            return null;
        }
    }
}

