/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.core.CoreBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.model.SideEffectGuard;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.PyRequirementsTxtUtilKt;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyPackagesUsageCollector;
import com.jetbrains.python.ui.PyUiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyPackageRequirementsInspection
extends PyInspection {
    public JDOMExternalizableStringList ignoredPackages = new JDOMExternalizableStringList();
    @NotNull
    private static final NotificationGroup BALLOON_NOTIFICATIONS = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> NotificationGroupManager.getInstance().getNotificationGroup("Package requirements"));

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"ignoredPackages", (String)PyPsiBundle.message("INSP.requirements.ignore.packages.label", new Object[0]))});
        if (optPane == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(2);
        }
        if (!(holder.getFile() instanceof PyFile) && !PyPackageRequirementsInspection.isPythonInTemplateLanguages(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PyPackageRequirementsInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new Visitor(holder, (Collection<String>)this.ignoredPackages, PyInspectionVisitor.getContext(session));
    }

    private static boolean isPythonInTemplateLanguages(PsiFile psiFile) {
        return StreamEx.of((Collection)psiFile.getViewProvider().getLanguages()).findFirst(x -> x.isKindOf((Language)PythonLanguage.getInstance())).isPresent();
    }

    @Nullable
    public static PyPackageRequirementsInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(4);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
        return (PyPackageRequirementsInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @Nullable
    private static Set<PyRequirement> getRequirementsInclTransitive(@NotNull PyPackageManager packageManager, @NotNull Module module) {
        List<PyRequirement> requirements;
        if (packageManager == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(6);
        }
        if ((requirements = PyPackageRequirementsInspection.getListedRequirements(packageManager, module)) == null) {
            return null;
        }
        if (requirements.isEmpty()) {
            return Collections.emptySet();
        }
        List<PyPackage> packages2 = packageManager.getPackages();
        if (packages2 == null) {
            return null;
        }
        HashSet<PyRequirement> result2 = new HashSet<PyRequirement>(requirements);
        result2.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages2, requirements, new HashSet<PyPackage>()));
        return result2;
    }

    @Nullable
    private static List<PyRequirement> getListedRequirements(@NotNull PyPackageManager packageManager, @NotNull Module module) {
        if (packageManager == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(8);
        }
        List<PyRequirement> requirements = packageManager.getRequirements(module);
        List<PyRequirement> extrasRequirements = PyPackageRequirementsInspection.getExtrasRequirements(module);
        if (requirements == null) {
            return extrasRequirements;
        }
        if (extrasRequirements == null) {
            return requirements;
        }
        return ContainerUtil.concat(requirements, extrasRequirements);
    }

    @Nullable
    private static List<PyRequirement> getExtrasRequirements(@NotNull Module module) {
        Map<String, List<PyRequirement>> extrasRequire;
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(9);
        }
        return (extrasRequire = PyPackageUtil.findSetupPyExtrasRequire(module)) == null ? null : ContainerUtil.flatten(extrasRequire.values());
    }

    @NotNull
    private static Set<PyRequirement> getTransitiveRequirements(@NotNull List<PyPackage> packages2, @NotNull Collection<PyRequirement> requirements, @NotNull Set<PyPackage> visited) {
        if (packages2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(10);
        }
        if (requirements == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(11);
        }
        if (visited == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(12);
        }
        HashSet<PyRequirement> result2 = new HashSet<PyRequirement>();
        for (PyRequirement req : requirements) {
            PyPackage pkg = req.match(packages2);
            if (pkg == null || !visited.add(pkg)) continue;
            result2.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages2, pkg.getRequirements(), visited));
        }
        HashSet<PyRequirement> hashSet = result2;
        if (hashSet == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @Nullable
    private static List<PyRequirement> findUnsatisfiedRequirements(@NotNull Module module, @NotNull Sdk sdk2, @NotNull Set<String> ignoredPackages) {
        PyPackageManager manager;
        List<PyRequirement> requirements;
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(14);
        }
        if (sdk2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(15);
        }
        if (ignoredPackages == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(16);
        }
        if ((requirements = (manager = PyPackageManager.getInstance(sdk2)).getRequirements(module)) != null) {
            List<PyPackage> packages2 = manager.getPackages();
            if (packages2 == null) {
                return null;
            }
            List<PyPackage> packagesInModule = PyPackageRequirementsInspection.collectPackagesInModule(module);
            ArrayList<PyRequirement> unsatisfied = new ArrayList<PyRequirement>();
            for (PyRequirement req : requirements) {
                if (ignoredPackages.contains(req.getName()) || req.match(packages2) != null || req.match(packagesInModule) != null) continue;
                unsatisfied.add(req);
            }
            return unsatisfied;
        }
        return null;
    }

    @NotNull
    private static List<PyPackage> collectPackagesInModule(@NotNull Module module) {
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(17);
        }
        String[] metadataExtensions = new String[]{"egg-info", "dist-info"};
        SmartList result2 = new SmartList();
        for (VirtualFile srcRoot : PyUtil.getSourceRoots(module)) {
            for (VirtualFile metadata : VfsUtil.getChildren((VirtualFile)srcRoot, file -> ArrayUtil.contains((String)file.getExtension(), (String[])metadataExtensions))) {
                String[] nameAndVersionAndRest = metadata.getNameWithoutExtension().split("-", 3);
                if (nameAndVersionAndRest.length < 2) continue;
                result2.add(new PyPackage(nameAndVersionAndRest[0], nameAndVersionAndRest[1]));
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    private static void setRunningPackagingTasks(@NotNull Module module, boolean value) {
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(19);
        }
        module.putUserData(PyPackageManager.RUNNING_PACKAGING_TASKS, (Object)value);
    }

    public static boolean isRunningPackagingTasks(@NotNull Module module) {
        Boolean value;
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(20);
        }
        return (value = (Boolean)module.getUserData(PyPackageManager.RUNNING_PACKAGING_TASKS)) != null && value != false;
    }

    private static boolean checkAdminPermissionsAndConfigureInterpreter(@NotNull Project project, @NotNull ProblemDescriptor descriptor2, @NotNull Sdk sdk2) {
        if (project == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(21);
        }
        if (descriptor2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(22);
        }
        if (sdk2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(23);
        }
        if (!PythonSdkUtil.isRemote(sdk2) && PySdkExtKt.adminPermissionsNeeded(sdk2)) {
            int answer = PyPackageRequirementsInspection.askToConfigureInterpreter(project, sdk2);
            switch (answer) {
                case 0: {
                    new PyInterpreterInspection.ConfigureInterpreterFix().applyFix(project, descriptor2);
                    return true;
                }
                case -1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private static int askToConfigureInterpreter(@NotNull Project project, @NotNull Sdk sdk2) {
        if (project == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(24);
        }
        if (sdk2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(25);
        }
        String sdkName2 = StringUtil.shortenTextWithEllipsis((String)sdk2.getName(), (int)25, (int)0);
        String text = PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.description", sdkName2);
        String[] options = new String[]{PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.button.configure", new Object[0]), PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.button.install.anyway", new Object[0]), CoreBundle.message((String)"button.cancel", (Object[])new Object[0])};
        return Messages.showIdeaMessageDialog((Project)project, (String)text, (String)PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required", new Object[0]), (String[])options, (int)0, (Icon)Messages.getWarningIcon(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManager";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 15: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPackages";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransitiveRequirements";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackagesInModule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsInclTransitive";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getListedRequirements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtrasRequirements";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTransitiveRequirements";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUnsatisfiedRequirements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectPackagesInModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setRunningPackagingTasks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPackagingTasks";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkAdminPermissionsAndConfigureInterpreter";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "askToConfigureInterpreter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25 -> new IllegalArgumentException(string);
        };
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredPackages;

        Visitor(@Nullable ProblemsHolder holder, Collection<String> ignoredPackages, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
            this.myIgnoredPackages = ImmutableSet.copyOf(ignoredPackages);
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.checkPackagesHaveBeenInstalled((PsiElement)node, ModuleUtilCore.findModuleForPsiElement((PsiElement)node));
        }

        private void checkPackagesHaveBeenInstalled(@NotNull PsiElement file, @Nullable Module module) {
            List<PyRequirement> unsatisfied;
            Sdk sdk2;
            if (file == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (module != null && !PyPackageRequirementsInspection.isRunningPackagingTasks(module) && (sdk2 = PythonSdkUtil.findPythonSdk(module)) != null && (unsatisfied = PyPackageRequirementsInspection.findUnsatisfiedRequirements(module, sdk2, this.myIgnoredPackages)) != null && !unsatisfied.isEmpty()) {
                @NlsSafe String requirementsList = PyPackageUtil.requirementsToString(unsatisfied);
                @InspectionMessage String msg = PyPsiBundle.message("INSP.requirements.package.requirements.not.satisfied", requirementsList, unsatisfied.size());
                ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
                Optional<LocalQuickFix> providedFix = PySdkProvider.EP_NAME.getExtensionList().stream().map(ext -> ext.createInstallPackagesQuickFix(module)).filter(fix -> fix != null).findFirst();
                if (providedFix.isPresent()) {
                    quickFixes.add(providedFix.get());
                } else {
                    quickFixes.add(new PyInstallRequirementsFix(null, module, sdk2, unsatisfied));
                }
                quickFixes.add(new IgnoreRequirementFix(ContainerUtil.map2Set(unsatisfied, PyRequirement::getName)));
                this.registerProblem(file, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        @Override
        public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
            PyReferenceExpression expr;
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((expr = node.getImportSource()) != null) {
                this.checkPackageNameInRequirements(expr);
            }
        }

        @Override
        public void visitPyImportStatement(@NotNull PyImportStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            for (PyImportElement element : node.getImportElements()) {
                PyReferenceExpression expr = element.getImportReferenceExpression();
                if (expr == null) continue;
                this.checkPackageNameInRequirements(expr);
            }
        }

        private void checkPackageNameInRequirements(@NotNull PyQualifiedExpression importedExpression) {
            if (importedExpression == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                if (!extension.ignorePackageNameInRequirements(importedExpression)) continue;
                return;
            }
            PyExpression packageReferenceExpression = PyPsiUtils.getFirstQualifier(importedExpression);
            String packageName = packageReferenceExpression.getName();
            if (packageName != null && !this.myIgnoredPackages.contains(packageName)) {
                PsiReference reference;
                String possiblePyPIPackageNames = PyPsiPackageUtil.INSTANCE.moduleToPackageName(packageName, "");
                if (!(ApplicationManager.getApplication().isUnitTestMode() || PyPIPackageUtil.INSTANCE.isInPyPI(packageName) || PyPIPackageUtil.INSTANCE.isInPyPI(possiblePyPIPackageNames))) {
                    return;
                }
                if ("setuptools".equals(packageName)) {
                    return;
                }
                Collection<String> stdlibPackages = PyStdlibUtil.getPackages();
                if (stdlibPackages != null && stdlibPackages.contains(packageName)) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)packageReferenceExpression);
                if (module == null) {
                    return;
                }
                Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
                if (sdk2 == null) {
                    return;
                }
                PyPackageManager packageManager = PyPackageManager.getInstance(sdk2);
                Set<PyRequirement> requirements = PyPackageRequirementsInspection.getRequirementsInclTransitive(packageManager, module);
                if (requirements == null) {
                    return;
                }
                for (PyRequirement req : requirements) {
                    String name2 = req.getName();
                    if (name2.equalsIgnoreCase(packageName) || name2.equalsIgnoreCase(possiblePyPIPackageNames)) {
                        return;
                    }
                    String nameWhereUnderscoreReplacedWithHyphen = name2.replaceAll("_", "-");
                    if (nameWhereUnderscoreReplacedWithHyphen.equalsIgnoreCase(possiblePyPIPackageNames)) {
                        return;
                    }
                    String nameWhereHyphenReplacedWithUnderscore = name2.replaceAll("-", "_");
                    if (!nameWhereHyphenReplacedWithUnderscore.equalsIgnoreCase(packageName) && !nameWhereHyphenReplacedWithUnderscore.equalsIgnoreCase(possiblePyPIPackageNames)) continue;
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && (reference = packageReferenceExpression.getReference()) != null) {
                    VirtualFile virtualFile;
                    PsiFile file;
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiDirectory && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)((PsiDirectory)element).getVirtualFile(), (boolean)false)) {
                        return;
                    }
                    if (element != null && (file = element.getContainingFile()) != null && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)(virtualFile = file.getVirtualFile()), (boolean)false)) {
                        return;
                    }
                }
                LocalQuickFix[] fixes = new LocalQuickFix[]{new PyGenerateRequirementsFileQuickFix(module), new IgnoreRequirementFix(Collections.singleton(packageName))};
                this.registerProblem((PsiElement)packageReferenceExpression, PyPsiBundle.message("INSP.requirements.package.containing.module.not.listed.in.project.requirements", packageName), ProblemHighlightType.WEAK_WARNING, null, fixes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackagesHaveBeenInstalled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFromImportStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyImportStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackageNameInRequirements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class IgnoreRequirementFix
    implements LocalQuickFix {
        @NotNull
        private final Set<String> myPackageNames;

        private IgnoreRequirementFix(@NotNull Set<String> packageNames) {
            if (packageNames == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(0);
            }
            this.myPackageNames = packageNames;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.NAME.ignore.requirements", this.myPackageNames.size());
            if (string == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PyPackageRequirementsInspection inspection;
            PsiElement element;
            if (project == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor2.getPsiElement()) != null && (inspection = PyPackageRequirementsInspection.getInstance(element)) != null) {
                SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.PROJECT_MODEL);
                HashSet<String> packagesToIgnore = new HashSet<String>(this.myPackageNames);
                for (String pkg : inspection.ignoredPackages) {
                    packagesToIgnore.remove(pkg);
                }
                if (!packagesToIgnore.isEmpty()) {
                    inspection.ignoredPackages.addAll(packagesToIgnore);
                    ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
                    profileManager.fireProfileChanged();
                    Notification notification2 = BALLOON_NOTIFICATIONS.createNotification(packagesToIgnore.size() == 1 ? PyPsiBundle.message("INSP.package.requirements.requirement.has.been.ignored", packagesToIgnore.iterator().next()) : PyPsiBundle.message("INSP.package.requirements.requirements.have.been.ignored", new Object[0]), NotificationType.INFORMATION);
                    notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)ActionsBundle.message((String)"action.$Undo.text", (Object[])new Object[0]), () -> {
                        inspection.ignoredPackages.removeAll((Collection)packagesToIgnore);
                        profileManager.fireProfileChanged();
                    }));
                    notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PyBundle.message("notification.action.edit.settings", new Object[0]), () -> {
                        InspectionProfileImpl profile = profileManager.getCurrentProfile();
                        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
                        EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)profile, (String)toolName);
                    }));
                    notification2.notify(project);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class RunningPackagingTasksListener
    implements PyPackageManagerUI.Listener {
        @NotNull
        private final Module myModule;

        public RunningPackagingTasksListener(@NotNull Module module) {
            if (module == null) {
                RunningPackagingTasksListener.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @Override
        public void started() {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, true);
        }

        @Override
        public void finished(List<ExecutionException> exceptions) {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$RunningPackagingTasksListener", "<init>"));
        }
    }

    public static class PyGenerateRequirementsFileQuickFix
    implements LocalQuickFix {
        private final Module myModule;

        public PyGenerateRequirementsFileQuickFix(Module module) {
            this.myModule = module;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.add.imported.packages.to.requirements", new Object[0]);
            if (string == null) {
                PyGenerateRequirementsFileQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyGenerateRequirementsFileQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                PyGenerateRequirementsFileQuickFix.$$$reportNull$$$0(2);
            }
            PyRequirementsTxtUtilKt.syncWithImports(this.myModule);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyGenerateRequirementsFileQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyGenerateRequirementsFileQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class InstallAndImportPackageQuickFix
    extends InstallPackageQuickFix {
        @Nullable
        private final String myAsName;

        public InstallAndImportPackageQuickFix(@NotNull String packageName, @Nullable String asName) {
            if (packageName == null) {
                InstallAndImportPackageQuickFix.$$$reportNull$$$0(0);
            }
            super(packageName);
            this.myAsName = asName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PyPsiBundle.message("QFIX.NAME.install.and.import.package", this.myPackageName);
            if (string == null) {
                InstallAndImportPackageQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.install.and.import.package", new Object[0]);
            if (string == null) {
                InstallAndImportPackageQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected void onSuccess(@NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (descriptor2 == null) {
                InstallAndImportPackageQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor2.getPsiElement()) == null) {
                return;
            }
            WriteCommandAction.writeCommandAction((Project)element.getProject()).withName(PyPsiBundle.message("INSP.package.requirements.add.import", new Object[0])).withGroupId("Add import").run(() -> AddImportHelper.addImportStatement(element.getContainingFile(), this.myPackageName, this.myAsName, AddImportHelper.ImportPriority.THIRD_PARTY, element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportPackageQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportPackageQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onSuccess";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class InstallPackageQuickFix
    implements LocalQuickFix {
        public static final String CONFIRM_PACKAGE_INSTALLATION_PROPERTY = "python.confirm.package.installation";
        @NotNull
        protected final String myPackageName;

        public InstallPackageQuickFix(@NotNull String packageName) {
            if (packageName == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(0);
            }
            this.myPackageName = packageName;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("python.unresolved.reference.inspection.install.package", this.myPackageName);
            if (string == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public final void applyFix(@NotNull Project project, final @NotNull ProblemDescriptor descriptor2) {
            boolean confirmed;
            if (project == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(3);
            }
            if (!(confirmed = PyPackageInstallUtils.INSTANCE.confirmInstall(project, this.myPackageName))) {
                return;
            }
            PsiElement element = descriptor2.getPsiElement();
            if (element == null) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(element);
            if (module != null && sdk2 != null) {
                new PyInstallRequirementsFix(this.getFamilyName(), module, sdk2, Collections.singletonList(PyRequirementsKt.pyRequirement(this.myPackageName)), Collections.emptyList(), new RunningPackagingTasksListener(module){

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        super.finished(exceptions);
                        if (exceptions.isEmpty()) {
                            this.onSuccess(descriptor2);
                        }
                    }
                }).applyFix(module.getProject(), descriptor2);
                PyPackagesUsageCollector.installSingleEvent.log();
            }
        }

        protected void onSuccess(@NotNull ProblemDescriptor descriptor2) {
            if (descriptor2 == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(4);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(6);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                InstallPackageQuickFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallPackageQuickFix";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallPackageQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onSuccess";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 7 -> new IllegalStateException(string);
            };
        }

        private static class ConfirmPackageInstallationDoNotAskOption
        extends DoNotAskOption.Adapter {
            private ConfirmPackageInstallationDoNotAskOption() {
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode == 0) {
                    PropertiesComponent.getInstance().setValue(InstallPackageQuickFix.CONFIRM_PACKAGE_INSTALLATION_PROPERTY, false, true);
                }
            }
        }
    }

    public static class PyInstallRequirementsFix
    implements LocalQuickFix {
        @NotNull
        @IntentionFamilyName
        private final String myName;
        @NotNull
        private final Module myModule;
        @NotNull
        private final Sdk mySdk;
        @NotNull
        private final List<PyRequirement> myUnsatisfied;
        @NotNull
        private final List<String> myExtraArgs;
        @Nullable
        private final PyPackageManagerUI.Listener myListener;

        public PyInstallRequirementsFix(@Nullable @IntentionFamilyName String name2, @NotNull Module module, @NotNull Sdk sdk2, @NotNull List<PyRequirement> unsatisfied) {
            if (module == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(0);
            }
            if (sdk2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(1);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(2);
            }
            this(name2, module, sdk2, unsatisfied, Collections.emptyList(), null);
        }

        public PyInstallRequirementsFix(@Nullable @IntentionFamilyName String name2, @NotNull Module module, @NotNull Sdk sdk2, @NotNull List<PyRequirement> unsatisfied, @NotNull List<String> extraArgs, @Nullable PyPackageManagerUI.Listener listener2) {
            if (module == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(3);
            }
            if (sdk2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(4);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(5);
            }
            if (extraArgs == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(6);
            }
            this.myName = name2 != null ? name2 : PyPsiBundle.message("QFIX.NAME.install.requirements", unsatisfied.size());
            this.myModule = module;
            this.mySdk = sdk2;
            this.myUnsatisfied = unsatisfied;
            this.myExtraArgs = extraArgs;
            this.myListener = listener2;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(8);
            }
            if (descriptor2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(9);
            }
            SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.PROJECT_MODEL);
            if (!PyPackageRequirementsInspection.checkAdminPermissionsAndConfigureInterpreter(project, descriptor2, this.mySdk)) {
                PyUiUtil.clearFileLevelInspectionResults(descriptor2.getPsiElement().getContainingFile());
                this.installPackages(project);
            }
        }

        private void installPackages(final @NotNull Project project) {
            boolean hasManagement;
            List<PyRequirement> chosen;
            PyPackageManager manager;
            List<PyPackage> packages2;
            if (project == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(10);
            }
            if ((packages2 = (manager = PyPackageManager.getInstance(this.mySdk)).getPackages()) == null) {
                return;
            }
            if (this.myUnsatisfied.size() > 1) {
                PyChooseRequirementsDialog dialog2 = new PyChooseRequirementsDialog(project, this.myUnsatisfied);
                if (dialog2.showAndGet()) {
                    chosen = dialog2.getMarkedElements();
                } else {
                    PyPackagesUsageCollector.installAllCanceledEvent.log();
                    chosen = Collections.emptyList();
                }
            } else {
                chosen = this.myUnsatisfied;
            }
            if (chosen.isEmpty()) {
                return;
            }
            try {
                hasManagement = manager.hasManagement();
            }
            catch (ExecutionException e) {
                hasManagement = false;
            }
            if (!hasManagement) {
                PyPackageManagerUI ui2 = new PyPackageManagerUI(project, this.mySdk, new RunningPackagingTasksListener(this.myModule){

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        super.finished(exceptions);
                        if (exceptions.isEmpty()) {
                            this.installRequirements(project, chosen);
                        }
                    }
                });
                ui2.installManagement();
            } else {
                this.installRequirements(project, chosen);
            }
        }

        private void installRequirements(Project project, List<PyRequirement> requirements) {
            RunningPackagingTasksListener listener2 = this.myListener == null ? new RunningPackagingTasksListener(this.myModule) : new RunningPackagingTasksListener(this.myModule){

                @Override
                public void started() {
                    super.started();
                    myListener.started();
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    super.finished(exceptions);
                    myListener.finished(exceptions);
                }
            };
            new PyPackageManagerUI(project, this.mySdk, listener2).install(requirements, this.myExtraArgs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unsatisfied";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraArgs";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "installPackages";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

