/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.icons.PythonIcons;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class PythonConsoleToolWindow {
    public static final Key<RunContentDescriptor> CONTENT_DESCRIPTOR = Key.create((String)"CONTENT_DESCRIPTOR");
    public static final Function<Content, RunContentDescriptor> CONTENT_TO_DESCRIPTOR_FUNCTION = input -> input == null ? null : (RunContentDescriptor)input.getUserData(CONTENT_DESCRIPTOR);
    private final Project myProject;
    private boolean myInitialized = false;

    public PythonConsoleToolWindow(Project project) {
        this.myProject = project;
    }

    public static PythonConsoleToolWindow getInstance(@NotNull Project project) {
        if (project == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(0);
        }
        return (PythonConsoleToolWindow)project.getService(PythonConsoleToolWindow.class);
    }

    public List<RunContentDescriptor> getConsoleContentDescriptors() {
        return FluentIterable.from(List.of(PythonConsoleToolWindow.getToolWindow(this.myProject).getContentManager().getContents())).transform(CONTENT_TO_DESCRIPTOR_FUNCTION).filter(Predicates.notNull()).toList();
    }

    public void init(@NotNull ToolWindow toolWindow, @NotNull RunContentDescriptor contentDescriptor) {
        if (toolWindow == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(1);
        }
        if (contentDescriptor == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(2);
        }
        PythonConsoleToolWindow.setContent(toolWindow, contentDescriptor);
        if (!this.myInitialized) {
            this.doInit(toolWindow);
        }
        if (toolWindow instanceof ToolWindowEx) {
            ToolWindowEx toolWindowEx = (ToolWindowEx)toolWindow;
            toolWindowEx.setTabActions(new AnAction[]{new NewConsoleAction()});
        }
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    private void doInit(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(3);
        }
        this.myInitialized = true;
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){
            private ToolWindowManagerListener.ToolWindowManagerEventType lastChangeType = null;

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindow affectedToolWindow, @NotNull ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (affectedToolWindow == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (changeType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.lastChangeType == changeType || !affectedToolWindow.getId().equals(toolWindow.getId())) {
                    return;
                }
                this.lastChangeType = changeType;
                if (this.lastChangeType == ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow && affectedToolWindow.getContentManager().getContentCount() == 0) {
                    PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner(PythonConsoleToolWindow.this.myProject, null);
                    runner.run(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "toolWindowManager";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "affectedToolWindow";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeType";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/console/PythonConsoleToolWindow$1";
                objectArray[2] = "stateChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void setContent(ToolWindow toolWindow, RunContentDescriptor contentDescriptor) {
        toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        Content content2 = toolWindow.getContentManager().findContent(contentDescriptor.getDisplayName());
        if (content2 == null) {
            content2 = PythonConsoleToolWindow.createContent(contentDescriptor);
            toolWindow.getContentManager().addContent(content2);
        } else {
            SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
            PythonConsoleToolWindow.resetContent(contentDescriptor, panel2, content2);
        }
        toolWindow.getContentManager().setSelectedContent(content2);
    }

    @NotNull
    public ToolWindow getToolWindow() {
        return PythonConsoleToolWindow.getToolWindow(this.myProject);
    }

    @NotNull
    public static ToolWindow getToolWindow(@NotNull Project project) {
        ToolWindowManager toolWindowManager;
        ToolWindow consoleToolWindow;
        if (project == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(4);
        }
        if ((consoleToolWindow = (toolWindowManager = ToolWindowManager.getInstance((Project)project)).getToolWindow("Python Console")) == null) {
            consoleToolWindow = toolWindowManager.registerToolWindow("Python Console", builder -> {
                builder.hideOnEmptyContent = false;
                builder.anchor = ToolWindowAnchor.BOTTOM;
                return Unit.INSTANCE;
            });
            consoleToolWindow.setIcon(PythonIcons.Python.PythonConsoleToolWindow);
        }
        ToolWindow toolWindow = consoleToolWindow;
        if (toolWindow == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(5);
        }
        return toolWindow;
    }

    public void setContent(RunContentDescriptor contentDescriptor) {
        PythonConsoleToolWindow.setContent(PythonConsoleToolWindow.getToolWindow(this.myProject), contentDescriptor);
    }

    private static Content createContent(@NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(6);
        }
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
        Content content2 = ContentFactory.getInstance().createContent((JComponent)panel2, contentDescriptor.getDisplayName(), false);
        content2.setCloseable(true);
        PythonConsoleToolWindow.resetContent(contentDescriptor, panel2, content2);
        return content2;
    }

    private static void resetContent(RunContentDescriptor contentDescriptor, SimpleToolWindowPanel panel2, Content content2) {
        RunContentDescriptor oldDescriptor;
        RunContentDescriptor runContentDescriptor = oldDescriptor = content2.getDisposer() instanceof RunContentDescriptor ? (RunContentDescriptor)content2.getDisposer() : null;
        if (oldDescriptor != null) {
            Disposer.dispose((Disposable)oldDescriptor);
        }
        panel2.setContent(contentDescriptor.getComponent());
        content2.setComponent((JComponent)panel2);
        content2.setDisposer((Disposable)contentDescriptor);
        content2.setPreferredFocusableComponent(contentDescriptor.getComponent());
        content2.setPreferredFocusedComponent(contentDescriptor.getPreferredFocusComputable());
        content2.putUserData(CONTENT_DESCRIPTOR, (Object)contentDescriptor);
    }

    public void activate(@NotNull Runnable runnable) {
        if (runnable == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(7);
        }
        PythonConsoleToolWindow.getToolWindow(this.myProject).activate(runnable);
    }

    @Nullable
    public RunContentDescriptor getSelectedContentDescriptor() {
        return (RunContentDescriptor)CONTENT_TO_DESCRIPTOR_FUNCTION.apply((Object)PythonConsoleToolWindow.getToolWindow(this.myProject).getContentManager().getSelectedContent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PythonConsoleToolWindow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PythonConsoleToolWindow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInit";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class NewConsoleAction
    extends AnAction
    implements DumbAware {
        NewConsoleAction() {
            super(PyBundle.messagePointer("console.new.console", new Object[0]), PyBundle.messagePointer("console.new.console.description", new Object[0]), AllIcons.General.Add);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewConsoleAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                NewConsoleAction.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) != null) {
                PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner(project, (Module)e.getData(PlatformCoreDataKeys.MODULE));
                runner.run(true);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NewConsoleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PythonConsoleToolWindow$NewConsoleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PythonConsoleToolWindow$NewConsoleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

