/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.registry;

import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.registry.QodanaRegistryKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u001d\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u001f\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0011\u0010#\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/qodana/registry/QodanaRegistry;", "", "<init>", "()V", "CLOUD_INTEGRATION_ENABLE_KEY", "", "isQodanaLicenseAgreementCallbackEnabled", "", "()Z", "isForceLocalRunEnabled", "isForceSetupCIEnabled", "isQodanaCloudIntegrationEnabled", "openSarifInEditor", "getOpenSarifInEditor", "openCoverageReportEnabled", "getOpenCoverageReportEnabled", "openCoverageSmartFilteringEnabled", "getOpenCoverageSmartFilteringEnabled", "openCoveragePackageLength", "", "getOpenCoveragePackageLength", "()I", "webUiSourcesPath", "getWebUiSourcesPath", "()Ljava/lang/String;", "vcsRevisionPageSize", "getVcsRevisionPageSize", "vcsRevisionMaxPages", "getVcsRevisionMaxPages", "cloudRequestRetriesCount", "getCloudRequestRetriesCount", "cloudDownloadRetriesCount", "getCloudDownloadRetriesCount", "useAllDistributionForInspectionKtsDependencies", "getUseAllDistributionForInspectionKtsDependencies", "limitedInspectionKtsDependencies", "getLimitedInspectionKtsDependencies", "Cloud", "intellij.qodana"})
public final class QodanaRegistry {
    @NotNull
    public static final QodanaRegistry INSTANCE = new QodanaRegistry();
    @VisibleForTesting
    @NotNull
    public static final String CLOUD_INTEGRATION_ENABLE_KEY = "qd.cloud.integration.enabled";

    private QodanaRegistry() {
    }

    public final boolean isQodanaLicenseAgreementCallbackEnabled() {
        return Registry.Companion.is("qd.license.agreement.callback.enabled", true);
    }

    public final boolean isForceLocalRunEnabled() {
        return Registry.Companion.is("qd.force.local.run.enabled", false);
    }

    public final boolean isForceSetupCIEnabled() {
        return Registry.Companion.is("qd.force.setup.ci.enabled", false);
    }

    public final boolean isQodanaCloudIntegrationEnabled() {
        return Registry.Companion.is(CLOUD_INTEGRATION_ENABLE_KEY, true);
    }

    public final boolean getOpenSarifInEditor() {
        return Registry.Companion.is("qd.open.sarif.in.editor", false);
    }

    public final boolean getOpenCoverageReportEnabled() {
        return Registry.Companion.is("qd.open.coverage.enabled", true);
    }

    public final boolean getOpenCoverageSmartFilteringEnabled() {
        return Registry.Companion.is("qd.open.coverage.smart.filter.enabled", true);
    }

    public final int getOpenCoveragePackageLength() {
        return Registry.Companion.intValue("qd.open.coverage.common.package.length", 3);
    }

    @NotNull
    public final String getWebUiSourcesPath() {
        return Registry.Companion.stringValue("qd.web.ui.sources.url");
    }

    public final int getVcsRevisionPageSize() {
        return Registry.Companion.intValue("qd.vcs.revision.page.size", 100);
    }

    public final int getVcsRevisionMaxPages() {
        return Registry.Companion.intValue("qd.vcs.revision.max.pages", 10);
    }

    public final int getCloudRequestRetriesCount() {
        return Registry.Companion.intValue("qd.cloud.request.retries.count", 2);
    }

    public final int getCloudDownloadRetriesCount() {
        return Registry.Companion.intValue("qd.cloud.download.retries.count", 2);
    }

    public final boolean getUseAllDistributionForInspectionKtsDependencies() {
        return Registry.Companion.is("qd.inspection.kts.all.distribution.for.dependencies", false);
    }

    public final boolean getLimitedInspectionKtsDependencies() {
        return Registry.Companion.is("qd.inspection.kts.limited.dependencies", true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/registry/QodanaRegistry$Cloud;", "", "<init>", "()V", "website", "", "getWebsite", "()Ljava/lang/String;", "cloudApi", "getCloudApi", "jbaOAuthUrl", "getJbaOAuthUrl", "jbaAuthReferrer", "getJbaAuthReferrer", "jbaClientId", "getJbaClientId", "intellij.qodana"})
    public static final class Cloud {
        @NotNull
        public static final Cloud INSTANCE = new Cloud();

        private Cloud() {
        }

        @NotNull
        public final String getWebsite() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.website", "https://qodana.cloud");
        }

        @NotNull
        public final String getCloudApi() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.api", "https://api.qodana.cloud");
        }

        @NotNull
        public final String getJbaOAuthUrl() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.jba.oauth.url", "https://oauth.account.jetbrains.com/oauth2/auth");
        }

        @NotNull
        public final String getJbaAuthReferrer() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.jba.auth.referrer", "https://account.jetbrains.com/");
        }

        @NotNull
        public final String getJbaClientId() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.jba.auth.client.id", "qodana");
        }
    }
}

