/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;

final class IsoInstantTypeAdapter
extends TypeAdapter<Instant> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_TIME).optionalEnd().toFormatter();

    IsoInstantTypeAdapter() {
    }

    public void write(JsonWriter out, Instant value2) throws IOException {
        ZonedDateTime utc = ZonedDateTime.ofInstant(value2, ZoneId.of("UTC"));
        out.value(FORMATTER.format(utc));
    }

    public Instant read(JsonReader in) throws IOException {
        TemporalAccessor parsed = FORMATTER.parseBest(in.nextString(), Instant::from, LocalDate::from);
        if (parsed instanceof Instant) {
            return (Instant)parsed;
        }
        if (parsed instanceof LocalDate) {
            return ((LocalDate)parsed).atStartOfDay().toInstant(ZoneOffset.UTC);
        }
        throw new IllegalStateException("Unreachable");
    }
}

