/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.images.MarkdownImagesBundle;
import org.intellij.plugins.markdown.images.editor.ConfigureImageDialog;
import org.intellij.plugins.markdown.images.editor.ImageUtils;
import org.intellij.plugins.markdown.images.editor.MarkdownImageData;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/images/editor/actions/InsertImageAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "buildImageText", "", "imageData", "Lorg/intellij/plugins/markdown/images/editor/MarkdownImageData;", "intellij.markdown.images"})
public final class InsertImageAction
extends DumbAwareAction {
    public InsertImageAction() {
        this.addTextOverride(MarkdownActionPlaces.getINSERT_POPUP(), InsertImageAction::_init_$lambda$0);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor(event);
        Presentation $this$update_u24lambda_u241 = presentation = event.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u241.setVisible(editor2 != null);
        Editor editor3 = editor2;
        $this$update_u24lambda_u241.setEnabled(editor3 != null && (editor3 = editor3.getDocument()) != null ? editor3.isWritable() : false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor(event);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Project project = editor3.getProject();
        new ConfigureImageDialog(project, MarkdownImagesBundle.INSTANCE.message("markdown.insert.image.dialog.title", new Object[0]), null, null, null, null, null, false, 252, null).show((Function1<? super MarkdownImageData, Unit>)((Function1)arg_0 -> InsertImageAction.actionPerformed$lambda$4(editor3, this, project, arg_0)));
    }

    private final String buildImageText(MarkdownImageData imageData) {
        String string;
        if (imageData.getShouldConvertToHtml()) {
            string = ImageUtils.createHtmlImageText(imageData);
        } else {
            String path = imageData.component1();
            String title = imageData.component4();
            String description = imageData.component5();
            string = ImageUtils.createMarkdownImageText(description, path, title);
        }
        return string;
    }

    private static final String _init_$lambda$0() {
        return MarkdownImagesBundle.INSTANCE.message("action.org.intellij.plugins.markdown.ui.actions.styling.InsertImageAction.insert.popup.text", new Object[0]);
    }

    private static final void actionPerformed$lambda$4$lambda$3$lambda$2(Document $document, String $imageText, Caret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int offset = caret.getOffset();
        $document.insertString(offset, (CharSequence)$imageText);
        caret.moveToOffset(offset + $imageText.length());
    }

    private static final void actionPerformed$lambda$4$lambda$3(Editor $editor, Document $document, String $imageText) {
        $editor.getCaretModel().runForEachCaret(arg_0 -> InsertImageAction.actionPerformed$lambda$4$lambda$3$lambda$2($document, $imageText, arg_0));
    }

    private static final Unit actionPerformed$lambda$4(Editor $editor, InsertImageAction this$0, Project $project, MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String imageText = this$0.buildImageText(imageData);
        try {
            WriteCommandAction.runWriteCommandAction((Project)$project, (String)this$0.getTemplateText(), null, () -> InsertImageAction.actionPerformed$lambda$4$lambda$3($editor, document2, imageText), (PsiFile[])new PsiFile[0]);
        }
        catch (ReadOnlyModificationException exception) {
            Messages.showErrorDialog((Project)$project, (String)exception.getLocalizedMessage(), (String)RefactoringBundle.message((String)"error.title"));
        }
        catch (ReadOnlyFragmentModificationException exception) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document2).handle(exception);
        }
        return Unit.INSTANCE;
    }
}

