/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.files;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.MLCompletionNotifications;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.FullLineNotifications;
import org.jetbrains.completion.full.line.FullLinePluginInfo;
import org.jetbrains.completion.full.line.local.files.DownloadModelConsentPolicy;
import org.jetbrains.completion.full.line.settings.FullLineBundle;

@Service(value={Service.Level.APP})
@State(name="DownloadModelConsentState", storages={@Storage(value="full.line.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018J\u001c\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0000H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "consentedLanguages", "", "Lcom/intellij/lang/Language;", "lastNotificationTimestamps", "", "", "", "value", "Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;", "consentPolicy", "getConsentPolicy", "()Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;", "setConsentPolicy", "(Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;)V", "isConsented", "", "language", "withRequestingConsent", "", "onConsentGranted", "Lkotlin/Function0;", "withGrantingConsent", "grantLanguageConsent", "withdrawLanguageConsent", "isConsentCompletelyRefused", "shouldNotificationBeShown", "getState", "loadState", "state", "Companion", "intellij.fullLine"})
public final class LocalModelsDownloadConsentManager
implements PersistentStateComponent<LocalModelsDownloadConsentManager> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Transient
    @NotNull
    private final Set<Language> consentedLanguages = new LinkedHashSet();
    @Property
    @MapAnnotation(keyAttributeName="language", valueAttributeName="lastNotificationTimestamp")
    @NotNull
    private final Map<String, Long> lastNotificationTimestamps = new LinkedHashMap();
    @Property
    @NotNull
    private volatile DownloadModelConsentPolicy consentPolicy = org.jetbrains.completion.full.line.local.files.LocalModelsDownloadConsentManager$Companion.access$defaultPolicy(Companion);
    private static final long notificationPeriodDuration = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.DAYS);

    @NotNull
    public final DownloadModelConsentPolicy getConsentPolicy() {
        return this.consentPolicy;
    }

    public final void setConsentPolicy(@NotNull DownloadModelConsentPolicy value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        ThreadingAssertions.assertEventDispatchThread();
        this.consentPolicy = value;
    }

    public final boolean isConsented(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.consentPolicy == DownloadModelConsentPolicy.AUTOMATICALLY || this.consentedLanguages.contains(language);
    }

    public final void withRequestingConsent(@NotNull Language language, @NotNull Function0<Unit> onConsentGranted) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(onConsentGranted, (String)"onConsentGranted");
        if (this.isConsented(language)) {
            onConsentGranted.invoke();
            return;
        }
        if (this.isConsentCompletelyRefused() || !this.shouldNotificationBeShown(language)) {
            return;
        }
        if (ConfigImportHelper.isFirstSession() || ConfigImportHelper.isConfigImported()) {
            return;
        }
        Object[] objectArray = new Object[]{language.getDisplayName()};
        String string = FullLineBundle.message("full.line.ask.download.model.content", objectArray);
        objectArray = new AnAction[]{MLCompletionNotifications.INSTANCE.action(FullLineBundle.message("full.line.ask.download.model.action.consented.content", new Object[0]), (arg_0, arg_1) -> LocalModelsDownloadConsentManager.withRequestingConsent$lambda$0(this, language, onConsentGranted, arg_0, arg_1)), MLCompletionNotifications.INSTANCE.action(FullLineBundle.message("full.line.ask.download.model.action.consent.automatic.content", new Object[0]), (arg_0, arg_1) -> LocalModelsDownloadConsentManager.withRequestingConsent$lambda$1(this, onConsentGranted, arg_0, arg_1)), MLCompletionNotifications.INSTANCE.action(FullLineBundle.message("full.line.ask.download.model.action.consent.manual.content", new Object[0]), (arg_0, arg_1) -> LocalModelsDownloadConsentManager.withRequestingConsent$lambda$2(this, arg_0, arg_1))};
        FullLineNotifications.showFullContentBalloon$default(FullLineNotifications.INSTANCE, null, FullLineBundle.message("full.line.ask.download.model.title", new Object[0]), string, NotificationType.INFORMATION, (AnAction[])objectArray, null, 32, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withGrantingConsent(@NotNull Language language, @NotNull Function0<Unit> onConsentGranted) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(onConsentGranted, (String)"onConsentGranted");
        if (this.isConsented(language)) {
            onConsentGranted.invoke();
        } else {
            this.grantLanguageConsent(language);
            try {
                onConsentGranted.invoke();
            }
            finally {
                this.withdrawLanguageConsent(language);
            }
        }
    }

    private final void grantLanguageConsent(Language language) {
        if (!(!this.isConsentCompletelyRefused())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.consentedLanguages).add(language);
    }

    private final void withdrawLanguageConsent(Language language) {
        if (!(!this.isConsentCompletelyRefused())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!this.isConsented(language)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.consentedLanguages).remove(language);
    }

    private final boolean isConsentCompletelyRefused() {
        return this.consentPolicy == DownloadModelConsentPolicy.MANUALLY;
    }

    private final boolean shouldNotificationBeShown(Language language) {
        boolean bl;
        Long l = this.lastNotificationTimestamps.get(language.getID());
        long lastTimestamp = l != null ? l : 0L;
        long currentTime = System.currentTimeMillis();
        if (Duration.compareTo-LRDsOJo((long)DurationKt.toDuration((long)(currentTime - lastTimestamp), (DurationUnit)DurationUnit.MILLISECONDS), (long)notificationPeriodDuration) > 0) {
            Long l2 = currentTime;
            this.lastNotificationTimestamps.put(language.getID(), l2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public LocalModelsDownloadConsentManager getState() {
        return this;
    }

    public void loadState(@NotNull LocalModelsDownloadConsentManager state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit withRequestingConsent$lambda$0(LocalModelsDownloadConsentManager this$0, Language $language, Function0 $onConsentGranted, AnActionEvent anActionEvent, Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this$0.grantLanguageConsent($language);
        try {
            $onConsentGranted.invoke();
        }
        finally {
            this$0.withdrawLanguageConsent($language);
            notification.expire();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit withRequestingConsent$lambda$1(LocalModelsDownloadConsentManager this$0, Function0 $onConsentGranted, AnActionEvent anActionEvent, Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this$0.setConsentPolicy(DownloadModelConsentPolicy.AUTOMATICALLY);
        try {
            $onConsentGranted.invoke();
        }
        finally {
            notification.expire();
        }
        return Unit.INSTANCE;
    }

    private static final Unit withRequestingConsent$lambda$2(LocalModelsDownloadConsentManager this$0, AnActionEvent anActionEvent, Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this$0.setConsentPolicy(DownloadModelConsentPolicy.MANUALLY);
        notification.expire();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager;", "notificationPeriodDuration", "Lkotlin/time/Duration;", "J", "defaultPolicy", "Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nLocalModelsDownloadConsentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsDownloadConsentManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,195:1\n40#2,3:196\n*S KotlinDebug\n*F\n+ 1 LocalModelsDownloadConsentManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager$Companion\n*L\n181#1:196,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalModelsDownloadConsentManager getInstance() {
            boolean $i$f$service = false;
            Class<LocalModelsDownloadConsentManager> serviceClass$iv = LocalModelsDownloadConsentManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LocalModelsDownloadConsentManager)object;
        }

        private final DownloadModelConsentPolicy defaultPolicy() {
            return ApplicationKt.getApplication().isUnitTestMode() ? DownloadModelConsentPolicy.MANUALLY : (FullLinePluginInfo.INSTANCE.isMarketplaceBuild() || ApplicationKt.getApplication().isEAP() ? DownloadModelConsentPolicy.AUTOMATICALLY : DownloadModelConsentPolicy.ASK_BEFORE_DOWNLOAD);
        }

        public static final /* synthetic */ DownloadModelConsentPolicy access$defaultPolicy(Companion $this) {
            return $this.defaultPolicy();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

