/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.impl;

import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.impl.DirectoryResourceRoot;
import com.intellij.platform.runtime.repository.impl.JarResourceRoot;
import com.intellij.platform.runtime.repository.impl.ResourcePathMacros;
import com.intellij.platform.runtime.repository.impl.ResourceRoot;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RuntimeModuleDescriptorImpl
implements RuntimeModuleDescriptor {
    private final RuntimeModuleId myId;
    private final List<RuntimeModuleDescriptor> myDependencies;
    private final Path myBasePath;
    private final List<String> myResourcePaths;
    @Nullable
    private volatile List<ResourceRoot> myResourceRoots;

    RuntimeModuleDescriptorImpl(@NotNull RuntimeModuleId moduleId, @NotNull Path basePath, @NotNull List<String> resourcePaths, @NotNull List<RuntimeModuleDescriptor> dependencies) {
        if (moduleId == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (basePath == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (resourcePaths == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (dependencies == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(3);
        }
        this.myId = moduleId;
        this.myBasePath = basePath;
        this.myResourcePaths = resourcePaths;
        this.myDependencies = dependencies;
    }

    @Override
    @NotNull
    public RuntimeModuleId getModuleId() {
        RuntimeModuleId runtimeModuleId = this.myId;
        if (runtimeModuleId == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(4);
        }
        return runtimeModuleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myId.equals(((RuntimeModuleDescriptorImpl)o).myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    @Override
    @NotNull
    public List<RuntimeModuleDescriptor> getDependencies() {
        List<RuntimeModuleDescriptor> list = this.myDependencies;
        if (list == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Path> getResourceRootPaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (ResourceRoot resourceRoot : this.resolveResourceRoots()) {
            paths.add(resourceRoot.getRootPath());
        }
        ArrayList<Path> arrayList = paths;
        if (arrayList == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public InputStream readFile(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(7);
        }
        for (ResourceRoot resourceRoot : this.resolveResourceRoots()) {
            InputStream inputStream = resourceRoot.openFile(relativePath);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @NotNull
    private List<? extends ResourceRoot> resolveResourceRoots() {
        List<ResourceRoot> resourceRoots = this.myResourceRoots;
        if (resourceRoots == null) {
            resourceRoots = new ArrayList<ResourceRoot>(this.myResourcePaths.size());
            for (String path : this.myResourcePaths) {
                resourceRoots.add(RuntimeModuleDescriptorImpl.createResourceRoot(this.myBasePath, path));
            }
            this.myResourceRoots = resourceRoots;
        }
        List<ResourceRoot> list = resourceRoots;
        if (list == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Path> getModuleClasspath() {
        LinkedHashSet<Path> classpath = new LinkedHashSet<Path>();
        RuntimeModuleDescriptorImpl.collectDependencies(this, new LinkedHashSet<RuntimeModuleId>(), classpath);
        List<Path> list = List.copyOf(classpath);
        if (list == null) {
            RuntimeModuleDescriptorImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static void collectDependencies(RuntimeModuleDescriptor module, Set<RuntimeModuleId> visited, Set<Path> classpath) {
        if (visited.add(module.getModuleId())) {
            classpath.addAll(module.getResourceRootPaths());
            for (RuntimeModuleDescriptor dep : module.getDependencies()) {
                RuntimeModuleDescriptorImpl.collectDependencies(dep, visited, classpath);
            }
        }
    }

    private static ResourceRoot createResourceRoot(Path baseDir, String relativePath) {
        Path root = RuntimeModuleDescriptorImpl.convertToAbsolute(baseDir, relativePath);
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return new JarResourceRoot(root);
        }
        return new DirectoryResourceRoot(root);
    }

    private static Path convertToAbsolute(Path baseDir, String relativePath) {
        if (relativePath.startsWith("$")) {
            return ResourcePathMacros.resolve(relativePath, baseDir);
        }
        Path root = baseDir;
        while (relativePath.startsWith("../")) {
            relativePath = relativePath.substring(3);
            root = root.getParent();
        }
        if (!relativePath.isEmpty()) {
            root = root.resolve(relativePath);
        }
        return root;
    }

    public String toString() {
        return "RuntimeModuleDescriptor{id=" + this.myId + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleDescriptorImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleDescriptorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceRootPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

