/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunConfigurationProducer;
import com.intellij.sh.run.ShRunnerAdditionalCondition;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

final class ShRunFileAction
extends DumbAwareAction {
    static final String ID = "runShellFileAction";

    ShRunFileAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ShRunConfiguration runConfiguration;
        PsiFile file;
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(0);
        }
        if ((file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file.getProject();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)e.getDataContext(), (String)e.getPlace());
        ShRunConfigurationProducer configProducer = (ShRunConfigurationProducer)RunConfigurationProducer.getInstance(ShRunConfigurationProducer.class);
        RunnerAndConfigurationSettings configurationSettings = configProducer.findExistingConfiguration(context);
        if (configurationSettings == null) {
            configurationSettings = RunManager.getInstance((Project)project).createConfiguration(file.getName(), ShConfigurationType.class);
            runConfiguration = (ShRunConfiguration)configurationSettings.getConfiguration();
            runConfiguration.setScriptPath(virtualFile.getPath());
            runConfiguration.setExecuteScriptFile(true);
            runConfiguration.setScriptWorkingDirectory(virtualFile.getParent().getPath());
            if (file instanceof ShFile) {
                @NlsSafe String defaultShell = ShConfigurationType.getDefaultShell(project);
                String shebang = ShShebangParserUtil.getShebangExecutable((ShFile)file);
                if (shebang != null) {
                    Pair<String, String> result = ShRunFileAction.parseInterpreterAndOptions(shebang);
                    runConfiguration.setInterpreterPath((String)result.first);
                    runConfiguration.setInterpreterOptions((String)result.second);
                } else {
                    runConfiguration.setInterpreterPath(defaultShell);
                }
            } else {
                runConfiguration.setInterpreterPath("");
            }
        } else {
            runConfiguration = (ShRunConfiguration)configurationSettings.getConfiguration();
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)runConfiguration);
        if (builder != null) {
            ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(ShRunFileAction.isEnabled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShRunFileAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    static Pair<String, String> parseInterpreterAndOptions(@NotNull String shebang) {
        String shebangParam;
        String[] splitShebang;
        if (shebang == null) {
            ShRunFileAction.$$$reportNull$$$0(3);
        }
        if ((splitShebang = shebang.split(" ")).length > 1 && !(shebangParam = splitShebang[splitShebang.length - 1]).contains("/") && !shebangParam.contains("\\")) {
            Pair pair = Pair.create((Object)shebang.substring(0, shebang.length() - shebangParam.length() - 1), (Object)shebangParam);
            if (pair == null) {
                ShRunFileAction.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)shebang, (Object)"");
        if (pair == null) {
            ShRunFileAction.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        PsiFile file;
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(6);
        }
        if (e.getProject() != null && (file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null) {
            boolean runningProhibited = ContainerUtil.exists((Iterable)ShRunnerAdditionalCondition.EP.getExtensionsIfPointIsRegistered(), runningCondition -> runningCondition.isRunningProhibitedForFile(file));
            if (runningProhibited) {
                return false;
            }
            if (file instanceof ShFile) {
                return true;
            }
            PsiElement firstChild = file.findElementAt(0);
            return firstChild instanceof PsiComment && firstChild.getText().startsWith("#!");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunFileAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shebang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunFileAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInterpreterAndOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseInterpreterAndOptions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

