/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/mimetype.h>
    wxFileTypeInfo* _wxFileTypeInfo_ctor(const wxString *mimeType, const wxString *openCmd, const wxString *printCmd, const wxString *description, const wxString *extension)
    {
        wxFileTypeInfo* fti = new wxFileTypeInfo(*mimeType);
        fti->SetOpenCommand(*openCmd);
        fti->SetPrintCommand(*printCmd);
        fti->SetDescription(*description);
        fti->AddExtension(*extension);
        return fti;
    }


PyDoc_STRVAR(doc_wxFileTypeInfo_AddExtension, "AddExtension(ext) -> None\n"
"\n"
"Add another extension associated with this file type.");

extern "C" {static PyObject *meth_wxFileTypeInfo_AddExtension(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_AddExtension(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* ext;
        int extState = 0;
        ::wxFileTypeInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ext,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFileTypeInfo, &sipCpp, sipType_wxString, &ext, &extState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddExtension(*ext);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(ext), sipType_wxString, extState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_AddExtension, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_SetDescription, "SetDescription(description) -> None\n"
"\n"
"Set the file type description.");

extern "C" {static PyObject *meth_wxFileTypeInfo_SetDescription(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_SetDescription(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* description;
        int descriptionState = 0;
        ::wxFileTypeInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_description,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFileTypeInfo, &sipCpp, sipType_wxString, &description, &descriptionState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDescription(*description);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(description), sipType_wxString, descriptionState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_SetDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_SetOpenCommand, "SetOpenCommand(command) -> None\n"
"\n"
"Set the command to be used for opening files of this type.");

extern "C" {static PyObject *meth_wxFileTypeInfo_SetOpenCommand(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_SetOpenCommand(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* command;
        int commandState = 0;
        ::wxFileTypeInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_command,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFileTypeInfo, &sipCpp, sipType_wxString, &command, &commandState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOpenCommand(*command);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(command), sipType_wxString, commandState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_SetOpenCommand, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_SetPrintCommand, "SetPrintCommand(command) -> None\n"
"\n"
"Set the command to be used for printing files of this type.");

extern "C" {static PyObject *meth_wxFileTypeInfo_SetPrintCommand(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_SetPrintCommand(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* command;
        int commandState = 0;
        ::wxFileTypeInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_command,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFileTypeInfo, &sipCpp, sipType_wxString, &command, &commandState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPrintCommand(*command);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(command), sipType_wxString, commandState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_SetPrintCommand, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_SetShortDesc, "SetShortDesc(shortDesc) -> None\n"
"\n"
"Set the short description for the files of this type.");

extern "C" {static PyObject *meth_wxFileTypeInfo_SetShortDesc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_SetShortDesc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* shortDesc;
        int shortDescState = 0;
        ::wxFileTypeInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_shortDesc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFileTypeInfo, &sipCpp, sipType_wxString, &shortDesc, &shortDescState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetShortDesc(*shortDesc);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(shortDesc), sipType_wxString, shortDescState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_SetShortDesc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_SetIcon, "SetIcon(iconFile, iconIndex=0) -> None\n"
"\n"
"Set the icon information.");

extern "C" {static PyObject *meth_wxFileTypeInfo_SetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_SetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* iconFile;
        int iconFileState = 0;
        int iconIndex = 0;
        ::wxFileTypeInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_iconFile,
            sipName_iconIndex,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_wxFileTypeInfo, &sipCpp, sipType_wxString, &iconFile, &iconFileState, &iconIndex))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetIcon(*iconFile, iconIndex);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(iconFile), sipType_wxString, iconFileState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_SetIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetMimeType, "GetMimeType() -> str\n"
"\n"
"Get the MIME type.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetMimeType(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetMimeType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetMimeType());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetMimeType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetOpenCommand, "GetOpenCommand() -> str\n"
"\n"
"Get the open command.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetOpenCommand(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetOpenCommand(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetOpenCommand());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetOpenCommand, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetPrintCommand, "GetPrintCommand() -> str\n"
"\n"
"Get the print command.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetPrintCommand(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetPrintCommand(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetPrintCommand());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetPrintCommand, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetShortDesc, "GetShortDesc() -> str\n"
"\n"
"Get the short description (only used under Win32 so far)");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetShortDesc(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetShortDesc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetShortDesc());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetShortDesc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetDescription, "GetDescription() -> str\n"
"\n"
"Get the long, user visible description.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetDescription(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetExtensions, "GetExtensions() -> List[str]\n"
"\n"
"Get the array of all extensions.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetExtensions(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetExtensions(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayString(sipCpp->GetExtensions());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetExtensions, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetExtensionsCount, "GetExtensionsCount() -> int\n"
"\n"
"Get the number of extensions.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetExtensionsCount(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetExtensionsCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetExtensionsCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetExtensionsCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetIconFile, "GetIconFile() -> str\n"
"\n"
"Get the icon filename.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetIconFile(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetIconFile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetIconFile());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetIconFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFileTypeInfo_GetIconIndex, "GetIconIndex() -> int\n"
"\n"
"Get the index of the icon within the icon file.");

extern "C" {static PyObject *meth_wxFileTypeInfo_GetIconIndex(PyObject *, PyObject *);}
static PyObject *meth_wxFileTypeInfo_GetIconIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileTypeInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileTypeInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetIconIndex();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_FileTypeInfo, sipName_GetIconIndex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFileTypeInfo(void *, int);}
static void release_wxFileTypeInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxFileTypeInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxFileTypeInfo(Py_ssize_t);}
static void *array_wxFileTypeInfo(Py_ssize_t sipNrElem)
{
    return new ::wxFileTypeInfo[sipNrElem];
}


extern "C" {static void array_delete_wxFileTypeInfo(void *);}
static void array_delete_wxFileTypeInfo(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxFileTypeInfo *>(sipCpp);
}


extern "C" {static void assign_wxFileTypeInfo(void *, Py_ssize_t, void *);}
static void assign_wxFileTypeInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxFileTypeInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxFileTypeInfo *>(sipSrc);
}


extern "C" {static void *copy_wxFileTypeInfo(const void *, Py_ssize_t);}
static void *copy_wxFileTypeInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxFileTypeInfo(reinterpret_cast<const ::wxFileTypeInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxFileTypeInfo(sipSimpleWrapper *);}
static void dealloc_wxFileTypeInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFileTypeInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFileTypeInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFileTypeInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxFileTypeInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFileTypeInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxString* mimeType;
        int mimeTypeState = 0;

        static const char *sipKwdList[] = {
            sipName_mimeType,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxString, &mimeType, &mimeTypeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFileTypeInfo(*mimeType);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mimeType), sipType_wxString, mimeTypeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxString* mimeType;
        int mimeTypeState = 0;
        const ::wxString* openCmd;
        int openCmdState = 0;
        const ::wxString* printCmd;
        int printCmdState = 0;
        const ::wxString* description;
        int descriptionState = 0;
        const ::wxString* extension;
        int extensionState = 0;

        static const char *sipKwdList[] = {
            sipName_mimeType,
            sipName_openCmd,
            sipName_printCmd,
            sipName_description,
            sipName_extension,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1J1J1J1", sipType_wxString, &mimeType, &mimeTypeState, sipType_wxString, &openCmd, &openCmdState, sipType_wxString, &printCmd, &printCmdState, sipType_wxString, &description, &descriptionState, sipType_wxString, &extension, &extensionState))
        {
        PyErr_Clear();
        sipCpp = _wxFileTypeInfo_ctor(mimeType, openCmd, printCmd, description, extension);
            sipReleaseType(const_cast< ::wxString *>(mimeType), sipType_wxString, mimeTypeState);
            sipReleaseType(const_cast< ::wxString *>(openCmd), sipType_wxString, openCmdState);
            sipReleaseType(const_cast< ::wxString *>(printCmd), sipType_wxString, printCmdState);
            sipReleaseType(const_cast< ::wxString *>(description), sipType_wxString, descriptionState);
            sipReleaseType(const_cast< ::wxString *>(extension), sipType_wxString, extensionState);

            return sipCpp;
        }
    }

    {
        const ::wxArrayString* sArray;
        int sArrayState = 0;

        static const char *sipKwdList[] = {
            sipName_sArray,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxArrayString, &sArray, &sArrayState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFileTypeInfo(*sArray);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(sArray), sipType_wxArrayString, sArrayState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxFileTypeInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxFileTypeInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFileTypeInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxFileTypeInfo[] = {
    {sipName_AddExtension, SIP_MLMETH_CAST(meth_wxFileTypeInfo_AddExtension), METH_VARARGS|METH_KEYWORDS, doc_wxFileTypeInfo_AddExtension},
    {sipName_GetDescription, meth_wxFileTypeInfo_GetDescription, METH_VARARGS, doc_wxFileTypeInfo_GetDescription},
    {sipName_GetExtensions, meth_wxFileTypeInfo_GetExtensions, METH_VARARGS, doc_wxFileTypeInfo_GetExtensions},
    {sipName_GetExtensionsCount, meth_wxFileTypeInfo_GetExtensionsCount, METH_VARARGS, doc_wxFileTypeInfo_GetExtensionsCount},
    {sipName_GetIconFile, meth_wxFileTypeInfo_GetIconFile, METH_VARARGS, doc_wxFileTypeInfo_GetIconFile},
    {sipName_GetIconIndex, meth_wxFileTypeInfo_GetIconIndex, METH_VARARGS, doc_wxFileTypeInfo_GetIconIndex},
    {sipName_GetMimeType, meth_wxFileTypeInfo_GetMimeType, METH_VARARGS, doc_wxFileTypeInfo_GetMimeType},
    {sipName_GetOpenCommand, meth_wxFileTypeInfo_GetOpenCommand, METH_VARARGS, doc_wxFileTypeInfo_GetOpenCommand},
    {sipName_GetPrintCommand, meth_wxFileTypeInfo_GetPrintCommand, METH_VARARGS, doc_wxFileTypeInfo_GetPrintCommand},
    {sipName_GetShortDesc, meth_wxFileTypeInfo_GetShortDesc, METH_VARARGS, doc_wxFileTypeInfo_GetShortDesc},
    {sipName_SetDescription, SIP_MLMETH_CAST(meth_wxFileTypeInfo_SetDescription), METH_VARARGS|METH_KEYWORDS, doc_wxFileTypeInfo_SetDescription},
    {sipName_SetIcon, SIP_MLMETH_CAST(meth_wxFileTypeInfo_SetIcon), METH_VARARGS|METH_KEYWORDS, doc_wxFileTypeInfo_SetIcon},
    {sipName_SetOpenCommand, SIP_MLMETH_CAST(meth_wxFileTypeInfo_SetOpenCommand), METH_VARARGS|METH_KEYWORDS, doc_wxFileTypeInfo_SetOpenCommand},
    {sipName_SetPrintCommand, SIP_MLMETH_CAST(meth_wxFileTypeInfo_SetPrintCommand), METH_VARARGS|METH_KEYWORDS, doc_wxFileTypeInfo_SetPrintCommand},
    {sipName_SetShortDesc, SIP_MLMETH_CAST(meth_wxFileTypeInfo_SetShortDesc), METH_VARARGS|METH_KEYWORDS, doc_wxFileTypeInfo_SetShortDesc}
};

sipVariableDef variables_wxFileTypeInfo[] = {
    {PropertyVariable, sipName_ShortDesc, &methods_wxFileTypeInfo[9], &methods_wxFileTypeInfo[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PrintCommand, &methods_wxFileTypeInfo[8], &methods_wxFileTypeInfo[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OpenCommand, &methods_wxFileTypeInfo[7], &methods_wxFileTypeInfo[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MimeType, &methods_wxFileTypeInfo[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_IconIndex, &methods_wxFileTypeInfo[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_IconFile, &methods_wxFileTypeInfo[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ExtensionsCount, &methods_wxFileTypeInfo[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Extensions, &methods_wxFileTypeInfo[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Description, &methods_wxFileTypeInfo[1], &methods_wxFileTypeInfo[10], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxFileTypeInfo, "FileTypeInfo() -> None\n"
"FileTypeInfo(mimeType) -> None\n"
"FileTypeInfo(mimeType, openCmd, printCmd, description, extension) -> None\n"
"FileTypeInfo(sArray) -> None\n"
"\n"
"Container of information about wxFileType.");


sipClassTypeDef sipTypeDef__core_wxFileTypeInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxFileTypeInfo,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_FileTypeInfo,
        {0, 0, 1},
        15, methods_wxFileTypeInfo,
        0, SIP_NULLPTR,
        9, variables_wxFileTypeInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxFileTypeInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxFileTypeInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxFileTypeInfo,
    assign_wxFileTypeInfo,
    array_wxFileTypeInfo,
    copy_wxFileTypeInfo,
    release_wxFileTypeInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxFileTypeInfo,
    sizeof (::wxFileTypeInfo),
};
